/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tools;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.ex.ActionManagerEx;
import com.intellij.openapi.options.SchemeManager;
import com.intellij.openapi.options.SchemeManagerFactory;
import com.intellij.openapi.options.SchemeProcessor;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.tools.Tool;
import com.intellij.tools.ToolAction;
import com.intellij.tools.ToolsGroup;
import com.intellij.util.SmartList;
import gnu.trove.THashSet;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BaseToolManager<T extends Tool> {
    @NotNull
    private final ActionManagerEx myActionManager;
    private final SchemeManager<ToolsGroup<T>> mySchemeManager;

    public BaseToolManager(@NotNull ActionManagerEx actionManagerEx, @NotNull SchemeManagerFactory factory2, @NotNull String schemePath, @NotNull String presentableName) {
        if (actionManagerEx == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "actionManagerEx", "com/intellij/tools/BaseToolManager", "<init>"));
        }
        if (factory2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "factory", "com/intellij/tools/BaseToolManager", "<init>"));
        }
        if (schemePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "schemePath", "com/intellij/tools/BaseToolManager", "<init>"));
        }
        if (presentableName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "presentableName", "com/intellij/tools/BaseToolManager", "<init>"));
        }
        this.myActionManager = actionManagerEx;
        this.mySchemeManager = factory2.create(schemePath, this.createProcessor(), presentableName);
        this.mySchemeManager.loadSchemes();
        this.registerActions();
    }

    protected abstract SchemeProcessor<ToolsGroup<T>, ToolsGroup<T>> createProcessor();

    @Nullable
    public static String convertString(String s2) {
        return StringUtil.nullize((String)s2, (boolean)true);
    }

    public List<T> getTools() {
        SmartList result2 = new SmartList();
        for (ToolsGroup<T> group : this.mySchemeManager.getAllSchemes()) {
            result2.addAll(group.getElements());
        }
        return result2;
    }

    @NotNull
    public List<T> getTools(@NotNull String group) {
        if (group == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "group", "com/intellij/tools/BaseToolManager", "getTools"));
        }
        ToolsGroup<T> groupByName = this.mySchemeManager.findSchemeByName(group);
        if (groupByName == null) {
            List list2 = Collections.emptyList();
            if (list2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tools/BaseToolManager", "getTools"));
            }
            return list2;
        }
        List list3 = groupByName.getElements();
        if (list3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tools/BaseToolManager", "getTools"));
        }
        return list3;
    }

    public String getGroupByActionId(String actionId) {
        for (Tool tool : this.getTools()) {
            if (!Comparing.equal((String)actionId, (String)tool.getActionId())) continue;
            return tool.getGroup();
        }
        return null;
    }

    public List<ToolsGroup<T>> getGroups() {
        return this.mySchemeManager.getAllSchemes();
    }

    public void setTools(@NotNull List<ToolsGroup<T>> tools) {
        if (tools == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tools", "com/intellij/tools/BaseToolManager", "setTools"));
        }
        this.mySchemeManager.setSchemes(tools);
        this.registerActions();
    }

    void registerActions() {
        this.unregisterActions();
        THashSet registeredIds = new THashSet();
        for (Tool tool : this.getTools()) {
            String actionId = tool.getActionId();
            if (!registeredIds.add(actionId)) continue;
            this.myActionManager.registerAction(actionId, (AnAction)this.createToolAction(tool));
        }
    }

    @NotNull
    protected ToolAction createToolAction(@NotNull T tool) {
        if (tool == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tool", "com/intellij/tools/BaseToolManager", "createToolAction"));
        }
        ToolAction toolAction = new ToolAction((Tool)tool);
        if (toolAction == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tools/BaseToolManager", "createToolAction"));
        }
        return toolAction;
    }

    protected abstract String getActionIdPrefix();

    private void unregisterActions() {
        for (String oldId : this.myActionManager.getActionIds(this.getActionIdPrefix())) {
            this.myActionManager.unregisterAction(oldId);
        }
    }
}

