/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tools;

import com.intellij.execution.process.ProcessListener;
import com.intellij.ide.macro.MacroManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.project.DumbAware;
import com.intellij.tools.HackyDataContext;
import com.intellij.tools.Tool;
import com.intellij.tools.ToolRunProfile;
import com.intellij.tools.ToolsProvider;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ToolAction
extends AnAction
implements DumbAware {
    private final String myActionId;

    public ToolAction(@NotNull Tool tool) {
        if (tool == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tool", "com/intellij/tools/ToolAction", "<init>"));
        }
        this.myActionId = tool.getActionId();
        this.getTemplatePresentation().setText(tool.getName(), false);
        this.getTemplatePresentation().setDescription(tool.getDescription());
    }

    public void actionPerformed(AnActionEvent e2) {
        ToolAction.runTool(this.myActionId, e2.getDataContext(), e2, 0L, null);
    }

    public void update(AnActionEvent e2) {
        Tool tool = ToolAction.findTool(this.myActionId, e2.getDataContext());
        if (tool != null) {
            e2.getPresentation().setText(ToolRunProfile.expandMacrosInName(tool, e2.getDataContext()));
        }
    }

    private static Tool findTool(String actionId, DataContext context2) {
        MacroManager.getInstance().cacheMacrosPreview(context2);
        for (Tool tool : ToolAction.getAllTools()) {
            if (!actionId.equals(tool.getActionId())) continue;
            return tool;
        }
        return null;
    }

    protected static List<Tool> getAllTools() {
        return ToolsProvider.getAllTools();
    }

    static void runTool(String actionId, DataContext context2) {
        ToolAction.runTool(actionId, context2, null, 0L, null);
    }

    static void runTool(String actionId, DataContext context2, @Nullable AnActionEvent e2, long executionId, @Nullable ProcessListener processListener2) {
        Tool tool = ToolAction.findTool(actionId, context2);
        if (tool != null) {
            tool.execute(e2, new HackyDataContext(context2), executionId, processListener2);
        }
    }
}

