/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.openapi.vcs.changes.RefreshablePanel;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.UIManager;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractTitledSeparatorWithIcon
extends JPanel {
    protected RefreshablePanel myDetailsComponent;
    protected final JLabel myLabel;
    private String originalText;
    protected final JPanel myWrapper;
    protected boolean myOn;
    protected final Icon myIcon;
    protected final Icon myIconOpen;
    protected final JSeparator mySeparator;

    public AbstractTitledSeparatorWithIcon(@NotNull Icon icon, @NotNull Icon iconOpen, @NotNull String text2) {
        if (icon == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "icon", "com/intellij/ui/AbstractTitledSeparatorWithIcon", "<init>"));
        }
        if (iconOpen == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "iconOpen", "com/intellij/ui/AbstractTitledSeparatorWithIcon", "<init>"));
        }
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/ui/AbstractTitledSeparatorWithIcon", "<init>"));
        }
        this.myIcon = icon;
        this.myIconOpen = iconOpen;
        this.setLayout(new GridBagLayout());
        this.myLabel = new JLabel(icon);
        this.add((Component)this.myLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 8), 0, 0));
        Color oldColor = UIManager.getColor("Separator.foreground");
        UIManager.put("Separator.foreground", UIUtil.getBorderColor());
        this.mySeparator = new JSeparator(0);
        UIManager.put("Separator.foreground", oldColor);
        GridBagConstraints gb2 = new GridBagConstraints(1, 0, 0, 1, 1.0, 0.0, 10, 2, new Insets(3, 0, 0, 0), 0, 0);
        this.add((Component)this.mySeparator, gb2);
        this.setBorder(IdeBorderFactory.createEmptyBorder((int)3, (int)0, (int)5, (int)5));
        this.myLabel.setFont(UIUtil.getTitledBorderFont());
        this.myLabel.setForeground(UIUtil.getLabelForeground());
        this.originalText = text2;
        this.myLabel.setText(UIUtil.replaceMnemonicAmpersand((String)this.originalText));
        ++gb2.gridy;
        gb2.gridx = 0;
        gb2.fill = 1;
        gb2.anchor = 18;
        gb2.weighty = 1.0;
        this.myWrapper = new JPanel(new BorderLayout());
        this.add((Component)this.myWrapper, gb2);
        this.myLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e2) {
                if (AbstractTitledSeparatorWithIcon.this.myOn) {
                    AbstractTitledSeparatorWithIcon.this.off();
                } else {
                    AbstractTitledSeparatorWithIcon.this.on();
                }
            }

            @Override
            public void mouseEntered(MouseEvent e2) {
                AbstractTitledSeparatorWithIcon.this.setCursor(new Cursor(12));
            }

            @Override
            public void mouseExited(MouseEvent e2) {
                AbstractTitledSeparatorWithIcon.this.setCursor(new Cursor(0));
            }
        });
    }

    public void setText(String text2) {
        this.myLabel.setText(UIUtil.replaceMnemonicAmpersand((String)text2));
    }

    protected abstract RefreshablePanel createPanel();

    protected void initDetails() {
        if (this.myDetailsComponent != null) {
            this.myDetailsComponent.refresh();
            return;
        }
        this.myDetailsComponent = this.createPanel();
    }

    public void on() {
        this.initDetails();
        this.myOn = true;
        this.myLabel.setIcon(this.myIconOpen);
        this.onImpl();
    }

    public void initOn() {
        this.initDetails();
        this.myOn = true;
        this.myLabel.setIcon(this.myIconOpen);
        this.initOnImpl();
    }

    protected abstract void initOnImpl();

    public void off() {
        this.myOn = false;
        this.myLabel.setIcon(this.myIcon);
        this.offImpl();
    }

    protected abstract void onImpl();

    protected abstract void offImpl();
}

