/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.icons.AllIcons;
import com.intellij.ide.FrameStateListener;
import com.intellij.ide.FrameStateManager;
import com.intellij.ide.IdeEventQueue;
import com.intellij.ide.IdeTooltip;
import com.intellij.ide.RemoteDesktopService;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.MnemonicHelper;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.ex.AnActionListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.ui.GraphicsConfig;
import com.intellij.openapi.ui.impl.ShadowBorderPainter;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.ui.popup.LightweightWindow;
import com.intellij.openapi.ui.popup.LightweightWindowEvent;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.ExpirableRunnable;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UnfairTextRange;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.IdeGlassPaneUtil;
import com.intellij.openapi.wm.impl.IdeGlassPaneEx;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.ComponentWithMnemonics;
import com.intellij.ui.HyperlinkAdapter;
import com.intellij.ui.ScreenUtil;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.panels.NonOpaquePanel;
import com.intellij.ui.components.panels.Wrapper;
import com.intellij.util.Alarm;
import com.intellij.util.Consumer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.HashSet;
import com.intellij.util.ui.Animator;
import com.intellij.util.ui.BaseButtonBehavior;
import com.intellij.util.ui.ImageUtil;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.PositionTracker;
import com.intellij.util.ui.TimedDeadzone;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.accessibility.AccessibleContextUtil;
import com.intellij.util.ui.accessibility.ScreenReader;
import java.awt.AWTEvent;
import java.awt.AlphaComposite;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.AWTEventListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.ImageFilter;
import java.awt.image.RGBImageFilter;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.MenuElement;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.intellij.lang.annotations.JdkConstants;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BalloonImpl
implements Balloon,
IdeTooltip.Ui {
    public static final int DIALOG_ARC = 6;
    public static final int ARC = 3;
    public static final int DIALOG_TOPBOTTOM_POINTER_WIDTH = 24;
    public static final int DIALOG_POINTER_WIDTH = 17;
    public static final int TOPBOTTOM_POINTER_WIDTH = 14;
    public static final int POINTER_WIDTH = 11;
    public static final int DIALOG_TOPBOTTOM_POINTER_LENGTH = 16;
    public static final int DIALOG_POINTER_LENGTH = 14;
    public static final int TOPBOTTOM_POINTER_LENGTH = 10;
    public static final int POINTER_LENGTH = 8;
    private final Alarm myFadeoutAlarm;
    private long myFadeoutRequestMillis;
    private int myFadeoutRequestDelay;
    private boolean mySmartFadeout;
    private boolean mySmartFadeoutPaused;
    private int mySmartFadeoutDelay;
    private MyComponent myComp;
    private JLayeredPane myLayeredPane;
    private AbstractPosition myPosition;
    private Point myTargetPoint;
    private final boolean myHideOnFrameResize;
    private final boolean myHideOnLinkClick;
    private final Color myBorderColor;
    private final Insets myBorderInsets;
    private final Color myFillColor;
    private final Insets myContainerInsets;
    private boolean myLastMoveWasInsideBalloon;
    private Rectangle myForcedBounds;
    private ActionProvider myActionProvider;
    private List<ActionButton> myActionButtons;
    private final AWTEventListener myAwtActivityListener;
    private final long myFadeoutTime;
    private Dimension myDefaultPrefSize;
    private final ActionListener myClickHandler;
    private final boolean myCloseOnClick;
    private int myShadowSize;
    private ShadowBorderProvider myShadowBorderProvider;
    private final CopyOnWriteArraySet<JBPopupListener> myListeners;
    private boolean myVisible;
    private PositionTracker<Balloon> myTracker;
    private final int myAnimationCycle;
    private boolean myFadedIn;
    private boolean myFadedOut;
    private final int myCalloutShift;
    private final int myPositionChangeXShift;
    private final int myPositionChangeYShift;
    private boolean myDialogMode;
    private IdeFocusManager myFocusManager;
    private final String myTitle;
    private JLabel myTitleLabel;
    private boolean myAnimationEnabled;
    private boolean myShadow;
    private final Balloon.Layer myLayer;
    private final boolean myBlockClicks;
    private RelativePoint myPrevMousePoint;
    private final ComponentAdapter myComponentListener;
    private Animator myAnimator;
    private boolean myShowPointer;
    private boolean myDisposed;
    private final JComponent myContent;
    private boolean myHideOnMouse;
    private Runnable myHideListener;
    private final boolean myHideOnKey;
    private final boolean myHideOnAction;
    private final boolean myHideOnCloseClick;
    private final boolean myRequestFocus;
    private Component myOriginalFocusOwner;
    private final boolean myEnableButtons;
    private final Dimension myPointerSize;
    private final int myCornerToPointerDistance;
    private boolean myTraceDispose;
    public static final AbstractPosition BELOW = new Below();
    public static final AbstractPosition ABOVE = new Above();
    public static final AbstractPosition AT_RIGHT = new AtRight();
    public static final AbstractPosition AT_LEFT = new AtLeft();

    private boolean isWithinChildWindow(MouseEvent event) {
        Container child;
        Window owner = UIUtil.getWindow((Component)this.myContent);
        if (owner != null && (child = UIUtil.getWindow((Component)event.getComponent())) != owner) {
            while (child != null) {
                if (child == owner) {
                    return true;
                }
                child = child.getParent();
            }
        }
        return false;
    }

    public boolean isInsideBalloon(MouseEvent me) {
        return this.isInside(new RelativePoint(me));
    }

    @Override
    public boolean isInside(@NotNull RelativePoint target) {
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "com/intellij/ui/BalloonImpl", "isInside"));
        }
        if (this.myComp == null) {
            return false;
        }
        Component cmp = target.getOriginalComponent();
        if (!cmp.isShowing()) {
            return true;
        }
        if (cmp instanceof MenuElement) {
            return false;
        }
        if (this.myActionButtons != null) {
            for (ActionButton button : this.myActionButtons) {
                if (cmp != button) continue;
                return true;
            }
        }
        if (UIUtil.isDescendingFrom((Component)cmp, (Component)this.myComp)) {
            return true;
        }
        if (this.myComp == null || !this.myComp.isShowing()) {
            return false;
        }
        Point point = target.getScreenPoint();
        SwingUtilities.convertPointFromScreen(point, this.myComp);
        return this.myComp.contains(point);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isMovingForward(RelativePoint target) {
        try {
            if (this.myComp == null || !this.myComp.isShowing()) {
                boolean bl = false;
                return bl;
            }
            if (this.myPrevMousePoint == null) {
                boolean bl = true;
                return bl;
            }
            if (this.myPrevMousePoint.getComponent() != target.getComponent()) {
                boolean bl = false;
                return bl;
            }
            Rectangle rectangleOnScreen = new Rectangle(this.myComp.getLocationOnScreen(), this.myComp.getSize());
            boolean bl = ScreenUtil.isMovementTowards((Point)this.myPrevMousePoint.getScreenPoint(), (Point)target.getScreenPoint(), (Rectangle)rectangleOnScreen);
            return bl;
        }
        finally {
            this.myPrevMousePoint = target;
        }
    }

    /*
     * WARNING - void declaration
     */
    public BalloonImpl(@NotNull JComponent content2, @NotNull Color borderColor, Insets borderInsets, @NotNull Color fillColor, boolean hideOnMouse, boolean hideOnKey, boolean hideOnAction, boolean hideOnCloseClick, boolean showPointer, boolean enableButtons, long fadeoutTime, boolean hideOnFrameResize, boolean hideOnLinkClick, ActionListener clickHandler, boolean closeOnClick, int animationCycle, int calloutShift, int positionChangeXShift, int positionChangeYShift, boolean dialogMode, String title, Insets contentInsets, boolean shadow, boolean smallVariant, boolean blockClicks, Balloon.Layer layer, boolean requestFocus2, Dimension pointerSize, int n2) {
        void cornerToPointerDistance;
        if (content2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/ui/BalloonImpl", "<init>"));
        }
        if (borderColor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "borderColor", "com/intellij/ui/BalloonImpl", "<init>"));
        }
        if (fillColor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fillColor", "com/intellij/ui/BalloonImpl", "<init>"));
        }
        this.myFadeoutAlarm = new Alarm((Disposable)this);
        this.myFadeoutRequestMillis = 0L;
        this.myFadeoutRequestDelay = 0;
        this.myAwtActivityListener = new AWTEventListener(){

            @Override
            public void eventDispatched(AWTEvent e2) {
                if (BalloonImpl.this.mySmartFadeoutDelay > 0) {
                    BalloonImpl.this.startFadeoutTimer(BalloonImpl.this.mySmartFadeoutDelay);
                    BalloonImpl.this.mySmartFadeoutDelay = 0;
                }
                int id = e2.getID();
                if (e2 instanceof MouseEvent) {
                    MouseEvent me = (MouseEvent)e2;
                    boolean insideBalloon = BalloonImpl.this.isInsideBalloon(me);
                    if (BalloonImpl.this.myHideOnMouse && id == 501) {
                        if (!insideBalloon && !BalloonImpl.this.isWithinChildWindow(me)) {
                            if (BalloonImpl.this.myHideListener == null) {
                                BalloonImpl.this.hide();
                            } else {
                                BalloonImpl.this.myHideListener.run();
                            }
                        }
                        return;
                    }
                    if (BalloonImpl.this.myClickHandler != null && id == 500 && !(me.getComponent() instanceof CloseButton) && insideBalloon) {
                        BalloonImpl.this.myClickHandler.actionPerformed(new ActionEvent(me, 1001, "click", me.getModifiersEx()));
                        if (BalloonImpl.this.myCloseOnClick) {
                            BalloonImpl.this.hide();
                            return;
                        }
                    }
                    if (BalloonImpl.this.myEnableButtons && id == 503) {
                        boolean moveChanged = insideBalloon != BalloonImpl.this.myLastMoveWasInsideBalloon;
                        BalloonImpl.this.myLastMoveWasInsideBalloon = insideBalloon;
                        if (moveChanged) {
                            if (insideBalloon && BalloonImpl.this.myFadeoutAlarm.getActiveRequestCount() > 0) {
                                BalloonImpl.this.myFadeoutAlarm.cancelAllRequests();
                                BalloonImpl.this.myFadeoutRequestDelay = (int)((long)BalloonImpl.this.myFadeoutRequestDelay - (System.currentTimeMillis() - BalloonImpl.this.myFadeoutRequestMillis));
                            }
                            if (!insideBalloon && BalloonImpl.this.myFadeoutRequestDelay > 0) {
                                BalloonImpl.this.startFadeoutTimer(BalloonImpl.this.myFadeoutRequestDelay);
                            }
                            BalloonImpl.this.myComp.repaintButton();
                        }
                    }
                    if (BalloonImpl.this.myHideOnCloseClick && UIUtil.isCloseClick((MouseEvent)me)) {
                        if (BalloonImpl.this.isInsideBalloon(me)) {
                            BalloonImpl.this.hide();
                            me.consume();
                        }
                        return;
                    }
                }
                if ((BalloonImpl.this.myHideOnKey || BalloonImpl.this.myHideListener != null) && e2 instanceof KeyEvent && id == 401) {
                    KeyEvent ke = (KeyEvent)e2;
                    if (BalloonImpl.this.myHideListener != null) {
                        if (ke.getKeyCode() == 27) {
                            BalloonImpl.this.myHideListener.run();
                        }
                        return;
                    }
                    if (ke.getKeyCode() != 16 && ke.getKeyCode() != 17 && ke.getKeyCode() != 18 && ke.getKeyCode() != 157) {
                        boolean doHide = false;
                        if (ke.getKeyCode() == 27 && SwingUtilities.isDescendingFrom(ke.getComponent(), BalloonImpl.this.myComp)) {
                            doHide = true;
                        }
                        if (BalloonImpl.this.myHideOnKey && !SwingUtilities.isDescendingFrom(ke.getComponent(), BalloonImpl.this.myComp)) {
                            doHide = true;
                        }
                        if (doHide) {
                            BalloonImpl.this.hide();
                        }
                    }
                }
            }
        };
        this.myShadowSize = Registry.intValue((String)"ide.balloon.shadow.size");
        this.myListeners = new CopyOnWriteArraySet();
        this.myAnimationEnabled = true;
        this.myShadow = UIUtil.isUnderDarcula();
        this.myPrevMousePoint = null;
        this.myComponentListener = new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e2) {
                if (BalloonImpl.this.myHideOnFrameResize) {
                    BalloonImpl.this.hide();
                }
            }
        };
        this.myBorderColor = borderColor;
        this.myBorderInsets = borderInsets != null ? borderInsets : JBUI.insets((int)3);
        this.myFillColor = fillColor;
        this.myContent = content2;
        this.myHideOnMouse = hideOnMouse;
        this.myHideOnKey = hideOnKey;
        this.myHideOnAction = hideOnAction;
        this.myHideOnCloseClick = hideOnCloseClick;
        this.myShowPointer = showPointer;
        this.myEnableButtons = enableButtons;
        this.myHideOnFrameResize = hideOnFrameResize;
        this.myHideOnLinkClick = hideOnLinkClick;
        this.myClickHandler = clickHandler;
        this.myCloseOnClick = closeOnClick;
        this.myCalloutShift = calloutShift;
        this.myPositionChangeXShift = positionChangeXShift;
        this.myPositionChangeYShift = positionChangeYShift;
        this.myDialogMode = dialogMode;
        this.myTitle = title;
        this.myLayer = layer != null ? layer : Balloon.Layer.normal;
        this.myBlockClicks = blockClicks;
        this.myRequestFocus = requestFocus2;
        MnemonicHelper.init((Component)content2);
        if (!this.myDialogMode) {
            for (Component component : UIUtil.uiTraverser((Component)this.myContent)) {
                JCheckBox checkBox2;
                if (component instanceof JLabel) {
                    JLabel label = (JLabel)component;
                    if (label.getDisplayedMnemonic() == 0 && label.getDisplayedMnemonicIndex() < 0) continue;
                    this.myDialogMode = true;
                    break;
                }
                if (!(component instanceof JCheckBox) || (checkBox2 = (JCheckBox)component).getMnemonic() < 0 && checkBox2.getDisplayedMnemonicIndex() < 0) continue;
                this.myDialogMode = true;
                break;
            }
        }
        this.myShadow = shadow;
        this.myShadowSize = Registry.intValue((String)"ide.balloon.shadow.size");
        this.myContainerInsets = contentInsets;
        this.myFadeoutTime = fadeoutTime;
        this.myAnimationCycle = animationCycle;
        this.myPointerSize = pointerSize;
        this.myCornerToPointerDistance = cornerToPointerDistance;
        if (smallVariant) {
            for (Component component : UIUtil.uiTraverser((Component)this.myContent)) {
                UIUtil.applyStyle((UIUtil.ComponentStyle)UIUtil.ComponentStyle.SMALL, (Component)component);
            }
        }
    }

    public void show(RelativePoint target, Balloon.Position position) {
        this.show(target, BalloonImpl.getAbstractPositionFor(position));
    }

    public int getLayer() {
        Integer result2 = JLayeredPane.DEFAULT_LAYER;
        switch (this.myLayer) {
            case normal: {
                result2 = JLayeredPane.POPUP_LAYER;
                break;
            }
            case top: {
                result2 = JLayeredPane.DRAG_LAYER;
            }
        }
        return result2;
    }

    private static AbstractPosition getAbstractPositionFor(Balloon.Position position) {
        switch (position) {
            case atLeft: {
                return AT_LEFT;
            }
            case atRight: {
                return AT_RIGHT;
            }
            case below: {
                return BELOW;
            }
            case above: {
                return ABOVE;
            }
        }
        return BELOW;
    }

    public void show(PositionTracker<Balloon> tracker, Balloon.Position position) {
        this.show(tracker, BalloonImpl.getAbstractPositionFor(position));
    }

    private Insets getInsetsCopy() {
        return new Insets(this.myBorderInsets.top, this.myBorderInsets.left, this.myBorderInsets.bottom, this.myBorderInsets.right);
    }

    private void show(RelativePoint target, AbstractPosition position) {
        this.show((PositionTracker<Balloon>)new PositionTracker.Static(target), position);
    }

    private void show(PositionTracker<Balloon> tracker, AbstractPosition position) {
        JEditorPane editorPane;
        Rectangle rec;
        boolean mnemonicsFix;
        assert (!this.myDisposed) : "Balloon is already disposed";
        if (this.isVisible()) {
            return;
        }
        Component comp = tracker.getComponent();
        if (!comp.isShowing()) {
            return;
        }
        this.myTracker = tracker;
        this.myTracker.init((PositionTracker.Client)this);
        JRootPane root = (JRootPane)ObjectUtils.notNull((Object)UIUtil.getRootPane((Component)comp));
        this.myVisible = true;
        this.myLayeredPane = root.getLayeredPane();
        this.myPosition = position;
        UIUtil.setFutureRootPane((JComponent)this.myContent, (JRootPane)root);
        this.myFocusManager = IdeFocusManager.findInstanceByComponent((Component)this.myLayeredPane);
        final Ref originalFocusOwner = new Ref();
        final Ref focusRequestor = new Ref();
        Ref proxyFocusRequest = new Ref((Object)ActionCallback.DONE);
        boolean bl = mnemonicsFix = this.myDialogMode && SystemInfo.isMac && Registry.is((String)"ide.mac.inplaceDialogMnemonicsFix");
        if (mnemonicsFix) {
            IdeGlassPaneEx glassPane = (IdeGlassPaneEx)IdeGlassPaneUtil.find((Component)this.myLayeredPane);
            assert (glassPane != null);
            proxyFocusRequest.set((Object)new ActionCallback());
            this.myFocusManager.doWhenFocusSettlesDown(new ExpirableRunnable(){

                public boolean isExpired() {
                    return BalloonImpl.this.isDisposed();
                }

                public void run() {
                    IdeEventQueue.getInstance().disableInputMethods((Disposable)BalloonImpl.this);
                    originalFocusOwner.set((Object)BalloonImpl.this.myFocusManager.getFocusOwner());
                    focusRequestor.set((Object)BalloonImpl.this.myFocusManager.getFurtherRequestor());
                }
            });
        }
        if (this.myRequestFocus) {
            this.myFocusManager.doWhenFocusSettlesDown(new ExpirableRunnable(){

                public boolean isExpired() {
                    return BalloonImpl.this.isDisposed();
                }

                public void run() {
                    BalloonImpl.this.myOriginalFocusOwner = BalloonImpl.this.myFocusManager.getFocusOwner();
                    AccessibleContextUtil.setParent((JComponent)BalloonImpl.this.myContent, (Component)BalloonImpl.this.myOriginalFocusOwner);
                    BalloonImpl.this.myFocusManager.requestFocus(BalloonImpl.this.getContentToFocus(), true);
                }
            });
        }
        this.myLayeredPane.addComponentListener(this.myComponentListener);
        this.myTargetPoint = this.myPosition.getShiftedPoint(this.myTracker.recalculateLocation((Object)this).getPoint((Component)this.myLayeredPane), this.myCalloutShift);
        int positionChangeFix = 0;
        if (this.myShowPointer && !this.myPosition.isOkToHavePointer(this.myTargetPoint, rec = this.getRecForPosition(this.myPosition, true), this.getPointerLength(this.myPosition), this.getPointerWidth(this.myPosition), this.getArc())) {
            rec = this.getRecForPosition(this.myPosition, false);
            Rectangle lp = new Rectangle(new Point(this.myContainerInsets.left, this.myContainerInsets.top), this.myLayeredPane.getSize());
            lp.width -= this.myContainerInsets.right;
            lp.height -= this.myContainerInsets.bottom;
            if (!lp.contains(rec)) {
                Rectangle2D currentSquare = lp.createIntersection(rec);
                double maxSquare = currentSquare.getWidth() * currentSquare.getHeight();
                AbstractPosition targetPosition = this.myPosition;
                for (AbstractPosition eachPosition : this.myPosition.getOtherPositions()) {
                    Rectangle2D eachIntersection = lp.createIntersection(this.getRecForPosition(eachPosition, false));
                    double eachSquare = eachIntersection.getWidth() * eachIntersection.getHeight();
                    if (!(maxSquare < eachSquare)) continue;
                    maxSquare = eachSquare;
                    targetPosition = eachPosition;
                }
                this.myPosition = targetPosition;
                positionChangeFix = this.myPosition.getChangeShift(position, this.myPositionChangeXShift, this.myPositionChangeYShift);
            }
        }
        if (this.myPosition != position) {
            this.myTargetPoint = this.myPosition.getShiftedPoint(this.myTracker.recalculateLocation((Object)this).getPoint((Component)this.myLayeredPane), this.myCalloutShift > 0 ? this.myCalloutShift + positionChangeFix : positionChangeFix);
        }
        this.createComponent();
        this.myComp.validate();
        rec = this.myComp.getContentBounds();
        if (this.myShowPointer && !this.myPosition.isOkToHavePointer(this.myTargetPoint, rec, this.getPointerLength(this.myPosition), this.getPointerWidth(this.myPosition), this.getArc())) {
            this.myShowPointer = false;
            this.myComp.removeAll();
            this.myLayeredPane.remove(this.myComp);
            this.createComponent();
            if (!new Rectangle(this.myLayeredPane.getSize()).contains(new Rectangle(this.myComp.getSize()))) {
                this.myComp.removeAll();
                this.myLayeredPane.remove(this.myComp);
                this.myLayeredPane = null;
                this.hide();
                return;
            }
        }
        for (JBPopupListener each : this.myListeners) {
            each.beforeShown(new LightweightWindowEvent((LightweightWindow)this));
        }
        this.runAnimation(true, this.myLayeredPane, null);
        this.myLayeredPane.revalidate();
        this.myLayeredPane.repaint();
        if (mnemonicsFix) {
            ((ActionCallback)proxyFocusRequest.get()).doWhenDone(() -> this.myFocusManager.requestFocus((Component)originalFocusOwner.get(), true));
        }
        Toolkit.getDefaultToolkit().addAWTEventListener(this.myAwtActivityListener, 56L);
        if (ApplicationManager.getApplication() != null) {
            ActionManager.getInstance().addAnActionListener((AnActionListener)new AnActionListener.Adapter(){

                public void beforeActionPerformed(AnAction action2, DataContext dataContext, AnActionEvent event) {
                    if (BalloonImpl.this.myHideOnAction) {
                        BalloonImpl.this.hide();
                    }
                }
            }, (Disposable)this);
        }
        if (this.myHideOnLinkClick && (editorPane = (JEditorPane)UIUtil.uiTraverser((Component)this.myContent).traverse().filter(JEditorPane.class).first()) != null) {
            editorPane.addHyperlinkListener((HyperlinkListener)new HyperlinkAdapter(){

                protected void hyperlinkActivated(HyperlinkEvent e2) {
                    BalloonImpl.this.hide();
                }
            });
        }
    }

    @NotNull
    private Component getContentToFocus() {
        Component child;
        JViewport viewport;
        Component focusComponent = this.myContent;
        while (focusComponent instanceof JScrollPane && (viewport = ((JScrollPane)focusComponent).getViewport()) != null && (child = viewport.getView()) != null) {
            focusComponent = child;
        }
        JComponent jComponent = focusComponent;
        if (jComponent == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/BalloonImpl", "getContentToFocus"));
        }
        return jComponent;
    }

    private Rectangle getRecForPosition(AbstractPosition position, boolean adjust2) {
        Dimension size = this.getContentSizeFor(position);
        Rectangle rec = new Rectangle(new Point(0, 0), size);
        position.setRecToRelativePosition(rec, this.myTargetPoint);
        if (adjust2) {
            rec = this.myPosition.getUpdatedBounds(this, rec.getSize());
        }
        return rec;
    }

    private Dimension getContentSizeFor(AbstractPosition position) {
        Dimension size = this.myContent.getPreferredSize();
        if (this.myShadowBorderProvider == null) {
            JBInsets.addTo((Dimension)size, (Insets)position.createBorder(this).getBorderInsets());
        }
        return size;
    }

    private void disposeButton(ActionButton button) {
        if (button != null && button.getParent() != null) {
            Container parent = button.getParent();
            parent.remove((Component)((Object)button));
            ((JComponent)parent).revalidate();
            parent.repaint();
        }
    }

    public JComponent getContent() {
        return this.myContent;
    }

    public JComponent getComponent() {
        return this.myComp;
    }

    private void createComponent() {
        this.myComp = new MyComponent(this.myContent, this, this.myShadowBorderProvider != null ? null : (this.myShowPointer ? this.myPosition.createBorder(this) : this.getPointlessBorder()));
        if (this.myActionProvider == null) {
            final Consumer listener2 = event -> SwingUtilities.invokeLater(() -> this.hide());
            this.myActionProvider = new ActionProvider(){
                private ActionButton myCloseButton;

                @Override
                @NotNull
                public List<ActionButton> createActions() {
                    this.myCloseButton = new CloseButton(listener2);
                    List<ActionButton> list2 = Collections.singletonList(this.myCloseButton);
                    if (list2 == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/BalloonImpl$7", "createActions"));
                    }
                    return list2;
                }

                @Override
                public void layout(@NotNull Rectangle lpBounds) {
                    if (lpBounds == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lpBounds", "com/intellij/ui/BalloonImpl$7", "layout"));
                    }
                    if (!this.myCloseButton.isVisible()) {
                        return;
                    }
                    Icon icon = BalloonImpl.this.getCloseButton();
                    int iconWidth = icon.getIconWidth();
                    int iconHeight = icon.getIconHeight();
                    Rectangle r2 = new Rectangle(lpBounds.x + lpBounds.width - iconWidth + (int)((double)iconWidth * 0.3), lpBounds.y - (int)((double)iconHeight * 0.3), iconWidth, iconHeight);
                    Insets border = BalloonImpl.this.getShadowBorderInsets();
                    r2.x -= border.left;
                    r2.y -= border.top;
                    this.myCloseButton.setBounds(r2);
                }
            };
        }
        this.myComp.clear();
        this.myComp.myAlpha = this.isAnimationEnabled() ? 0.0f : -1.0f;
        this.myComp.setBorder(new EmptyBorder(this.getShadowBorderInsets()));
        this.myLayeredPane.add(this.myComp);
        this.myLayeredPane.setLayer(this.myComp, this.getLayer(), 0);
        this.myPosition.updateBounds(this);
        if (this.myBlockClicks) {
            this.myComp.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e2) {
                    e2.consume();
                }

                @Override
                public void mousePressed(MouseEvent e2) {
                    e2.consume();
                }

                @Override
                public void mouseReleased(MouseEvent e2) {
                    e2.consume();
                }
            });
        }
    }

    @NotNull
    private EmptyBorder getPointlessBorder() {
        EmptyBorder emptyBorder = new EmptyBorder(this.myBorderInsets);
        if (emptyBorder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/BalloonImpl", "getPointlessBorder"));
        }
        return emptyBorder;
    }

    public void revalidate() {
        this.revalidate(this.myTracker);
    }

    public void revalidate(@NotNull PositionTracker<Balloon> tracker) {
        if (tracker == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tracker", "com/intellij/ui/BalloonImpl", "revalidate"));
        }
        RelativePoint newPosition = tracker.recalculateLocation((Object)this);
        if (newPosition != null) {
            this.myTargetPoint = this.myPosition.getShiftedPoint(newPosition.getPoint((Component)this.myLayeredPane), this.myCalloutShift);
            this.myPosition.updateBounds(this);
        }
    }

    public void setShadowBorderProvider(@NotNull ShadowBorderProvider provider) {
        if (provider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "provider", "com/intellij/ui/BalloonImpl", "setShadowBorderProvider"));
        }
        this.myShadowBorderProvider = provider;
    }

    public int getShadowBorderSize() {
        return this.hasShadow() ? this.myShadowSize : 0;
    }

    @NotNull
    public Insets getShadowBorderInsets() {
        if (this.myShadowBorderProvider != null) {
            Insets insets = this.myShadowBorderProvider.getInsets();
            if (insets == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/BalloonImpl", "getShadowBorderInsets"));
            }
            return insets;
        }
        int size = this.getShadowBorderSize();
        Insets insets = new Insets(size, size, size, size);
        if (insets == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/BalloonImpl", "getShadowBorderInsets"));
        }
        return insets;
    }

    public boolean hasShadow() {
        return this.myShadowBorderProvider != null || this.myShadow && Registry.is((String)"ide.balloon.shadowEnabled");
    }

    public void show(JLayeredPane pane) {
        this.show(pane, null);
    }

    public void showInCenterOf(JComponent component) {
        Dimension size = component.getSize();
        this.show(new RelativePoint((Component)component, new Point(size.width / 2, size.height / 2)), Balloon.Position.above);
    }

    public void show(JLayeredPane pane, @Nullable Rectangle bounds) {
        if (bounds != null) {
            this.myForcedBounds = bounds;
        }
        this.show(new RelativePoint((Component)pane, new Point(0, 0)), Balloon.Position.above);
    }

    private void runAnimation(boolean forward, final JLayeredPane layeredPane, final @Nullable Runnable onDone) {
        if (this.myAnimator != null) {
            Disposer.dispose((Disposable)this.myAnimator);
        }
        this.myAnimator = new Animator("Balloon", 8, this.isAnimationEnabled() ? this.myAnimationCycle : 0, false, forward){

            public void paintNow(int frame, int totalFrames, int cycle) {
                if (BalloonImpl.this.myComp == null || BalloonImpl.this.myComp.getParent() == null || !BalloonImpl.this.isAnimationEnabled()) {
                    return;
                }
                BalloonImpl.this.myComp.setAlpha((float)frame / (float)totalFrames);
            }

            protected void paintCycleEnd() {
                if (BalloonImpl.this.myComp == null || BalloonImpl.this.myComp.getParent() == null) {
                    return;
                }
                if (this.isForward()) {
                    BalloonImpl.this.myComp.clear();
                    BalloonImpl.this.myComp.repaint();
                    BalloonImpl.this.myFadedIn = true;
                    if (!BalloonImpl.this.myFadeoutAlarm.isDisposed()) {
                        BalloonImpl.this.startFadeoutTimer((int)BalloonImpl.this.myFadeoutTime);
                    }
                } else {
                    layeredPane.remove(BalloonImpl.this.myComp);
                    layeredPane.revalidate();
                    layeredPane.repaint();
                }
                Disposer.dispose((Disposable)this);
            }

            public void dispose() {
                super.dispose();
                BalloonImpl.this.myAnimator = null;
                if (onDone != null) {
                    onDone.run();
                }
            }
        };
        this.myAnimator.resume();
    }

    public void runWithSmartFadeoutPause(@NotNull Runnable handler2) {
        if (handler2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "handler", "com/intellij/ui/BalloonImpl", "runWithSmartFadeoutPause"));
        }
        if (this.mySmartFadeout) {
            this.mySmartFadeoutPaused = true;
            handler2.run();
            if (this.mySmartFadeoutPaused) {
                this.mySmartFadeoutPaused = false;
            } else {
                this.setAnimationEnabled(true);
                this.hide();
            }
        } else {
            handler2.run();
        }
    }

    public void startSmartFadeoutTimer(int delay) {
        this.mySmartFadeout = true;
        this.mySmartFadeoutDelay = delay;
        FrameStateManager.getInstance().addListener((FrameStateListener)new FrameStateListener.Adapter(){

            public void onFrameDeactivated() {
                if (BalloonImpl.this.myFadeoutAlarm.getActiveRequestCount() > 0) {
                    BalloonImpl.this.myFadeoutAlarm.cancelAllRequests();
                    BalloonImpl.this.mySmartFadeoutDelay = BalloonImpl.this.myFadeoutRequestDelay - (int)(System.currentTimeMillis() - BalloonImpl.this.myFadeoutRequestMillis);
                    if (BalloonImpl.this.mySmartFadeoutDelay <= 0) {
                        BalloonImpl.this.mySmartFadeoutDelay = 1;
                    }
                }
            }
        }, (Disposable)this);
    }

    public void startFadeoutTimer(int fadeoutDelay) {
        if (fadeoutDelay > 0) {
            this.myFadeoutAlarm.cancelAllRequests();
            this.myFadeoutRequestMillis = System.currentTimeMillis();
            this.myFadeoutRequestDelay = fadeoutDelay;
            this.myFadeoutAlarm.addRequest(() -> {
                if (this.mySmartFadeout) {
                    this.setAnimationEnabled(true);
                }
                this.hide();
            }, fadeoutDelay, null);
        }
    }

    int getArc() {
        return this.myDialogMode ? 6 : 3;
    }

    int getPointerWidth(AbstractPosition position) {
        if (this.myPointerSize == null || this.myPointerSize.width <= 0) {
            if (this.myDialogMode) {
                return position.isTopBottomPointer() ? 24 : 17;
            }
            return position.isTopBottomPointer() ? 14 : 11;
        }
        return this.myPointerSize.width;
    }

    public static int getNormalInset() {
        return 3;
    }

    int getPointerLength(AbstractPosition position) {
        return this.myPointerSize == null || this.myPointerSize.height <= 0 ? BalloonImpl.getPointerLength(position, this.myDialogMode) : this.myPointerSize.height;
    }

    static int getPointerLength(AbstractPosition position, boolean dialogMode) {
        if (dialogMode) {
            return position.isTopBottomPointer() ? 16 : 14;
        }
        return position.isTopBottomPointer() ? 10 : 8;
    }

    public static int getPointerLength(Balloon.Position position, boolean dialogMode) {
        return BalloonImpl.getPointerLength(BalloonImpl.getAbstractPositionFor(position), dialogMode);
    }

    public void hide() {
        this.hide(false);
    }

    public void hide(boolean ok) {
        this.hideAndDispose(ok);
    }

    public void dispose() {
        this.hideAndDispose(false);
    }

    public void traceDispose(boolean value2) {
        assert (!this.isDisposed()) : "Balloon is already disposed";
        this.myTraceDispose = value2;
    }

    private void hideAndDispose(boolean ok) {
        if (this.myDisposed) {
            return;
        }
        if (this.mySmartFadeoutPaused) {
            this.mySmartFadeoutPaused = false;
            return;
        }
        if (this.myTraceDispose) {
            Logger.getInstance((String)"#com.intellij.ui.BalloonImpl").error("Dispose balloon before showing", new Throwable());
        }
        this.myDisposed = true;
        this.hideComboBoxPopups();
        Runnable disposeRunnable = () -> {
            this.myFadedOut = true;
            if (this.myRequestFocus && this.myOriginalFocusOwner != null) {
                this.myFocusManager.requestFocus(this.myOriginalFocusOwner, false);
            }
            for (JBPopupListener each : this.myListeners) {
                each.onClosed(new LightweightWindowEvent((LightweightWindow)this, ok));
            }
            Disposer.dispose((Disposable)this);
            this.onDisposed();
        };
        Toolkit.getDefaultToolkit().removeAWTEventListener(this.myAwtActivityListener);
        if (this.myLayeredPane != null) {
            this.myLayeredPane.removeComponentListener(this.myComponentListener);
            this.runAnimation(false, this.myLayeredPane, disposeRunnable);
        } else {
            disposeRunnable.run();
        }
        this.myVisible = false;
        this.myTracker = null;
    }

    private void hideComboBoxPopups() {
        List comboBoxes = UIUtil.findComponentsOfType((JComponent)this.myComp, JComboBox.class);
        for (JComboBox box : comboBoxes) {
            box.hidePopup();
        }
    }

    protected void onDisposed() {
    }

    public void addListener(@NotNull JBPopupListener listener2) {
        if (listener2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/ui/BalloonImpl", "addListener"));
        }
        this.myListeners.add(listener2);
    }

    public boolean isVisible() {
        return this.myVisible;
    }

    public void setHideOnClickOutside(boolean hideOnMouse) {
        this.myHideOnMouse = hideOnMouse;
    }

    public void setHideListener(@NotNull Runnable listener2) {
        if (listener2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/ui/BalloonImpl", "setHideListener"));
        }
        this.myHideListener = listener2;
        this.myHideOnMouse = true;
    }

    public void setShowPointer(boolean show2) {
        this.myShowPointer = show2;
    }

    public Icon getCloseButton() {
        return AllIcons.General.BalloonClose;
    }

    public void setBounds(Rectangle bounds) {
        this.myForcedBounds = bounds;
        if (this.myPosition != null) {
            this.myPosition.updateBounds(this);
        }
    }

    public void setShadowSize(int shadowSize) {
        this.myShadowSize = shadowSize;
    }

    public Dimension getPreferredSize() {
        if (this.myComp != null) {
            return this.myComp.getPreferredSize();
        }
        if (this.myDefaultPrefSize == null) {
            EmptyBorder border = this.myShadowBorderProvider == null ? this.getPointlessBorder() : null;
            MyComponent c2 = new MyComponent(this.myContent, this, border);
            if (this.myShadowBorderProvider != null) {
                c2.setBorder(new EmptyBorder(this.getShadowBorderInsets()));
            }
            this.myDefaultPrefSize = c2.getPreferredSize();
        }
        return this.myDefaultPrefSize;
    }

    public boolean wasFadedIn() {
        return this.myFadedIn;
    }

    public boolean wasFadedOut() {
        return this.myFadedOut;
    }

    public boolean isDisposed() {
        return this.myDisposed;
    }

    public void setTitle(String title) {
        this.myTitleLabel.setText(title);
    }

    public void setActionProvider(@NotNull ActionProvider actionProvider) {
        if (actionProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "actionProvider", "com/intellij/ui/BalloonImpl", "setActionProvider"));
        }
        this.myActionProvider = actionProvider;
    }

    @Override
    public RelativePoint getShowingPoint() {
        Point p2 = this.myPosition.getShiftedPoint(this.myTargetPoint, this.myCalloutShift * -1);
        return new RelativePoint((Component)this.myLayeredPane, p2);
    }

    public void setAnimationEnabled(boolean enabled) {
        this.myAnimationEnabled = enabled;
    }

    public boolean isAnimationEnabled() {
        return this.myAnimationEnabled && this.myAnimationCycle > 0 && !RemoteDesktopService.isRemoteSession();
    }

    public boolean isBlockClicks() {
        return this.myBlockClicks;
    }

    public boolean isClickProcessor() {
        return this.myClickHandler != null || !this.myCloseOnClick || this.isBlockClicks();
    }

    private static class Shaper {
        private final GeneralPath myPath = new GeneralPath();
        Rectangle myBounds;
        @JdkConstants.TabPlacement
        private final int myTargetSide;
        private final BalloonImpl myBalloon;

        public Shaper(BalloonImpl balloon, Rectangle bounds, Point targetPoint, @JdkConstants.TabPlacement int targetSide) {
            this.myBalloon = balloon;
            this.myBounds = bounds;
            this.myTargetSide = targetSide;
            this.start(targetPoint);
        }

        private void start(Point start2) {
            this.myPath.moveTo(start2.x, start2.y);
        }

        public Shaper roundUpRight() {
            this.myPath.quadTo(this.getCurrent().x, this.getCurrent().y - this.myBalloon.getArc(), this.getCurrent().x + this.myBalloon.getArc(), this.getCurrent().y - this.myBalloon.getArc());
            return this;
        }

        public Shaper roundRightDown() {
            this.myPath.quadTo(this.getCurrent().x + this.myBalloon.getArc(), this.getCurrent().y, this.getCurrent().x + this.myBalloon.getArc(), this.getCurrent().y + this.myBalloon.getArc());
            return this;
        }

        public Shaper roundLeftUp() {
            this.myPath.quadTo(this.getCurrent().x - this.myBalloon.getArc(), this.getCurrent().y, this.getCurrent().x - this.myBalloon.getArc(), this.getCurrent().y - this.myBalloon.getArc());
            return this;
        }

        public Shaper roundLeftDown() {
            this.myPath.quadTo(this.getCurrent().x, this.getCurrent().y + this.myBalloon.getArc(), this.getCurrent().x - this.myBalloon.getArc(), this.getCurrent().y + this.myBalloon.getArc());
            return this;
        }

        public Point getCurrent() {
            return new Point((int)this.myPath.getCurrentPoint().getX(), (int)this.myPath.getCurrentPoint().getY());
        }

        public Shaper line(int deltaX, int deltaY) {
            this.myPath.lineTo(this.getCurrent().x + deltaX, this.getCurrent().y + deltaY);
            return this;
        }

        public Shaper lineTo(int x2, int y2) {
            this.myPath.lineTo(x2, y2);
            return this;
        }

        private int getTargetDelta(@JdkConstants.TabPlacement int effectiveSide) {
            return effectiveSide == this.myTargetSide ? this.myBalloon.getPointerLength(this.myBalloon.myPosition) : 0;
        }

        public Shaper toRightCurve() {
            this.myPath.lineTo((int)this.myBounds.getMaxX() - this.myBalloon.getArc() - this.getTargetDelta(4) - 1, this.getCurrent().y);
            return this;
        }

        public Shaper toBottomCurve() {
            this.myPath.lineTo(this.getCurrent().x, (int)this.myBounds.getMaxY() - this.myBalloon.getArc() - this.getTargetDelta(3) - 1);
            return this;
        }

        public Shaper toLeftCurve() {
            this.myPath.lineTo((int)this.myBounds.getX() + this.myBalloon.getArc() + this.getTargetDelta(2), this.getCurrent().y);
            return this;
        }

        public Shaper toTopCurve() {
            this.myPath.lineTo(this.getCurrent().x, (int)this.myBounds.getY() + this.myBalloon.getArc() + this.getTargetDelta(1));
            return this;
        }

        public void close() {
            this.myPath.closePath();
        }

        public Shape getShape() {
            return this.myPath;
        }
    }

    private class MyComponent
    extends JPanel
    implements ComponentWithMnemonics {
        private BufferedImage myImage;
        private float myAlpha;
        private final BalloonImpl myBalloon;
        private final JComponent myContent;
        private ShadowBorderPainter.Shadow myShadow;

        private MyComponent(JComponent content2, BalloonImpl balloon, EmptyBorder shapeBorder) {
            this.setOpaque(false);
            this.setLayout(null);
            this.myBalloon = balloon;
            if (!ScreenReader.isActive()) {
                this.setFocusCycleRoot(true);
            }
            this.putClientProperty("Balloon.property", BalloonImpl.this);
            this.myContent = new JPanel(new BorderLayout(2, 2));
            Wrapper contentWrapper = new Wrapper(content2);
            if (BalloonImpl.this.myTitle != null) {
                BalloonImpl.this.myTitleLabel = new JLabel(BalloonImpl.this.myTitle, 0);
                BalloonImpl.this.myTitleLabel.setForeground(UIManager.getColor("List.background"));
                BalloonImpl.this.myTitleLabel.setBorder(new EmptyBorder(0, 4, 0, 4));
                this.myContent.add((Component)BalloonImpl.this.myTitleLabel, "North");
                contentWrapper.setBorder((Border)new EmptyBorder(1, 1, 1, 1));
            }
            this.myContent.add((Component)contentWrapper, "Center");
            this.myContent.setBorder(shapeBorder);
            this.myContent.setOpaque(false);
            this.add(this.myContent);
        }

        public Rectangle getContentBounds() {
            Rectangle bounds = super.getBounds();
            JBInsets.removeFrom((Rectangle)bounds, (Insets)this.getInsets());
            return bounds;
        }

        public void clear() {
            this.myImage = null;
            this.myAlpha = -1.0f;
        }

        @Override
        public void doLayout() {
            Rectangle bounds = new Rectangle(this.getWidth(), this.getHeight());
            JBInsets.removeFrom((Rectangle)bounds, (Insets)this.getInsets());
            this.myContent.setBounds(bounds);
        }

        @Override
        public Dimension getPreferredSize() {
            return this.addInsets(this.myContent.getPreferredSize());
        }

        @Override
        public Dimension getMinimumSize() {
            return this.addInsets(this.myContent.getMinimumSize());
        }

        private Dimension addInsets(Dimension size) {
            JBInsets.addTo((Dimension)size, (Insets)this.getInsets());
            return size;
        }

        @Override
        protected void paintChildren(Graphics g2) {
            if (this.myImage == null || this.myAlpha == -1.0f) {
                super.paintChildren(g2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void paintChildrenImpl(Graphics g2) {
            BufferedImage image = UIUtil.createImage((Graphics)g2, (int)this.getWidth(), (int)this.getHeight(), (int)1);
            Graphics2D imageGraphics = image.createGraphics();
            imageGraphics.setColor(new Color(BalloonImpl.this.myFillColor.getRGB()));
            imageGraphics.fillRect(0, 0, this.getWidth(), this.getHeight());
            super.paintChildren(imageGraphics);
            imageGraphics.dispose();
            Graphics2D g2d = (Graphics2D)g2.create();
            try {
                if (UIUtil.isJreHiDPI((Graphics2D)g2d)) {
                    float s2 = 1.0f / JBUI.sysScale((Graphics2D)g2d);
                    g2d.scale(s2, s2);
                }
                UIUtil.drawImage((Graphics)g2d, (Image)this.makeColorTransparent(image, BalloonImpl.this.myFillColor), (int)0, (int)0, null);
            }
            finally {
                g2d.dispose();
            }
        }

        private Image makeColorTransparent(Image image, Color color) {
            final int markerRGB = color.getRGB() | 0xFF000000;
            RGBImageFilter filter2 = new RGBImageFilter(){

                @Override
                public int filterRGB(int x2, int y2, int rgb) {
                    if ((rgb | 0xFF000000) == markerRGB) {
                        return 0xFFFFFF & rgb;
                    }
                    return rgb;
                }
            };
            return ImageUtil.filter((Image)image, (ImageFilter)filter2);
        }

        @Override
        protected void paintComponent(Graphics g2) {
            super.paintComponent(g2);
            Graphics2D g2d = (Graphics2D)g2;
            Point pointTarget = SwingUtilities.convertPoint(BalloonImpl.this.myLayeredPane, this.myBalloon.myTargetPoint, this);
            Rectangle shapeBounds = this.myContent.getBounds();
            int shadowSize = this.myBalloon.getShadowBorderSize();
            if (shadowSize > 0 && this.myShadow == null && BalloonImpl.this.myShadowBorderProvider == null) {
                this.initComponentImage(pointTarget, shapeBounds);
                this.myShadow = ShadowBorderPainter.createShadow(this.myImage, 0, 0, false, shadowSize / 2);
            }
            if (this.myImage == null && this.myAlpha != -1.0f) {
                this.initComponentImage(pointTarget, shapeBounds);
            }
            if (this.myImage != null && this.myAlpha != -1.0f) {
                g2d.setComposite(AlphaComposite.getInstance(3, this.myAlpha));
            }
            if (BalloonImpl.this.myShadowBorderProvider != null) {
                BalloonImpl.this.myShadowBorderProvider.paintShadow(this, g2);
            }
            if (this.myImage != null && this.myAlpha != -1.0f) {
                this.paintShadow(g2);
                UIUtil.drawImage((Graphics)g2d, (Image)this.myImage, (int)0, (int)0, null);
            } else {
                this.paintShadow(g2);
                this.myBalloon.myPosition.paintComponent(this.myBalloon, shapeBounds, (Graphics2D)g2, pointTarget);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void paintShadow(Graphics graphics) {
            if (this.myShadow != null) {
                Graphics2D g2d = (Graphics2D)graphics;
                try {
                    if (UIUtil.isJreHiDPI((Graphics2D)g2d)) {
                        g2d = (Graphics2D)graphics.create();
                        float s2 = 1.0f / JBUI.sysScale((Component)this);
                        g2d.scale(s2, s2);
                    }
                    UIUtil.drawImage((Graphics)g2d, (Image)this.myShadow.getImage(), (int)this.myShadow.getX(), (int)this.myShadow.getY(), null);
                }
                finally {
                    if (g2d != graphics) {
                        g2d.dispose();
                    }
                }
            }
        }

        @Override
        public boolean contains(int x2, int y2) {
            Point pointTarget = SwingUtilities.convertPoint(BalloonImpl.this.myLayeredPane, this.myBalloon.myTargetPoint, this);
            Rectangle bounds = this.myContent.getBounds();
            Shape shape = BalloonImpl.this.myShowPointer ? this.myBalloon.myPosition.getPointingShape(bounds, pointTarget, this.myBalloon) : new RoundRectangle2D.Double(bounds.x, bounds.y, bounds.width - 1, bounds.height - 1, this.myBalloon.getArc(), this.myBalloon.getArc());
            return shape.contains(x2, y2);
        }

        private void initComponentImage(Point pointTarget, Rectangle shapeBounds) {
            if (this.myImage != null) {
                return;
            }
            this.myImage = UIUtil.createImage((Component)BalloonImpl.this.myComp, (int)this.getWidth(), (int)this.getHeight(), (int)2);
            Graphics2D imageGraphics = (Graphics2D)this.myImage.getGraphics();
            this.myBalloon.myPosition.paintComponent(this.myBalloon, shapeBounds, imageGraphics, pointTarget);
            this.paintChildrenImpl(imageGraphics);
            imageGraphics.dispose();
        }

        @Override
        public void removeNotify() {
            super.removeNotify();
            if (!ScreenUtil.isStandardAddRemoveNotify((Component)this)) {
                return;
            }
            List buttons = BalloonImpl.this.myActionButtons;
            BalloonImpl.this.myActionButtons = null;
            if (buttons != null) {
                SwingUtilities.invokeLater(() -> {
                    for (ActionButton button : buttons) {
                        BalloonImpl.this.disposeButton(button);
                    }
                });
            }
        }

        public void setAlpha(float alpha) {
            this.myAlpha = alpha;
            this.paintImmediately(0, 0, this.getWidth(), this.getHeight());
        }

        public void _setBounds(Rectangle bounds) {
            Rectangle currentBounds = this.getBounds();
            if (currentBounds.width != bounds.width || currentBounds.height != bounds.height) {
                this.invalidateShadowImage();
            }
            super.setBounds(bounds);
            if (this.getParent() != null) {
                if (BalloonImpl.this.myActionButtons == null) {
                    BalloonImpl.this.myActionButtons = BalloonImpl.this.myActionProvider.createActions();
                }
                for (ActionButton button : BalloonImpl.this.myActionButtons) {
                    if (button.getParent() != null) continue;
                    BalloonImpl.this.myLayeredPane.add((Component)((Object)button));
                    BalloonImpl.this.myLayeredPane.setLayer((Component)((Object)button), JLayeredPane.DRAG_LAYER);
                }
            }
            if (this.isVisible()) {
                Rectangle lpBounds = SwingUtilities.convertRectangle(this.getParent(), bounds, BalloonImpl.this.myLayeredPane);
                lpBounds = BalloonImpl.this.myPosition.getPointlessContentRec(lpBounds, this.myBalloon.myShadowBorderProvider == null ? this.myBalloon.getPointerLength(BalloonImpl.this.myPosition) : 0);
                BalloonImpl.this.myActionProvider.layout(lpBounds);
            }
            if (this.isVisible()) {
                this.revalidate();
                this.repaint();
            }
        }

        private void invalidateShadowImage() {
            this.myImage = null;
            this.myShadow = null;
        }

        public void repaintButton() {
            if (BalloonImpl.this.myActionButtons != null) {
                for (ActionButton button : BalloonImpl.this.myActionButtons) {
                    button.repaint();
                }
            }
        }
    }

    private class CloseButton
    extends ActionButton {
        private CloseButton(Consumer<MouseEvent> listener2) {
            if (listener2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/ui/BalloonImpl$CloseButton", "<init>"));
            }
            super(BalloonImpl.this.getCloseButton(), null, null, listener2);
            this.setVisible(BalloonImpl.this.myEnableButtons);
        }

        @Override
        protected void paintIcon(@NotNull Graphics g2, @NotNull Icon icon) {
            if (g2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "g", "com/intellij/ui/BalloonImpl$CloseButton", "paintIcon"));
            }
            if (icon == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "icon", "com/intellij/ui/BalloonImpl$CloseButton", "paintIcon"));
            }
            if (BalloonImpl.this.myEnableButtons) {
                boolean pressed = this.myButton.isPressedByMouse();
                icon.paintIcon((Component)((Object)this), g2, pressed ? 1 : 0, pressed ? 1 : 0);
            }
        }
    }

    public class ActionButton
    extends NonOpaquePanel {
        private final Icon myIcon;
        private final Icon myHoverIcon;
        private final Consumer<MouseEvent> myListener;
        protected final BaseButtonBehavior myButton;

        public ActionButton(@Nullable Icon icon, @Nullable Icon hoverIcon, @NotNull String hint, Consumer<MouseEvent> listener2) {
            if (icon == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "icon", "com/intellij/ui/BalloonImpl$ActionButton", "<init>"));
            }
            if (listener2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/ui/BalloonImpl$ActionButton", "<init>"));
            }
            this.myIcon = icon;
            this.myHoverIcon = hoverIcon;
            this.myListener = listener2;
            this.setToolTipText(hint);
            this.myButton = new BaseButtonBehavior((JComponent)((Object)this), TimedDeadzone.NULL){

                protected void execute(MouseEvent e2) {
                    ActionButton.this.myListener.consume((Object)e2);
                }
            };
        }

        public Dimension getPreferredSize() {
            return new Dimension(this.myIcon.getIconWidth(), this.myIcon.getIconHeight());
        }

        protected void paintComponent(Graphics g2) {
            super.paintComponent(g2);
            if (this.hasPaint()) {
                this.paintIcon(g2, this.myHoverIcon != null && this.myButton.isHovered() ? this.myHoverIcon : this.myIcon);
            }
        }

        public boolean hasPaint() {
            return this.getWidth() > 0 && BalloonImpl.this.myLastMoveWasInsideBalloon;
        }

        protected void paintIcon(@NotNull Graphics g2, @NotNull Icon icon) {
            if (g2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "g", "com/intellij/ui/BalloonImpl$ActionButton", "paintIcon"));
            }
            if (icon == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "icon", "com/intellij/ui/BalloonImpl$ActionButton", "paintIcon"));
            }
            icon.paintIcon((Component)((Object)this), g2, 0, 0);
        }
    }

    public static interface ActionProvider {
        @NotNull
        public List<ActionButton> createActions();

        public void layout(@NotNull Rectangle var1);
    }

    private static class AtLeft
    extends AbstractPosition {
        private AtLeft() {
        }

        @Override
        public Point getShiftedPoint(Point targetPoint, int shift) {
            return new Point(targetPoint.x - shift, targetPoint.y);
        }

        @Override
        public Point getShiftedPoint(Point targetPoint, Insets shift) {
            return this.getShiftedPoint(targetPoint, -shift.left);
        }

        @Override
        int getChangeShift(AbstractPosition original, int xShift, int yShift) {
            return original == AT_RIGHT ? -xShift : 0;
        }

        @Override
        protected int getDistanceToTarget(Rectangle rectangle, Point targetPoint) {
            return targetPoint.x - (int)rectangle.getMaxX();
        }

        @Override
        protected Rectangle getPointlessContentRec(Rectangle bounds, int pointerLength) {
            return new Rectangle(bounds.x, bounds.y, bounds.width - pointerLength, bounds.height);
        }

        @Override
        EmptyBorder createBorder(BalloonImpl balloon) {
            Insets insets = balloon.getInsetsCopy();
            insets.right += balloon.getPointerLength(this);
            return new EmptyBorder(insets);
        }

        @Override
        void setRecToRelativePosition(Rectangle rec, Point targetPoint) {
            rec.setLocation(targetPoint.x - rec.width, targetPoint.y - rec.height / 2);
        }

        @Override
        Point getLocation(Dimension containerSize, Point targetPoint, Dimension balloonSize, int distance) {
            if (distance > 0) {
                return new Point(targetPoint.x - balloonSize.width, targetPoint.y - distance);
            }
            Point center = UIUtil.getCenterPoint((Rectangle)new Rectangle(targetPoint, (Dimension)JBUI.emptySize()), (Dimension)balloonSize);
            return new Point(targetPoint.x - balloonSize.width, center.y);
        }

        @Override
        protected Insets getTitleInsets(int normalInset, int pointerLength) {
            return new Insets(normalInset, pointerLength, normalInset, normalInset);
        }

        @Override
        protected Shape getPointingShape(Rectangle bounds, Point pointTarget, BalloonImpl balloon) {
            Shaper shaper = new Shaper(balloon, bounds, pointTarget, 4);
            shaper.lineTo((int)bounds.getMaxX() - shaper.getTargetDelta(4) - 1, pointTarget.y + balloon.getPointerWidth(this) / 2);
            shaper.toBottomCurve().roundLeftDown().toLeftCurve().roundLeftUp().toTopCurve().roundUpRight().toRightCurve().roundRightDown().lineTo(shaper.getCurrent().x, pointTarget.y - balloon.getPointerWidth(this) / 2).lineTo(pointTarget.x, pointTarget.y).close();
            return shaper.getShape();
        }
    }

    private static class AtRight
    extends AbstractPosition {
        private AtRight() {
        }

        @Override
        public Point getShiftedPoint(Point targetPoint, int shift) {
            return new Point(targetPoint.x + shift, targetPoint.y);
        }

        @Override
        public Point getShiftedPoint(Point targetPoint, Insets shift) {
            return this.getShiftedPoint(targetPoint, -shift.left);
        }

        @Override
        int getChangeShift(AbstractPosition original, int xShift, int yShift) {
            return original == AT_LEFT ? xShift : 0;
        }

        @Override
        protected int getDistanceToTarget(Rectangle rectangle, Point targetPoint) {
            return rectangle.x - targetPoint.x;
        }

        @Override
        protected Rectangle getPointlessContentRec(Rectangle bounds, int pointerLength) {
            return new Rectangle(bounds.x + pointerLength, bounds.y, bounds.width - pointerLength, bounds.height);
        }

        @Override
        EmptyBorder createBorder(BalloonImpl balloon) {
            Insets insets = balloon.getInsetsCopy();
            insets.left += balloon.getPointerLength(this);
            return new EmptyBorder(insets);
        }

        @Override
        void setRecToRelativePosition(Rectangle rec, Point targetPoint) {
            rec.setLocation(targetPoint.x, targetPoint.y - rec.height / 2);
        }

        @Override
        Point getLocation(Dimension containerSize, Point targetPoint, Dimension balloonSize, int distance) {
            if (distance > 0) {
                return new Point(targetPoint.x, targetPoint.y - distance);
            }
            Point center = UIUtil.getCenterPoint((Rectangle)new Rectangle(targetPoint, (Dimension)JBUI.emptySize()), (Dimension)balloonSize);
            return new Point(targetPoint.x, center.y);
        }

        @Override
        protected Insets getTitleInsets(int normalInset, int pointerLength) {
            return new Insets(normalInset, pointerLength, normalInset, normalInset);
        }

        @Override
        protected Shape getPointingShape(Rectangle bounds, Point pointTarget, BalloonImpl balloon) {
            Shaper shaper = new Shaper(balloon, bounds, pointTarget, 2);
            shaper.line(balloon.getPointerLength(this), -balloon.getPointerWidth(this) / 2).toTopCurve().roundUpRight().toRightCurve().roundRightDown().toBottomCurve().roundLeftDown().toLeftCurve().roundLeftUp().lineTo(shaper.getCurrent().x, pointTarget.y + balloon.getPointerWidth(this) / 2).lineTo(pointTarget.x, pointTarget.y).close();
            return shaper.getShape();
        }
    }

    private static class Above
    extends AbstractPosition {
        private Above() {
        }

        @Override
        public Point getShiftedPoint(Point targetPoint, int shift) {
            return new Point(targetPoint.x, targetPoint.y - shift);
        }

        @Override
        public Point getShiftedPoint(Point targetPoint, Insets shift) {
            return this.getShiftedPoint(targetPoint, -shift.top);
        }

        @Override
        int getChangeShift(AbstractPosition original, int xShift, int yShift) {
            return original == BELOW ? -yShift : 0;
        }

        @Override
        protected int getDistanceToTarget(Rectangle rectangle, Point targetPoint) {
            return targetPoint.y - (int)rectangle.getMaxY();
        }

        @Override
        protected Rectangle getPointlessContentRec(Rectangle bounds, int pointerLength) {
            return new Rectangle(bounds.x, bounds.y, bounds.width, bounds.height - pointerLength);
        }

        @Override
        EmptyBorder createBorder(BalloonImpl balloon) {
            Insets insets = balloon.getInsetsCopy();
            insets.bottom = balloon.getPointerLength(this);
            return new EmptyBorder(insets);
        }

        @Override
        void setRecToRelativePosition(Rectangle rec, Point targetPoint) {
            rec.setLocation(targetPoint.x - rec.width / 2, targetPoint.y - rec.height);
        }

        @Override
        Point getLocation(Dimension containerSize, Point targetPoint, Dimension balloonSize, int distance) {
            if (distance > 0) {
                return new Point(targetPoint.x - distance, targetPoint.y - balloonSize.height);
            }
            Point center = UIUtil.getCenterPoint((Rectangle)new Rectangle(targetPoint, (Dimension)JBUI.emptySize()), (Dimension)balloonSize);
            return new Point(center.x, targetPoint.y - balloonSize.height);
        }

        @Override
        protected Insets getTitleInsets(int normalInset, int pointerLength) {
            return new Insets(normalInset, normalInset, normalInset, normalInset);
        }

        @Override
        protected Shape getPointingShape(Rectangle bounds, Point pointTarget, BalloonImpl balloon) {
            Shaper shaper = new Shaper(balloon, bounds, pointTarget, 3);
            shaper.line(-balloon.getPointerWidth(this) / 2, -balloon.getPointerLength(this) + 1);
            shaper.toLeftCurve().roundLeftUp().toTopCurve().roundUpRight().toRightCurve().roundRightDown().toBottomCurve().line(0, 2).roundLeftDown().lineTo(pointTarget.x + balloon.getPointerWidth(this) / 2, shaper.getCurrent().y).lineTo(pointTarget.x, pointTarget.y).close();
            return shaper.getShape();
        }
    }

    private static class Below
    extends AbstractPosition {
        private Below() {
        }

        @Override
        public Point getShiftedPoint(Point targetPoint, int shift) {
            return new Point(targetPoint.x, targetPoint.y + shift);
        }

        @Override
        public Point getShiftedPoint(Point targetPoint, Insets shift) {
            return this.getShiftedPoint(targetPoint, -shift.top);
        }

        @Override
        int getChangeShift(AbstractPosition original, int xShift, int yShift) {
            return original == ABOVE ? yShift : 0;
        }

        @Override
        protected int getDistanceToTarget(Rectangle rectangle, Point targetPoint) {
            return rectangle.y - targetPoint.y;
        }

        @Override
        protected Rectangle getPointlessContentRec(Rectangle bounds, int pointerLength) {
            return new Rectangle(bounds.x, bounds.y + pointerLength, bounds.width, bounds.height - pointerLength);
        }

        @Override
        EmptyBorder createBorder(BalloonImpl balloon) {
            Insets insets = balloon.getInsetsCopy();
            insets.top += balloon.getPointerLength(this);
            return new EmptyBorder(insets);
        }

        @Override
        void setRecToRelativePosition(Rectangle rec, Point targetPoint) {
            rec.setLocation(new Point(targetPoint.x - rec.width / 2, targetPoint.y));
        }

        @Override
        Point getLocation(Dimension containerSize, Point targetPoint, Dimension balloonSize, int distance) {
            if (distance > 0) {
                return new Point(targetPoint.x - distance, targetPoint.y);
            }
            Point center = UIUtil.getCenterPoint((Rectangle)new Rectangle(targetPoint, (Dimension)JBUI.emptySize()), (Dimension)balloonSize);
            return new Point(center.x, targetPoint.y);
        }

        @Override
        protected Insets getTitleInsets(int normalInset, int pointerLength) {
            return new Insets(pointerLength, normalInset, normalInset, normalInset);
        }

        @Override
        protected Shape getPointingShape(Rectangle bounds, Point pointTarget, BalloonImpl balloon) {
            Shaper shaper = new Shaper(balloon, bounds, pointTarget, 1);
            shaper.line(balloon.getPointerWidth(this) / 2, balloon.getPointerLength(this)).toRightCurve().roundRightDown().toBottomCurve().roundLeftDown().toLeftCurve().roundLeftUp().toTopCurve().roundUpRight().lineTo(pointTarget.x - balloon.getPointerWidth(this) / 2, shaper.getCurrent().y).lineTo(pointTarget.x, pointTarget.y);
            shaper.close();
            return shaper.getShape();
        }
    }

    private static abstract class AbstractPosition {
        private AbstractPosition() {
        }

        abstract EmptyBorder createBorder(BalloonImpl var1);

        abstract void setRecToRelativePosition(Rectangle var1, Point var2);

        abstract int getChangeShift(AbstractPosition var1, int var2, int var3);

        public void updateBounds(BalloonImpl balloon) {
            if (balloon.myLayeredPane == null || balloon.myComp == null) {
                return;
            }
            Rectangle bounds = this.getUpdatedBounds(balloon, balloon.myComp.getPreferredSize());
            if (balloon.myShadowBorderProvider == null) {
                bounds = new Rectangle(this.getShiftedPoint(bounds.getLocation(), balloon.getShadowBorderInsets()), bounds.getSize());
            }
            balloon.myComp._setBounds(bounds);
        }

        public Rectangle getUpdatedBounds(BalloonImpl balloon, Dimension preferredSize) {
            Dimension layeredPaneSize = balloon.myLayeredPane.getSize();
            Point point = balloon.myTargetPoint;
            Rectangle bounds = balloon.myForcedBounds;
            if (bounds == null) {
                int distance = this.getDistance(balloon, preferredSize);
                Point location = balloon.myShowPointer ? this.getLocation(layeredPaneSize, point, preferredSize, distance) : new Point(point.x - preferredSize.width / 2, point.y - preferredSize.height / 2);
                bounds = new Rectangle(location.x, location.y, preferredSize.width, preferredSize.height);
                ScreenUtil.moveToFit((Rectangle)bounds, (Rectangle)new Rectangle(0, 0, layeredPaneSize.width, layeredPaneSize.height), (Insets)balloon.myContainerInsets);
            }
            return bounds;
        }

        private int getDistance(BalloonImpl balloon, Dimension size) {
            int limit;
            if (balloon.myCornerToPointerDistance < 0) {
                return -1;
            }
            int indent = balloon.getArc() + balloon.getPointerWidth(this) / 2;
            if (balloon.myCornerToPointerDistance < indent) {
                return indent;
            }
            int n2 = limit = this == ABOVE || this == BELOW ? size.width - indent : size.height - indent;
            if (balloon.myCornerToPointerDistance > limit) {
                return limit;
            }
            return balloon.myCornerToPointerDistance;
        }

        abstract Point getLocation(Dimension var1, Point var2, Dimension var3, int var4);

        void paintComponent(BalloonImpl balloon, Rectangle bounds, Graphics2D g2, Point pointTarget) {
            GraphicsConfig cfg = new GraphicsConfig((Graphics)g2);
            cfg.setAntialiasing(true);
            if (balloon.myShadowBorderProvider != null) {
                balloon.myShadowBorderProvider.paintBorder(bounds, g2);
                if (balloon.myShowPointer) {
                    Balloon.Position position = this == ABOVE ? Balloon.Position.above : (this == BELOW ? Balloon.Position.below : (this == AT_LEFT ? Balloon.Position.atLeft : Balloon.Position.atRight));
                    balloon.myShadowBorderProvider.paintPointingShape(bounds, pointTarget, position, g2);
                }
                cfg.restore();
                return;
            }
            Shape shape = balloon.myShowPointer ? this.getPointingShape(bounds, pointTarget, balloon) : new RoundRectangle2D.Double(bounds.x, bounds.y, bounds.width - 1, bounds.height - 1, balloon.getArc(), balloon.getArc());
            g2.setColor(balloon.myFillColor);
            g2.fill(shape);
            g2.setColor(balloon.myBorderColor);
            if (balloon.myTitleLabel != null) {
                Rectangle titleBounds = balloon.myTitleLabel.getBounds();
                Insets inset = this.getTitleInsets(BalloonImpl.getNormalInset() - 1, balloon.getPointerLength(this) + 50);
                Insets borderInsets = balloon.getShadowBorderInsets();
                inset.top += borderInsets.top;
                inset.bottom += borderInsets.bottom;
                inset.left += borderInsets.left;
                inset.right += borderInsets.right;
                titleBounds.x -= inset.left + 1;
                titleBounds.width += inset.left + inset.right + 50;
                titleBounds.y -= inset.top + 1;
                titleBounds.height += inset.top + inset.bottom + 1;
                Area area = new Area(shape);
                area.intersect(new Area(titleBounds));
                Color fgColor = UIManager.getColor("Label.foreground");
                fgColor = ColorUtil.toAlpha((Color)fgColor, (int)140);
                g2.setColor(fgColor);
                g2.fill(area);
                g2.setColor(balloon.myBorderColor);
                g2.draw(area);
            }
            g2.draw(shape);
            cfg.restore();
        }

        protected abstract Insets getTitleInsets(int var1, int var2);

        protected abstract Shape getPointingShape(Rectangle var1, Point var2, BalloonImpl var3);

        public boolean isOkToHavePointer(Point targetPoint, Rectangle bounds, int pointerLength, int pointerWidth, int arc) {
            UnfairTextRange pointerRange;
            UnfairTextRange balloonRange;
            if (bounds.x < targetPoint.x && bounds.x + bounds.width > targetPoint.x && bounds.y < targetPoint.y && bounds.y + bounds.height > targetPoint.y) {
                return false;
            }
            Rectangle pointless = this.getPointlessContentRec(bounds, pointerLength);
            int distance = this.getDistanceToTarget(pointless, targetPoint);
            if (distance < pointerLength - 1 || distance > 2 * pointerLength) {
                return false;
            }
            if (this.isTopBottomPointer()) {
                balloonRange = new UnfairTextRange(bounds.x + arc - 1, bounds.x + bounds.width - arc * 2 + 1);
                pointerRange = new UnfairTextRange(targetPoint.x - pointerWidth / 2, targetPoint.x + pointerWidth / 2);
            } else {
                balloonRange = new UnfairTextRange(bounds.y + arc - 1, bounds.y + bounds.height - arc * 2 + 1);
                pointerRange = new UnfairTextRange(targetPoint.y - pointerWidth / 2, targetPoint.y + pointerWidth / 2);
            }
            return balloonRange.contains((TextRange)pointerRange);
        }

        protected abstract int getDistanceToTarget(Rectangle var1, Point var2);

        protected boolean isTopBottomPointer() {
            return this instanceof Below || this instanceof Above;
        }

        protected abstract Rectangle getPointlessContentRec(Rectangle var1, int var2);

        public Set<AbstractPosition> getOtherPositions() {
            HashSet all2 = new HashSet();
            all2.add((Object)BELOW);
            all2.add((Object)ABOVE);
            all2.add((Object)AT_RIGHT);
            all2.add((Object)AT_LEFT);
            all2.remove((Object)this);
            return all2;
        }

        public abstract Point getShiftedPoint(Point var1, int var2);

        public abstract Point getShiftedPoint(Point var1, Insets var2);
    }

    public static interface ShadowBorderProvider {
        @NotNull
        public Insets getInsets();

        public void paintShadow(@NotNull JComponent var1, @NotNull Graphics var2);

        public void paintBorder(@NotNull Rectangle var1, @NotNull Graphics2D var2);

        public void paintPointingShape(@NotNull Rectangle var1, @NotNull Point var2, @NotNull Balloon.Position var3, @NotNull Graphics2D var4);
    }
}

