/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.FocusChangeListener;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.FixedComboBoxEditor;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.EditorTextField;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;

public class ComboboxEditorTextField
extends EditorTextField {
    public static final Border EDITOR_TEXTFIELD_BORDER = new FixedComboBoxEditor.MacComboBoxEditorBorder(false){

        public Insets getBorderInsets(Component c2) {
            return new Insets(5, 6, 5, 3);
        }
    };
    public static final Border EDITOR_TEXTFIELD_DISABLED_BORDER = new FixedComboBoxEditor.MacComboBoxEditorBorder(true){

        public Insets getBorderInsets(Component c2) {
            return new Insets(5, 6, 5, 3);
        }
    };

    public ComboboxEditorTextField(@NotNull String text2, Project project2, FileType fileType) {
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/ui/ComboboxEditorTextField", "<init>"));
        }
        super(text2, project2, fileType);
        this.setOneLineMode(true);
    }

    public ComboboxEditorTextField(Document document, Project project2, FileType fileType) {
        this(document, project2, fileType, false);
        this.setOneLineMode(true);
    }

    public ComboboxEditorTextField(Document document, Project project2, FileType fileType, boolean isViewer) {
        super(document, project2, fileType, isViewer);
        this.setOneLineMode(true);
        if (UIUtil.isUnderDarcula() || UIUtil.isUnderIntelliJLaF()) {
            this.setBackground(UIUtil.getTextFieldBackground());
        }
    }

    @Override
    protected boolean shouldHaveBorder() {
        return UIManager.getBorder("ComboBox.border") == null && !UIUtil.isUnderDarcula() && !UIUtil.isUnderIntelliJLaF();
    }

    public void setBounds(int x2, int y2, int width, int height) {
        UIUtil.setComboBoxEditorBounds((int)x2, (int)y2, (int)width, (int)height, (JComponent)((Object)this));
    }

    @Override
    protected void updateBorder(@NotNull EditorEx editor) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/ui/ComboboxEditorTextField", "updateBorder"));
        }
        if (UIUtil.isUnderAquaLookAndFeel()) {
            editor.setBorder(this.isEnabled() ? EDITOR_TEXTFIELD_BORDER : EDITOR_TEXTFIELD_DISABLED_BORDER);
        }
    }

    @Override
    protected EditorEx createEditor() {
        EditorEx result2 = super.createEditor();
        result2.addFocusListener(new FocusChangeListener(){

            @Override
            public void focusGained(Editor editor) {
                ComboboxEditorTextField.this.repaintComboBox();
            }

            @Override
            public void focusLost(Editor editor) {
                ComboboxEditorTextField.this.repaintComboBox();
            }
        });
        return result2;
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension preferredSize = super.getPreferredSize();
        return new Dimension(preferredSize.width, UIUtil.fixComboBoxHeight((int)preferredSize.height));
    }

    @Override
    public void setEnabled(boolean enabled) {
        Editor editor;
        if (UIUtil.isUnderAquaLookAndFeel() && (editor = this.getEditor()) != null) {
            editor.setBorder(enabled ? EDITOR_TEXTFIELD_BORDER : EDITOR_TEXTFIELD_DISABLED_BORDER);
        }
        super.setEnabled(enabled);
    }

    private void repaintComboBox() {
        if (UIUtil.isUnderDarcula() || UIUtil.isUnderIntelliJLaF() || SystemInfo.isMac && UIUtil.isUnderAquaLookAndFeel()) {
            IdeFocusManager.getInstance((Project)this.getProject()).doWhenFocusSettlesDown(() -> {
                JComboBox comboBox = (JComboBox)UIUtil.getParentOfType(JComboBox.class, (Component)((Object)this));
                if (comboBox != null) {
                    comboBox.repaint();
                }
            });
        }
    }
}

