/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.ui.Gray;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.util.Enumeration;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DuplicateNodeRenderer {
    public static void paintDuplicateNodesBackground(Graphics g2, JTree tree2) {
        Rectangle clipBounds = g2.getClipBounds();
        int start2 = tree2.getClosestRowForLocation(clipBounds.x, clipBounds.y);
        int end = Math.min(tree2.getRowCount(), tree2.getClosestRowForLocation(clipBounds.x + clipBounds.width, clipBounds.y + clipBounds.height) + 1);
        Color old = g2.getColor();
        for (int i2 = start2; i2 < end; ++i2) {
            DuplicatableNode duplicatableNode;
            Object duplicate;
            Object userObject;
            DefaultMutableTreeNode node;
            TreePath path = tree2.getPathForRow(i2);
            if (path == null) continue;
            Rectangle accumRect = null;
            TreePath accumPath = null;
            for (node = (DefaultMutableTreeNode)path.getLastPathComponent(); node != null && (userObject = node.getUserObject()) instanceof DuplicatableNode && (duplicate = (duplicatableNode = (DuplicatableNode)userObject).getDuplicate()) != null; node = (DefaultMutableTreeNode)node.getParent()) {
                accumPath = accumRect == null ? path : accumPath.getParentPath();
                accumRect = DuplicateNodeRenderer.union(tree2.getPathBounds(accumPath), accumRect);
            }
            if (accumRect == null) continue;
            Rectangle rowRect = tree2.getRowBounds(tree2.getRowForPath(accumPath));
            accumRect = accumRect.intersection(new Rectangle(rowRect.x, rowRect.y, Integer.MAX_VALUE, Integer.MAX_VALUE));
            node = (DefaultMutableTreeNode)accumPath.getLastPathComponent();
            accumRect = DuplicateNodeRenderer.union(accumRect, DuplicateNodeRenderer.getExpandedNodesRect(tree2, node, accumPath));
            g2.setColor((Color)Gray._230);
            g2.fillRoundRect(accumRect.x, accumRect.y, accumRect.width, accumRect.height, 10, 10);
            g2.setColor(Color.lightGray);
            g2.drawRoundRect(accumRect.x, accumRect.y, accumRect.width, accumRect.height, 10, 10);
        }
        g2.setColor(old);
    }

    @NotNull
    private static Rectangle union(Rectangle r1, Rectangle r2) {
        if (r1 == null) {
            Rectangle rectangle = r2;
            if (rectangle == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/DuplicateNodeRenderer", "union"));
            }
            return rectangle;
        }
        if (r2 == null) {
            Rectangle rectangle = r1;
            if (rectangle == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/DuplicateNodeRenderer", "union"));
            }
            return rectangle;
        }
        Rectangle rectangle = r1.union(r2);
        if (rectangle == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/DuplicateNodeRenderer", "union"));
        }
        return rectangle;
    }

    private static Rectangle getExpandedNodesRect(JTree tree2, DefaultMutableTreeNode node, TreePath path) {
        Rectangle rect = tree2.getRowBounds(tree2.getRowForPath(path));
        if (tree2.isExpanded(path)) {
            Enumeration<TreeNode> children2 = node.children();
            while (children2.hasMoreElements()) {
                DefaultMutableTreeNode child = (DefaultMutableTreeNode)children2.nextElement();
                TreePath childPath = path.pathByAddingChild(child);
                assert (!path.equals(childPath)) : path + ";" + child;
                rect = DuplicateNodeRenderer.union(rect, DuplicateNodeRenderer.getExpandedNodesRect(tree2, child, childPath));
            }
        }
        return rect;
    }

    public static interface DuplicatableNode<T> {
        @Nullable
        public T getDuplicate();
    }
}

