/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.TextComponentAccessor;
import com.intellij.ui.ComboboxEditorTextField;
import com.intellij.ui.EditorComboBoxRenderer;
import com.intellij.ui.EditorTextField;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.MacUIUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ComboBoxEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.KeyStroke;
import org.jetbrains.annotations.NotNull;

public class EditorComboBox
extends JComboBox
implements DocumentListener {
    public static TextComponentAccessor<EditorComboBox> COMPONENT_ACCESSOR = new TextComponentAccessor<EditorComboBox>(){

        public String getText(EditorComboBox component) {
            return component.getText();
        }

        public void setText(EditorComboBox component, @NotNull String text2) {
            if (text2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/ui/EditorComboBox$1", "setText"));
            }
            component.setText(text2);
        }
    };
    private Document myDocument;
    private final Project myProject;
    private EditorTextField myEditorField = null;
    private final List<DocumentListener> myDocumentListeners = ContainerUtil.createLockFreeCopyOnWriteList();
    private boolean myIsListenerInstalled = false;
    private boolean myInheritSwingFont = true;
    private final FileType myFileType;
    private final boolean myIsViewer;

    public EditorComboBox(String text2) {
        this(EditorFactory.getInstance().createDocument((CharSequence)text2), null, (FileType)FileTypes.PLAIN_TEXT);
    }

    public EditorComboBox(String text2, Project project2, FileType fileType) {
        this(EditorFactory.getInstance().createDocument((CharSequence)text2), project2, fileType, false);
    }

    public EditorComboBox(Document document, Project project2, FileType fileType) {
        this(document, project2, fileType, false);
    }

    public EditorComboBox(Document document, Project project2, FileType fileType, boolean isViewer) {
        this.myFileType = fileType;
        this.myIsViewer = isViewer;
        this.setDocument(document);
        this.myProject = project2;
        this.enableEvents(8L);
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                Editor editor;
                Editor editor2 = editor = EditorComboBox.this.myEditorField != null ? EditorComboBox.this.myEditorField.getEditor() : null;
                if (editor != null) {
                    editor.getSelectionModel().removeSelection();
                }
            }
        });
        this.setHistory(new String[]{""});
        this.setEditable(true);
    }

    public void setFontInheritedFromLAF(boolean b2) {
        this.myInheritSwingFont = b2;
        this.setDocument(this.myDocument);
    }

    public String getText() {
        return this.myDocument.getText();
    }

    public void addDocumentListener(DocumentListener listener2) {
        this.myDocumentListeners.add(listener2);
        this.installDocumentListener();
    }

    public void removeDocumentListener(DocumentListener listener2) {
        this.myDocumentListeners.remove(listener2);
        this.uninstallDocumentListener(false);
    }

    public void beforeDocumentChange(DocumentEvent event) {
        for (DocumentListener documentListener2 : this.myDocumentListeners) {
            documentListener2.beforeDocumentChange(event);
        }
    }

    public void documentChanged(DocumentEvent event) {
        for (DocumentListener documentListener2 : this.myDocumentListeners) {
            documentListener2.documentChanged(event);
        }
    }

    @Override
    public void paint(Graphics g2) {
        super.paint(g2);
        MacUIUtil.drawComboboxFocusRing((JComboBox)this, (Graphics)g2);
    }

    public Project getProject() {
        return this.myProject;
    }

    public Document getDocument() {
        return this.myDocument;
    }

    public void setDocument(Document document) {
        if (this.myDocument != null) {
            this.uninstallDocumentListener(true);
        }
        this.myDocument = document;
        this.installDocumentListener();
        if (this.myEditorField == null) {
            return;
        }
        this.myEditorField.setDocument(document);
    }

    private void installDocumentListener() {
        if (this.myDocument != null && !this.myDocumentListeners.isEmpty() && !this.myIsListenerInstalled) {
            this.myIsListenerInstalled = true;
            this.myDocument.addDocumentListener((DocumentListener)this);
        }
    }

    private void uninstallDocumentListener(boolean force) {
        if (this.myDocument != null && this.myIsListenerInstalled && (force || this.myDocumentListeners.isEmpty())) {
            this.myIsListenerInstalled = false;
            this.myDocument.removeDocumentListener((DocumentListener)this);
        }
    }

    public void setText(String text2) {
        ApplicationManager.getApplication().runWriteAction(() -> CommandProcessor.getInstance().executeCommand(this.getProject(), () -> {
            this.myDocument.replaceString(0, this.myDocument.getTextLength(), (CharSequence)text2);
            if (this.myEditorField != null && this.myEditorField.getEditor() != null) {
                this.myEditorField.getCaretModel().moveToOffset(this.myDocument.getTextLength());
            }
        }, null, (Object)this.myDocument));
    }

    public void removeSelection() {
        Editor editor;
        if (this.myEditorField != null && (editor = this.myEditorField.getEditor()) != null) {
            editor.getSelectionModel().removeSelection();
        }
    }

    public CaretModel getCaretModel() {
        return this.myEditorField.getCaretModel();
    }

    public void setHistory(String[] history) {
        this.setModel(new DefaultComboBoxModel<String>(history));
    }

    public void prependItem(String item) {
        ArrayList<String> objects = new ArrayList<String>();
        objects.add(item);
        int count = this.getItemCount();
        for (int i2 = 0; i2 < count; ++i2) {
            Object itemAt = this.getItemAt(i2);
            if (item.equals(itemAt)) continue;
            objects.add((String)itemAt);
        }
        this.setModel(new DefaultComboBoxModel<Object>(ArrayUtil.toObjectArray(objects)));
    }

    public void appendItem(String item) {
        ArrayList objects = new ArrayList();
        int count = this.getItemCount();
        for (int i2 = 0; i2 < count; ++i2) {
            objects.add(this.getItemAt(i2));
        }
        if (!objects.contains(item)) {
            objects.add(item);
        }
        this.setModel(new DefaultComboBoxModel<Object>(ArrayUtil.toObjectArray(objects)));
    }

    @Override
    public void addNotify() {
        this.releaseEditor();
        this.setEditor();
        super.addNotify();
        this.myEditorField.getFocusTarget().addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e2) {
                EditorComboBox.this.repaint();
            }

            @Override
            public void focusLost(FocusEvent e2) {
                EditorComboBox.this.repaint();
            }
        });
    }

    private void setEditor() {
        this.myEditorField = this.createEditorTextField(this.myDocument, this.myProject, this.myFileType, this.myIsViewer);
        MyEditor editor = new MyEditor();
        this.setEditor(editor);
        this.setRenderer(new EditorComboBoxRenderer((ComboBoxEditor)editor));
    }

    protected ComboboxEditorTextField createEditorTextField(Document document, Project project2, FileType fileType, boolean isViewer) {
        return new ComboboxEditorTextField(document, project2, fileType, isViewer);
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        this.releaseEditor();
        this.myEditorField = null;
    }

    private void releaseEditor() {
        if (this.myEditorField != null) {
            this.myEditorField.releaseEditorLater();
        }
    }

    @Override
    public void setFont(Font font) {
        super.setFont(font);
        if (this.myEditorField != null && this.myEditorField.getEditor() != null) {
            this.setupEditorFont((EditorEx)this.myEditorField.getEditor());
        }
    }

    private void setupEditorFont(EditorEx editor) {
        if (this.myInheritSwingFont) {
            editor.getColorsScheme().setEditorFontName(this.getFont().getFontName());
            editor.getColorsScheme().setEditorFontSize(this.getFont().getSize());
        }
    }

    protected boolean shouldHaveBorder() {
        return true;
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (this.myEditorField == null) {
            return;
        }
        this.myEditorField.setEnabled(enabled);
    }

    @Override
    public Dimension getPreferredSize() {
        if (UIUtil.isUnderIntelliJLaF() || UIUtil.isUnderDarcula()) {
            return super.getPreferredSize();
        }
        if (this.myEditorField != null) {
            Dimension preferredSize = new Dimension(this.myEditorField.getComponent().getPreferredSize());
            JBInsets.addTo((Dimension)preferredSize, (Insets)this.getInsets());
            return preferredSize;
        }
        return new Dimension(100, UIUtil.fixComboBoxHeight((int)20));
    }

    @Override
    protected boolean processKeyBinding(KeyStroke ks, KeyEvent e2, int condition, boolean pressed) {
        if (!((EditorEx)this.myEditorField.getEditor()).processKeyTyped(e2)) {
            return super.processKeyBinding(ks, e2, condition, pressed);
        }
        return true;
    }

    public EditorEx getEditorEx() {
        return this.myEditorField != null ? (EditorEx)this.myEditorField.getEditor() : null;
    }

    private class MyEditor
    implements ComboBoxEditor {
        private MyEditor() {
        }

        @Override
        public void addActionListener(ActionListener l2) {
        }

        @Override
        public Component getEditorComponent() {
            return EditorComboBox.this.myEditorField;
        }

        @Override
        public Object getItem() {
            return EditorComboBox.this.myDocument.getText();
        }

        @Override
        public void removeActionListener(ActionListener l2) {
        }

        @Override
        public void selectAll() {
            Editor editor;
            if (EditorComboBox.this.myEditorField != null && (editor = EditorComboBox.this.myEditorField.getEditor()) != null) {
                editor.getSelectionModel().setSelection(0, EditorComboBox.this.myDocument.getTextLength());
            }
        }

        @Override
        public void setItem(Object anObject) {
            if (anObject != null) {
                EditorComboBox.this.setText(anObject.toString());
            } else {
                EditorComboBox.this.setText("");
            }
        }
    }
}

