/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.util.text.StringTokenizer;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Toolkit;
import javax.swing.Icon;

public class HorizontalLabeledIcon
implements Icon {
    private final Icon myIcon;
    private final String[] myStrings;
    private final String myMnemonic;

    public HorizontalLabeledIcon(Icon icon, String text2, String mnemonic) {
        this.myIcon = icon;
        if (text2 != null) {
            StringTokenizer tokenizer = new StringTokenizer(text2, "\n");
            this.myStrings = new String[tokenizer.countTokens()];
            int i2 = 0;
            while (tokenizer.hasMoreTokens()) {
                this.myStrings[i2] = tokenizer.nextToken();
                ++i2;
            }
        } else {
            this.myStrings = null;
        }
        this.myMnemonic = mnemonic;
    }

    @Override
    public int getIconHeight() {
        return Math.max(this.myIcon.getIconHeight(), this.getTextHeight());
    }

    @Override
    public int getIconWidth() {
        return this.myIcon.getIconWidth() + this.getTextWidth() + 5;
    }

    private int getTextHeight() {
        if (this.myStrings != null) {
            Font font = UIUtil.getLabelFont();
            FontMetrics fontMetrics = Toolkit.getDefaultToolkit().getFontMetrics(font);
            return fontMetrics.getHeight() * this.myStrings.length;
        }
        return 0;
    }

    private int getTextWidth() {
        if (this.myStrings != null) {
            int width = 0;
            Font font = UIUtil.getLabelFont();
            FontMetrics fontMetrics = Toolkit.getDefaultToolkit().getFontMetrics(font);
            for (int i2 = 0; i2 < this.myStrings.length; ++i2) {
                String string2 = this.myStrings[i2];
                if (this.myMnemonic != null && i2 == this.myStrings.length - 1) {
                    string2 = string2 + " " + this.myMnemonic;
                }
                width = Math.max(width, fontMetrics.stringWidth(string2));
            }
            return width;
        }
        return 0;
    }

    @Override
    public void paintIcon(Component c2, Graphics g2, int x2, int y2) {
        int iconHeight;
        int height = this.getIconHeight();
        if (height > (iconHeight = this.myIcon.getIconHeight())) {
            this.myIcon.paintIcon(c2, g2, x2, y2 + (height - iconHeight) / 2);
        } else {
            this.myIcon.paintIcon(c2, g2, x2, y2);
        }
        if (this.myStrings != null) {
            Font font = UIUtil.getLabelFont();
            FontMetrics fontMetrics = Toolkit.getDefaultToolkit().getFontMetrics(font);
            g2.setFont(fontMetrics.getFont());
            g2.setColor(UIUtil.getLabelForeground());
            x2 += this.myIcon.getIconWidth() + 5;
            y2 += (height - this.getTextHeight()) / 2 + fontMetrics.getHeight() - fontMetrics.getDescent();
            for (int i2 = 0; i2 < this.myStrings.length; ++i2) {
                String string2 = this.myStrings[i2];
                g2.drawString(string2, x2, y2);
                y2 += fontMetrics.getHeight();
            }
            if (this.myMnemonic != null) {
                g2.setColor(UIUtil.getInactiveTextColor());
                int offset = fontMetrics.stringWidth(this.myStrings[this.myStrings.length - 1] + " ");
                g2.drawString(this.myMnemonic, x2 + offset, y2 -= fontMetrics.getHeight());
            }
        }
    }
}

