/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.util.text.StringTokenizer;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Toolkit;
import javax.swing.Icon;

public class LabeledIcon
implements Icon {
    private final Icon myIcon;
    private final String myMnemonic;
    private final String[] myStrings;
    private int myIconTextGap = 5;
    private Font myFont = UIUtil.getLabelFont();

    public LabeledIcon(Icon icon, String text2, String mnemonic) {
        this.myIcon = icon;
        this.myMnemonic = mnemonic;
        if (text2 != null) {
            StringTokenizer tokenizer = new StringTokenizer(text2, "\n");
            this.myStrings = new String[tokenizer.countTokens()];
            int i2 = 0;
            while (tokenizer.hasMoreTokens()) {
                this.myStrings[i2] = tokenizer.nextToken();
                ++i2;
            }
        } else {
            this.myStrings = null;
        }
    }

    public Font getFont() {
        return this.myFont;
    }

    public void setFont(Font font) {
        this.myFont = font;
    }

    public void setIconTextGap(int iconTextGap) {
        this.myIconTextGap = iconTextGap;
    }

    public int getIconTextGap() {
        return this.myIconTextGap;
    }

    @Override
    public int getIconHeight() {
        return this.myIcon.getIconHeight() + this.getTextHeight() + this.myIconTextGap;
    }

    @Override
    public int getIconWidth() {
        return Math.max(this.myIcon.getIconWidth(), this.getTextWidth());
    }

    private int getTextHeight() {
        if (this.myStrings != null) {
            return LabeledIcon.getFontHeight(this.myStrings, this.myFont);
        }
        return 0;
    }

    private static int getFontHeight(String[] strings, Font font) {
        FontMetrics fontMetrics = Toolkit.getDefaultToolkit().getFontMetrics(font);
        return fontMetrics.getHeight() * strings.length;
    }

    private int getTextWidth() {
        if (this.myStrings != null) {
            int width = 0;
            Font font = UIUtil.getLabelFont();
            FontMetrics fontMetrics = Toolkit.getDefaultToolkit().getFontMetrics(font);
            for (String string2 : this.myStrings) {
                width = fontMetrics.stringWidth(string2);
            }
            if (this.myMnemonic != null) {
                width += fontMetrics.stringWidth(this.myMnemonic);
            }
            return width;
        }
        return 0;
    }

    @Override
    public void paintIcon(Component c2, Graphics g2, int x2, int y2) {
        int iconWidth;
        int width = this.getIconWidth();
        if (width > (iconWidth = this.myIcon.getIconWidth())) {
            this.myIcon.paintIcon(c2, g2, x2 + (width - iconWidth) / 2, y2);
        } else {
            this.myIcon.paintIcon(c2, g2, x2, y2);
        }
        if (this.myStrings != null) {
            Font font = this.getFont();
            FontMetrics fontMetrics = Toolkit.getDefaultToolkit().getFontMetrics(font);
            g2.setFont(fontMetrics.getFont());
            if (this.myMnemonic != null) {
                width -= fontMetrics.stringWidth(this.myMnemonic);
            }
            g2.setColor(UIUtil.getLabelForeground());
            y2 += this.myIcon.getIconHeight() + fontMetrics.getMaxAscent() + this.myIconTextGap;
            for (String string2 : this.myStrings) {
                g2.drawString(string2, x2 + (width - fontMetrics.stringWidth(string2)) / 2, y2);
                y2 += fontMetrics.getHeight();
            }
            if (this.myMnemonic != null) {
                g2.setColor(UIUtil.getInactiveTextColor());
                int offset = this.getTextWidth() - fontMetrics.stringWidth(this.myMnemonic);
                g2.drawString(this.myMnemonic, x2 + offset, y2 -= fontMetrics.getHeight());
            }
        }
    }
}

