/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.codeInsight.hint.TooltipController;
import com.intellij.ide.IdeTooltip;
import com.intellij.ide.IdeTooltipManager;
import com.intellij.ide.TooltipEvent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.wm.ex.LayoutFocusTraversalPolicyExt;
import com.intellij.ui.BalloonImpl;
import com.intellij.ui.Hint;
import com.intellij.ui.HintHint;
import com.intellij.ui.HintListener;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.panels.OpaquePanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.EventListener;
import java.util.EventObject;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.JRootPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;
import javax.swing.event.EventListenerList;
import org.jetbrains.annotations.NotNull;

public class LightweightHint
extends UserDataHolderBase
implements Hint {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.ui.LightweightHint");
    private final JComponent myComponent;
    private JComponent myFocusBackComponent;
    private final EventListenerList myListenerList;
    private MyEscListener myEscListener;
    private JBPopup myPopup;
    private JComponent myParentComponent;
    private boolean myIsRealPopup;
    private boolean myForceLightweightPopup;
    private boolean mySelectingHint;
    private boolean myForceShowAsPopup;
    private String myTitle;
    private boolean myCancelOnClickOutside;
    private boolean myCancelOnOtherWindowOpen;
    private boolean myResizable;
    private IdeTooltip myCurrentIdeTooltip;
    private HintHint myHintHint;
    private JComponent myFocusRequestor;
    private boolean myForceHideShadow;

    public LightweightHint(@NotNull JComponent component) {
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/ui/LightweightHint", "<init>"));
        }
        this.myListenerList = new EventListenerList();
        this.myIsRealPopup = false;
        this.myForceLightweightPopup = false;
        this.myForceShowAsPopup = false;
        this.myTitle = null;
        this.myCancelOnClickOutside = true;
        this.myCancelOnOtherWindowOpen = true;
        this.myForceHideShadow = false;
        this.myComponent = component;
    }

    public void setForceLightweightPopup(boolean forceLightweightPopup) {
        this.myForceLightweightPopup = forceLightweightPopup;
    }

    public void setForceShowAsPopup(boolean forceShowAsPopup) {
        this.myForceShowAsPopup = forceShowAsPopup;
    }

    public void setFocusRequestor(JComponent c2) {
        this.myFocusRequestor = c2;
    }

    public void setTitle(String title) {
        this.myTitle = title;
    }

    public boolean isSelectingHint() {
        return this.mySelectingHint;
    }

    public void setSelectingHint(boolean selectingHint) {
        this.mySelectingHint = selectingHint;
    }

    public void setCancelOnClickOutside(boolean b2) {
        this.myCancelOnClickOutside = b2;
    }

    public void setCancelOnOtherWindowOpen(boolean b2) {
        this.myCancelOnOtherWindowOpen = b2;
    }

    public void setResizable(boolean b2) {
        this.myResizable = b2;
    }

    protected boolean canAutoHideOn(TooltipEvent event) {
        return true;
    }

    @Override
    public void show(@NotNull JComponent parentComponent, int x2, int y2, JComponent focusBackComponent, final @NotNull HintHint hintHint) {
        if (parentComponent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentComponent", "com/intellij/ui/LightweightHint", "show"));
        }
        if (hintHint == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hintHint", "com/intellij/ui/LightweightHint", "show"));
        }
        this.myParentComponent = parentComponent;
        this.myHintHint = hintHint;
        this.myFocusBackComponent = focusBackComponent;
        LOG.assertTrue(this.myParentComponent.isShowing());
        this.myEscListener = new MyEscListener();
        this.myComponent.registerKeyboardAction(this.myEscListener, KeyStroke.getKeyStroke(27, 0), 2);
        this.myComponent.registerKeyboardAction(this.myEscListener, KeyStroke.getKeyStroke(27, 0), 0);
        JLayeredPane layeredPane = parentComponent.getRootPane().getLayeredPane();
        this.myComponent.validate();
        if (!this.myForceShowAsPopup && (this.myForceLightweightPopup || LightweightHint.fitsLayeredPane(layeredPane, this.myComponent, new RelativePoint((Component)parentComponent, new Point(x2, y2)), hintHint))) {
            this.beforeShow();
            Dimension preferredSize = this.myComponent.getPreferredSize();
            if (hintHint.isAwtTooltip()) {
                IdeTooltip tooltip = new IdeTooltip(hintHint.getOriginalComponent(), hintHint.getOriginalPoint(), this.myComponent, new Object[]{hintHint, this.myComponent}){

                    @Override
                    protected boolean canAutohideOn(TooltipEvent event) {
                        if (!LightweightHint.this.canAutoHideOn(event)) {
                            return false;
                        }
                        if (event.getInputEvent() instanceof MouseEvent) {
                            return !hintHint.isContentActive() || !event.isIsEventInsideBalloon();
                        }
                        return event.getAction() == null;
                    }

                    @Override
                    protected void onHidden() {
                        LightweightHint.this.fireHintHidden();
                        TooltipController.getInstance().resetCurrent();
                    }

                    @Override
                    public boolean canBeDismissedOnTimeout() {
                        return false;
                    }
                }.setToCenterIfSmall(hintHint.isMayCenterTooltip()).setPreferredPosition(hintHint.getPreferredPosition()).setHighlighterType(hintHint.isHighlighterType()).setTextForeground(hintHint.getTextForeground()).setTextBackground(hintHint.getTextBackground()).setBorderColor(hintHint.getBorderColor()).setBorderInsets(hintHint.getBorderInsets()).setFont(hintHint.getTextFont()).setCalloutShift(hintHint.getCalloutShift()).setPositionChangeShift(hintHint.getPositionChangeX(), hintHint.getPositionChangeY()).setExplicitClose(hintHint.isExplicitClose()).setRequestFocus(hintHint.isRequestFocus()).setHint(true);
                this.myComponent.validate();
                this.myCurrentIdeTooltip = IdeTooltipManager.getInstance().show(tooltip, hintHint.isShowImmediately(), hintHint.isAnimationEnabled());
            } else {
                Point layeredPanePoint = SwingUtilities.convertPoint(parentComponent, x2, y2, layeredPane);
                this.myComponent.setBounds(layeredPanePoint.x, layeredPanePoint.y, preferredSize.width, preferredSize.height);
                layeredPane.add((Component)this.myComponent, JLayeredPane.POPUP_LAYER);
                this.myComponent.validate();
                this.myComponent.repaint();
            }
        } else {
            this.myIsRealPopup = true;
            Point actualPoint = new Point(x2, y2);
            OpaquePanel actualComponent = new OpaquePanel((LayoutManager)new BorderLayout());
            actualComponent.add((Component)this.myComponent, "Center");
            if (this.isAwtTooltip()) {
                int inset = BalloonImpl.getNormalInset();
                actualComponent.setBorder(new LineBorder(hintHint.getTextBackground(), inset));
                actualComponent.setBackground(hintHint.getTextBackground());
                actualComponent.validate();
            }
            this.myPopup = JBPopupFactory.getInstance().createComponentPopupBuilder((JComponent)actualComponent, this.myFocusRequestor).setRequestFocus(this.myFocusRequestor != null).setFocusable(this.myFocusRequestor != null).setResizable(this.myResizable).setMovable(this.myTitle != null).setTitle(this.myTitle).setModalContext(false).setShowShadow(this.isRealPopup() && !this.isForceHideShadow()).setCancelKeyEnabled(false).setCancelOnClickOutside(this.myCancelOnClickOutside).setCancelCallback(() -> {
                this.onPopupCancel();
                return true;
            }).setCancelOnOtherWindowOpen(this.myCancelOnOtherWindowOpen).createPopup();
            this.beforeShow();
            this.myPopup.show(new RelativePoint((Component)this.myParentComponent, new Point(actualPoint.x, actualPoint.y)));
        }
    }

    protected void onPopupCancel() {
    }

    private void fixActualPoint(Point actualPoint) {
        if (!this.isAwtTooltip()) {
            return;
        }
        if (!this.myIsRealPopup) {
            return;
        }
        Dimension size = this.myComponent.getPreferredSize();
        Balloon.Position position = this.myHintHint.getPreferredPosition();
        int shift = BalloonImpl.getPointerLength(position, false);
        switch (position) {
            case below: {
                actualPoint.y += shift;
                break;
            }
            case above: {
                actualPoint.y -= shift + size.height;
                break;
            }
            case atLeft: {
                actualPoint.x -= shift + size.width;
                break;
            }
            case atRight: {
                actualPoint.y += shift;
            }
        }
    }

    protected void beforeShow() {
    }

    public boolean vetoesHiding() {
        return false;
    }

    public boolean isForceHideShadow() {
        return this.myForceHideShadow;
    }

    public void setForceHideShadow(boolean forceHideShadow) {
        this.myForceHideShadow = forceHideShadow;
    }

    private static boolean fitsLayeredPane(JLayeredPane pane, JComponent component, RelativePoint desiredLocation, HintHint hintHint) {
        if (hintHint.isAwtTooltip()) {
            Dimension size = component.getPreferredSize();
            Dimension paneSize = pane.getSize();
            Point target = desiredLocation.getPointOn((Component)pane).getPoint();
            Balloon.Position pos = hintHint.getPreferredPosition();
            int pointer = BalloonImpl.getPointerLength(pos, false) + BalloonImpl.getNormalInset();
            if (pos == Balloon.Position.above || pos == Balloon.Position.below) {
                boolean heightFit = target.y - size.height - pointer > 0 || target.y + size.height + pointer < paneSize.height;
                return heightFit && size.width + pointer < paneSize.width;
            }
            boolean widthFit = target.x - size.width - pointer > 0 || target.x + size.width + pointer < paneSize.width;
            return widthFit && size.height + pointer < paneSize.height;
        }
        Rectangle lpRect = new Rectangle(pane.getLocationOnScreen().x, pane.getLocationOnScreen().y, pane.getWidth(), pane.getHeight());
        Rectangle componentRect = new Rectangle(desiredLocation.getScreenPoint().x, desiredLocation.getScreenPoint().y, component.getPreferredSize().width, component.getPreferredSize().height);
        return lpRect.contains(componentRect);
    }

    private void fireHintHidden() {
        EventListener[] listeners;
        for (EventListener listener2 : listeners = this.myListenerList.getListeners(HintListener.class)) {
            ((HintListener)listener2).hintHidden(new EventObject(this));
        }
    }

    public final Rectangle getBounds() {
        Rectangle bounds = new Rectangle(this.myComponent.getBounds());
        JLayeredPane layeredPane = this.myParentComponent.getRootPane().getLayeredPane();
        return SwingUtilities.convertRectangle(this.myComponent, bounds, layeredPane);
    }

    @Override
    public boolean isVisible() {
        if (this.myIsRealPopup) {
            return this.myPopup != null && this.myPopup.isVisible();
        }
        if (this.myCurrentIdeTooltip != null) {
            return this.myComponent.isShowing() || IdeTooltipManager.getInstance().isQueuedToShow(this.myCurrentIdeTooltip);
        }
        return this.myComponent.isShowing();
    }

    public final boolean isRealPopup() {
        return this.myIsRealPopup || this.myForceShowAsPopup;
    }

    @Override
    public void hide() {
        this.hide(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void hide(boolean ok) {
        if (this.isVisible()) {
            if (this.myIsRealPopup) {
                if (ok) {
                    this.myPopup.closeOk(null);
                } else {
                    this.myPopup.cancel();
                }
                this.myPopup = null;
            } else if (this.myCurrentIdeTooltip != null) {
                IdeTooltip tooltip = this.myCurrentIdeTooltip;
                this.myCurrentIdeTooltip = null;
                tooltip.hide();
            } else {
                JLayeredPane layeredPane;
                JRootPane rootPane = this.myComponent.getRootPane();
                JLayeredPane jLayeredPane = layeredPane = rootPane == null ? null : rootPane.getLayeredPane();
                if (layeredPane != null) {
                    Rectangle bounds = this.myComponent.getBounds();
                    try {
                        if (this.myFocusBackComponent != null) {
                            LayoutFocusTraversalPolicyExt.setOverridenDefaultComponent(this.myFocusBackComponent);
                        }
                        layeredPane.remove(this.myComponent);
                    }
                    finally {
                        LayoutFocusTraversalPolicyExt.setOverridenDefaultComponent(null);
                    }
                    layeredPane.paintImmediately(bounds.x, bounds.y, bounds.width, bounds.height);
                }
            }
        }
        if (this.myEscListener != null) {
            this.myComponent.unregisterKeyboardAction(KeyStroke.getKeyStroke(27, 0));
        }
        TooltipController.getInstance().hide(this);
        this.fireHintHidden();
    }

    @Override
    public void pack() {
        this.setSize(this.myComponent.getPreferredSize());
    }

    public void updateLocation(int x2, int y2) {
        Point point = new Point(x2, y2);
        this.fixActualPoint(point);
        this.setLocation(new RelativePoint((Component)this.myParentComponent, point));
    }

    public void updatePosition(Balloon.Position position) {
        if (this.myHintHint != null) {
            this.myHintHint.setPreferredPosition(position);
        }
        if (this.myCurrentIdeTooltip != null) {
            this.myCurrentIdeTooltip.setPreferredPosition(position);
        }
    }

    public final JComponent getComponent() {
        return this.myComponent;
    }

    @Override
    public final void addHintListener(@NotNull HintListener listener2) {
        if (listener2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/ui/LightweightHint", "addHintListener"));
        }
        this.myListenerList.add(HintListener.class, listener2);
    }

    @Override
    public final void removeHintListener(@NotNull HintListener listener2) {
        if (listener2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/ui/LightweightHint", "removeHintListener"));
        }
        this.myListenerList.remove(HintListener.class, listener2);
    }

    public Point getLocationOn(JComponent c2) {
        Point location;
        if (this.isRealPopup() && !this.myPopup.isDisposed()) {
            location = this.myPopup.getLocationOnScreen();
            SwingUtilities.convertPointFromScreen(location, c2);
        } else {
            if (this.myCurrentIdeTooltip != null) {
                Point tipPoint = this.myCurrentIdeTooltip.getPoint();
                Component tipComponent = this.myCurrentIdeTooltip.getComponent();
                return SwingUtilities.convertPoint(tipComponent, tipPoint, c2);
            }
            location = SwingUtilities.convertPoint(this.myComponent.getParent(), this.myComponent.getLocation(), c2);
        }
        return location;
    }

    @Override
    public void setLocation(@NotNull RelativePoint point) {
        if (point == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "point", "com/intellij/ui/LightweightHint", "setLocation"));
        }
        if (this.isRealPopup()) {
            this.myPopup.setLocation(point.getScreenPoint());
        } else if (this.myCurrentIdeTooltip != null) {
            Point screenPoint = point.getScreenPoint();
            if (!screenPoint.equals(new RelativePoint(this.myCurrentIdeTooltip.getComponent(), this.myCurrentIdeTooltip.getPoint()).getScreenPoint())) {
                this.myCurrentIdeTooltip.setPoint(point.getPoint());
                this.myCurrentIdeTooltip.setComponent(point.getComponent());
                IdeTooltipManager.getInstance().show(this.myCurrentIdeTooltip, true, false);
            }
        } else {
            Point targetPoint = point.getPoint((Component)this.myComponent.getParent());
            this.myComponent.setLocation(targetPoint);
            this.myComponent.revalidate();
            this.myComponent.repaint();
        }
    }

    public void setSize(Dimension size) {
        if (this.myIsRealPopup && this.myPopup != null) {
            JComponent popupContent = this.myPopup.getContent();
            int widthExpand = 0;
            int heightExpand = 0;
            boolean adjustSize = false;
            JComponent prev = this.myComponent;
            for (Container c2 = this.myComponent.getParent(); c2 != null; c2 = c2.getParent()) {
                if (c2 == popupContent) {
                    adjustSize = true;
                    break;
                }
                if (c2 instanceof JComponent) {
                    Border border = ((JComponent)c2).getBorder();
                    if (prev != null && border != null) {
                        Insets insets = border.getBorderInsets(prev);
                        widthExpand += insets.left + insets.right;
                        heightExpand += insets.top + insets.bottom;
                    }
                    prev = (JComponent)c2;
                    continue;
                }
                prev = null;
            }
            Dimension sizeToUse = size;
            if (adjustSize && (widthExpand != 0 || heightExpand != 0)) {
                sizeToUse = new Dimension(size.width + widthExpand, size.height + heightExpand);
            }
            this.myPopup.setSize(sizeToUse);
        } else if (!this.isAwtTooltip()) {
            this.myComponent.setSize(size);
            this.myComponent.revalidate();
            this.myComponent.repaint();
        }
    }

    public boolean isAwtTooltip() {
        return this.myHintHint != null && this.myHintHint.isAwtTooltip();
    }

    public Dimension getSize() {
        return this.myComponent.getSize();
    }

    public boolean isInsideHint(RelativePoint target) {
        if (this.myComponent == null || !this.myComponent.isShowing()) {
            return false;
        }
        if (this.myIsRealPopup) {
            Window wnd = SwingUtilities.getWindowAncestor(this.myComponent);
            return wnd.getBounds().contains(target.getScreenPoint());
        }
        if (this.myCurrentIdeTooltip != null) {
            return this.myCurrentIdeTooltip.isInside(target);
        }
        return new Rectangle(this.myComponent.getLocationOnScreen(), this.myComponent.getSize()).contains(target.getScreenPoint());
    }

    public String toString() {
        return this.getComponent().toString();
    }

    public boolean canControlAutoHide() {
        return this.myCurrentIdeTooltip != null && this.myCurrentIdeTooltip.getTipComponent().isShowing();
    }

    public IdeTooltip getCurrentIdeTooltip() {
        return this.myCurrentIdeTooltip;
    }

    private final class MyEscListener
    implements ActionListener {
        private MyEscListener() {
        }

        @Override
        public final void actionPerformed(ActionEvent e2) {
            LightweightHint.this.hide();
        }
    }
}

