/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.ListCellRendererWrapper;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;

public abstract class ListCellRendererWithRightAlignedComponent<T>
implements ListCellRenderer {
    private ListCellRenderer myLeftRenderer;
    private ListCellRenderer myRightRenderer;
    private JComponent myPanel = new JPanel(new BorderLayout());
    private String myLeftText;
    private String myRightText;
    private Icon myIcon;
    private Icon myRightIcon;
    private Color myRightForeground;

    public ListCellRendererWithRightAlignedComponent() {
        this.myLeftRenderer = new ListCellRendererWrapper<T>(){

            public void customize(JList list2, T value2, int index, boolean selected, boolean hasFocus) {
                this.setText(ListCellRendererWithRightAlignedComponent.this.myLeftText);
                this.setIcon(ListCellRendererWithRightAlignedComponent.this.myIcon);
            }
        };
        this.myRightRenderer = new ListCellRendererWrapper<T>(){

            public void customize(JList list2, T value2, int index, boolean selected, boolean hasFocus) {
                this.setText(StringUtil.notNullize((String)ListCellRendererWithRightAlignedComponent.this.myRightText));
                this.setIcon(ListCellRendererWithRightAlignedComponent.this.myRightIcon);
                this.setForeground(ListCellRendererWithRightAlignedComponent.this.myRightForeground);
            }
        };
    }

    protected abstract void customize(T var1);

    public Component getListCellRendererComponent(JList list2, Object value2, int index, boolean isSelected, boolean cellHasFocus) {
        this.myPanel.removeAll();
        this.myLeftText = null;
        this.myRightText = null;
        this.myIcon = null;
        this.myRightForeground = null;
        this.customize(value2);
        this.myPanel.add(this.myLeftRenderer.getListCellRendererComponent(list2, value2, index, isSelected, cellHasFocus), "Center");
        this.myPanel.add(this.myRightRenderer.getListCellRendererComponent(list2, value2, index, isSelected, cellHasFocus), "East");
        return this.myPanel;
    }

    protected Icon getRightIcon() {
        return this.myRightIcon;
    }

    protected void setRightIcon(Icon rightIcon) {
        this.myRightIcon = rightIcon;
    }

    protected final void setLeftText(String text2) {
        this.myLeftText = text2;
    }

    protected final void setIcon(Icon icon) {
        this.myIcon = icon;
    }

    protected final void setRightText(String text2) {
        this.myRightText = text2;
    }

    protected final void setRightForeground(Color color) {
        this.myRightForeground = color;
    }
}

