/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.JScrollPane;

public abstract class ScrollPaneActions
extends AnAction {
    private final String mySwingActionId;

    private ScrollPaneActions(String actionId) {
        this.mySwingActionId = actionId;
    }

    public void update(AnActionEvent event) {
        JScrollPane pane = this.getScrollPane(event);
        event.getPresentation().setEnabled(pane != null && null != this.getSwingAction(pane));
    }

    public void actionPerformed(AnActionEvent event) {
        JScrollPane pane = this.getScrollPane(event);
        if (pane == null) {
            return;
        }
        Action action2 = this.getSwingAction(pane);
        if (action2 == null) {
            return;
        }
        action2.actionPerformed(new ActionEvent(pane, 1001, this.mySwingActionId));
    }

    private JScrollPane getScrollPane(AnActionEvent event) {
        Component component = (Component)event.getData(PlatformDataKeys.CONTEXT_COMPONENT);
        return (JScrollPane)UIUtil.getParentOfType(JScrollPane.class, (Component)component);
    }

    private Action getSwingAction(JScrollPane pane) {
        ActionMap map2 = pane.getActionMap();
        return map2 == null ? null : map2.get(this.mySwingActionId);
    }

    public static final class PageRight
    extends ScrollPaneActions {
        public PageRight() {
            super("scrollRight");
        }
    }

    public static final class PageLeft
    extends ScrollPaneActions {
        public PageLeft() {
            super("scrollLeft");
        }
    }

    public static final class PageDown
    extends ScrollPaneActions {
        public PageDown() {
            super("scrollDown");
        }
    }

    public static final class PageUp
    extends ScrollPaneActions {
        public PageUp() {
            super("scrollUp");
        }
    }

    public static final class Right
    extends ScrollPaneActions {
        public Right() {
            super("unitScrollRight");
        }
    }

    public static final class Left
    extends ScrollPaneActions {
        public Left() {
            super("unitScrollLeft");
        }
    }

    public static final class Down
    extends ScrollPaneActions {
        public Down() {
            super("unitScrollDown");
        }
    }

    public static final class Up
    extends ScrollPaneActions {
        public Up() {
            super("unitScrollUp");
        }
    }

    public static final class End
    extends ScrollPaneActions {
        public End() {
            super("scrollEnd");
        }
    }

    public static final class Home
    extends ScrollPaneActions {
        public Home() {
            super("scrollHome");
        }
    }
}

