/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.Cell;
import com.intellij.ui.ColorPicker;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.TableSpeedSearch;
import com.intellij.ui.TableUtil;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.table.JBTable;
import com.intellij.util.PairFunction;
import com.intellij.util.ui.EmptyIcon;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.MouseEvent;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.EventObject;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.ColorUIResource;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import org.jetbrains.annotations.Nullable;

public class ShowUIDefaultsAction
extends AnAction
implements DumbAware {
    public void actionPerformed(AnActionEvent e2) {
        UIDefaults defaults = UIManager.getDefaults();
        Enumeration keys = defaults.keys();
        final Object[][] data = new Object[defaults.size()][2];
        int i2 = 0;
        while (keys.hasMoreElements()) {
            Object key = keys.nextElement();
            data[i2][0] = key;
            data[i2][1] = defaults.get(key);
            ++i2;
        }
        Arrays.sort(data, (o1, o2) -> StringUtil.naturalCompare((String)o1[0].toString(), (String)o2[0].toString()));
        final Project project2 = ShowUIDefaultsAction.getEventProject((AnActionEvent)e2);
        new DialogWrapper(project2){
            public JBTable myTable;
            {
                super(arg0);
                this.setTitle("Edit LaF Defaults");
                this.setModal(false);
                this.init();
            }

            @Nullable
            public JComponent getPreferredFocusedComponent() {
                return this.myTable;
            }

            @Nullable
            protected String getDimensionServiceKey() {
                return project2 == null ? null : "UI.Defaults.Dialog";
            }

            protected JComponent createCenterPanel() {
                JBTable table2 = new JBTable(new DefaultTableModel(data, new Object[]{"Name", "Value"}){

                    @Override
                    public boolean isCellEditable(int row, int column) {
                        return column == 1 && this.getValueAt(row, column) instanceof Color;
                    }
                }){

                    public boolean editCellAt(int row, int column, EventObject e2) {
                        Object color;
                        Color newColor;
                        if (this.isCellEditable(row, column) && e2 instanceof MouseEvent && (newColor = ColorPicker.showDialog((Component)((Object)this), "Choose Color", (Color)(color = this.getValueAt(row, column)), true, null, true)) != null) {
                            ColorUIResource colorUIResource = new ColorUIResource(newColor);
                            Object key = this.getValueAt(row, 0);
                            UIManager.put(key, colorUIResource);
                            this.setValueAt(colorUIResource, row, column);
                        }
                        return false;
                    }
                };
                table2.setDefaultRenderer(Object.class, (TableCellRenderer)new DefaultTableCellRenderer(){

                    @Override
                    public Component getTableCellRendererComponent(JTable table2, Object value2, boolean isSelected, boolean hasFocus, int row, int column) {
                        JPanel panel2 = new JPanel(new BorderLayout());
                        JLabel label = new JLabel(value2 == null ? "" : value2.toString());
                        panel2.add((Component)label, "Center");
                        if (value2 instanceof Color) {
                            Color c2 = (Color)value2;
                            label.setText(String.format("[r=%d,g=%d,b=%d] hex=0x%s", c2.getRed(), c2.getGreen(), c2.getBlue(), ColorUtil.toHex((Color)c2)));
                            label.setForeground(ColorUtil.isDark((Color)c2) ? Color.white : Color.black);
                            panel2.setBackground(c2);
                            return panel2;
                        }
                        if (value2 instanceof Icon) {
                            try {
                                IconWrap icon = new IconWrap((Icon)value2);
                                if (icon.getIconHeight() <= 20) {
                                    label.setIcon(icon);
                                }
                                label.setText(String.format("(%dx%d) %s)", icon.getIconWidth(), icon.getIconHeight(), label.getText()));
                            }
                            catch (Throwable icon) {
                                // empty catch block
                            }
                            return panel2;
                        }
                        if (value2 instanceof Border) {
                            try {
                                Insets i2 = ((Border)value2).getBorderInsets(null);
                                label.setText(String.format("[%d, %d, %d, %d] %s", i2.top, i2.left, i2.bottom, i2.right, label.getText()));
                                return panel2;
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                        return super.getTableCellRendererComponent(table2, value2, isSelected, hasFocus, row, column);
                    }
                });
                JBScrollPane pane = new JBScrollPane((Component)table2);
                new TableSpeedSearch((JTable)table2, (PairFunction<Object, Cell, String>)((PairFunction)(o2, cell) -> cell.column == 1 ? null : String.valueOf(o2)));
                table2.setShowGrid(false);
                JPanel panel2 = new JPanel(new BorderLayout());
                panel2.add((Component)pane, "Center");
                this.myTable = table2;
                TableUtil.ensureSelectionExists((JTable)this.myTable);
                return panel2;
            }
        }.show();
    }

    private class IconWrap
    implements Icon {
        private final Icon myIcon;

        public IconWrap(Icon icon) {
            this.myIcon = icon;
        }

        @Override
        public void paintIcon(Component c2, Graphics g2, int x2, int y2) {
            try {
                this.myIcon.paintIcon(c2, g2, x2, y2);
            }
            catch (Exception e2) {
                EmptyIcon.ICON_0.paintIcon(c2, g2, x2, y2);
            }
        }

        @Override
        public int getIconWidth() {
            return this.myIcon.getIconWidth();
        }

        @Override
        public int getIconHeight() {
            return this.myIcon.getIconHeight();
        }
    }
}

