/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.ide.StartupProgress;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.ui.LicensingFacade;
import com.intellij.ui.ScreenUtil;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.Insets;
import java.awt.Rectangle;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JRootPane;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Splash
extends JDialog
implements StartupProgress {
    @Nullable
    public static Rectangle BOUNDS;
    private final Icon myImage;
    private final ApplicationInfoEx myInfo;
    private int myProgressHeight;
    private Color myProgressColor;
    private int myProgressX;
    private int myProgressY;
    private float myProgress;
    private boolean mySplashIsVisible;
    private int myProgressLastPosition;
    private final JLabel myLabel;
    private Icon myProgressTail;
    private static float JBUI_INIT_SCALE;

    public Splash(@NotNull ApplicationInfoEx info) {
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/intellij/ui/Splash", "<init>"));
        }
        super((Frame)null, false);
        this.myProgressColor = null;
        this.myProgressLastPosition = 0;
        this.myInfo = info;
        if (info instanceof ApplicationInfoImpl) {
            ApplicationInfoImpl appInfo = (ApplicationInfoImpl)info;
            this.myProgressHeight = appInfo.getProgressHeight();
            this.myProgressColor = appInfo.getProgressColor();
            this.myProgressX = appInfo.getProgressX();
            this.myProgressY = appInfo.getProgressY();
            this.myProgressTail = appInfo.getProgressTailIcon();
        }
        this.setUndecorated(true);
        if (!SystemInfo.isLinux || !SystemInfo.isJavaVersionAtLeast((String)"1.7")) {
            this.setResizable(false);
        }
        this.setFocusableWindowState(false);
        Icon originalImage = IconLoader.getIcon((String)info.getSplashImageUrl());
        this.myImage = new SplashImage(IconLoader.getIconSnapshot((Icon)originalImage), info.getSplashTextColor());
        this.myLabel = new JLabel(this.myImage){

            @Override
            protected void paintComponent(Graphics g2) {
                super.paintComponent(g2);
                Splash.this.mySplashIsVisible = true;
                Splash.this.myProgressLastPosition = 0;
                Splash.this.paintProgress(g2);
            }
        };
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        contentPane.add((Component)this.myLabel, "Center");
        Dimension size = this.getPreferredSize();
        this.setSize(size);
        this.pack();
        this.setLocationInTheCenterOfScreen();
    }

    private void setLocationInTheCenterOfScreen() {
        Rectangle bounds = this.getGraphicsConfiguration().getBounds();
        if (SystemInfo.isWindows) {
            JBInsets.removeFrom((Rectangle)bounds, (Insets)ScreenUtil.getScreenInsets((GraphicsConfiguration)this.getGraphicsConfiguration()));
        }
        this.setLocation(UIUtil.getCenterPoint((Rectangle)bounds, (Dimension)this.getSize()));
    }

    @Override
    public void show() {
        super.show();
        this.toFront();
        BOUNDS = this.getBounds();
    }

    public void showProgress(String message2, float progress) {
        if (this.getProgressColor() == null) {
            return;
        }
        if ((double)(progress - this.myProgress) > 0.01) {
            this.myProgress = progress;
            this.myLabel.paintImmediately(0, 0, this.myImage.getIconWidth(), this.myImage.getIconHeight());
        }
    }

    @Override
    public void dispose() {
        super.dispose();
        this.removeAll();
        DialogWrapper.cleanupRootPane((JRootPane)this.rootPane);
        this.rootPane = null;
    }

    private void paintProgress(Graphics g2) {
        Color color = this.getProgressColor();
        if (color == null) {
            return;
        }
        if (!this.mySplashIsVisible) {
            this.myImage.paintIcon(this, g2, 0, 0);
            this.mySplashIsVisible = true;
        }
        int totalWidth = this.myImage.getIconWidth() - this.getProgressX();
        if (Registry.is((String)"ide.new.about")) {
            totalWidth += 3;
        }
        int progressWidth = (int)((float)totalWidth * this.myProgress);
        int width = progressWidth - this.myProgressLastPosition;
        g2.setColor(color);
        g2.fillRect(this.getProgressX(), this.getProgressY(), width, this.getProgressHeight());
        if (this.myProgressTail != null) {
            this.myProgressTail.paintIcon(this, g2, (int)((float)(this.getProgressX() + width) - (float)this.myProgressTail.getIconWidth() / Splash.uiScale(1.0f) / 2.0f * Splash.uiScale(1.0f)), (int)((float)this.getProgressY() - (float)(this.myProgressTail.getIconHeight() - this.getProgressHeight()) / Splash.uiScale(1.0f) / 2.0f * Splash.uiScale(1.0f)));
        }
        this.myProgressLastPosition = progressWidth;
    }

    private Color getProgressColor() {
        return this.myProgressColor;
    }

    private int getProgressHeight() {
        return (int)Splash.uiScale((float)this.myProgressHeight);
    }

    private int getProgressX() {
        return (int)Splash.uiScale((float)this.myProgressX);
    }

    private int getProgressY() {
        return (int)Splash.uiScale((float)this.myProgressY);
    }

    public static boolean showLicenseeInfo(Graphics g2, int x2, int y2, int height, Color textColor, ApplicationInfo info) {
        if (ApplicationInfoImpl.getShadowInstance().showLicenseeInfo()) {
            LicensingFacade provider = LicensingFacade.getInstance();
            if (provider != null) {
                Font font;
                UIUtil.applyRenderingHints((Graphics)g2);
                Font font2 = SystemInfo.isMacOSElCapitan ? Splash.createFont(".SF NS Text") : (font = SystemInfo.isMacOSYosemite ? Splash.createFont("HelveticaNeue-Regular") : null);
                if (font == null || UIUtil.isDialogFont((Font)font)) {
                    font = Splash.createFont("Arial");
                }
                g2.setFont(font);
                g2.setColor(textColor);
                String licensedToMessage = provider.getLicensedToMessage();
                List<String> licenseRestrictionsMessages = provider.getLicenseRestrictionsMessages();
                int offsetX = Splash.uiScale(15);
                int offsetY = 30;
                if (Registry.is((String)"ide.new.about")) {
                    if (info instanceof ApplicationInfoImpl) {
                        offsetX = Math.max(offsetX, Splash.uiScale(((ApplicationInfoImpl)info).getProgressX()));
                        offsetY = ((ApplicationInfoImpl)info).getLicenseOffsetY();
                    } else {
                        return false;
                    }
                }
                g2.drawString(licensedToMessage, x2 + offsetX, y2 + height - Splash.uiScale(offsetY));
                if (licenseRestrictionsMessages.size() > 0) {
                    g2.drawString(licenseRestrictionsMessages.get(0), x2 + offsetX, y2 + height - Splash.uiScale(offsetY - 16));
                }
            }
            return true;
        }
        return false;
    }

    @NotNull
    protected static Font createFont(String name) {
        Font font = new Font(name, 0, Splash.uiScale(Registry.is((String)"ide.new.about") ? 12 : (SystemInfo.isUnix ? 10 : 11)));
        if (font == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/Splash", "createFont"));
        }
        return font;
    }

    private static float uiScale(float f2) {
        return f2 * JBUI_INIT_SCALE;
    }

    private static int uiScale(int i2) {
        return (int)((float)i2 * JBUI_INIT_SCALE);
    }

    static {
        JBUI_INIT_SCALE = JBUI.scale((float)1.0f);
    }

    private final class SplashImage
    implements Icon {
        private final Icon myIcon;
        private final Color myTextColor;
        private boolean myRedrawing;

        public SplashImage(Icon originalIcon, Color textColor) {
            this.myIcon = originalIcon;
            this.myTextColor = textColor;
        }

        @Override
        public void paintIcon(Component c2, Graphics g2, int x2, int y2) {
            if (!this.myRedrawing) {
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                this.myRedrawing = true;
            }
            this.myIcon.paintIcon(c2, g2, x2, y2);
            Splash.showLicenseeInfo(g2, x2, y2, this.getIconHeight(), this.myTextColor, Splash.this.myInfo);
        }

        @Override
        public int getIconWidth() {
            return this.myIcon.getIconWidth();
        }

        @Override
        public int getIconHeight() {
            return this.myIcon.getIconHeight();
        }
    }
}

