/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.notification.impl.NotificationsConfigurationImpl;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.ui.GrowlNotifications;
import com.intellij.ui.LibNotifyWrapper;
import com.intellij.ui.MountainLionNotifications;
import com.intellij.ui.SystemNotifications;
import org.jetbrains.annotations.NotNull;

public class SystemNotificationsImpl
extends SystemNotifications {
    private final Notifier myNotifier = SystemNotificationsImpl.getPlatformNotifier();

    @Override
    public boolean isAvailable() {
        return this.myNotifier != null;
    }

    @Override
    public void notify(@NotNull String notificationName, @NotNull String title, @NotNull String text2) {
        if (notificationName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "notificationName", "com/intellij/ui/SystemNotificationsImpl", "notify"));
        }
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/intellij/ui/SystemNotificationsImpl", "notify"));
        }
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/ui/SystemNotificationsImpl", "notify"));
        }
        if (this.myNotifier != null && NotificationsConfigurationImpl.getInstanceImpl().SYSTEM_NOTIFICATIONS && !ApplicationManager.getApplication().isActive()) {
            this.myNotifier.notify(notificationName, title, text2);
        }
    }

    private static Notifier getPlatformNotifier() {
        try {
            if (SystemInfo.isMac) {
                if (SystemInfo.isMacOSMountainLion && Registry.is((String)"ide.mac.mountain.lion.notifications.enabled")) {
                    return MountainLionNotifications.getInstance();
                }
                if (!Boolean.getBoolean("growl.disable")) {
                    return GrowlNotifications.getInstance();
                }
            }
            if (SystemInfo.isXWindow && Registry.is((String)"ide.libnotify.enabled")) {
                return LibNotifyWrapper.getInstance();
            }
        }
        catch (Throwable t2) {
            Logger logger = Logger.getInstance(SystemNotifications.class);
            if (logger.isDebugEnabled()) {
                logger.debug(t2);
            }
            logger.info(t2.getMessage());
        }
        return null;
    }

    static interface Notifier {
        public void notify(@NotNull String var1, @NotNull String var2, @NotNull String var3);
    }
}

