/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.PrevNextActionsDescriptor;
import com.intellij.ui.TabbedPane;
import com.intellij.ui.TabbedPaneWrapper;
import com.intellij.ui.components.JBTabbedPane;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import javax.swing.JComponent;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.TabbedPaneUI;
import javax.swing.plaf.basic.BasicTabbedPaneUI;
import org.intellij.lang.annotations.JdkConstants;
import org.jetbrains.annotations.NonNls;

public class TabbedPaneImpl
extends JBTabbedPane
implements TabbedPane {
    public static final PrevNextActionsDescriptor DEFAULT_PREV_NEXT_SHORTCUTS = new PrevNextActionsDescriptor("NextTab", "PreviousTab");
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.ui.TabbedPaneImpl");
    private ScrollableTabSupport myScrollableTabSupport;
    private AnAction myNextTabAction = null;
    private AnAction myPreviousTabAction = null;
    public PrevNextActionsDescriptor myInstallKeyboardNavigation = null;

    public TabbedPaneImpl(@JdkConstants.TabPlacement int tabPlacement) {
        super(tabPlacement);
        this.setFocusable(false);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e2) {
                TabbedPaneImpl.this._requestDefaultFocus();
            }
        });
    }

    @Override
    public void setKeyboardNavigation(PrevNextActionsDescriptor installKeyboardNavigation) {
        this.myInstallKeyboardNavigation = installKeyboardNavigation;
    }

    @Override
    public JComponent getComponent() {
        return this;
    }

    public void addNotify() {
        super.addNotify();
        if (this.myInstallKeyboardNavigation != null) {
            this.installKeyboardNavigation(this.myInstallKeyboardNavigation);
        }
    }

    public void removeNotify() {
        super.removeNotify();
        if (this.myInstallKeyboardNavigation != null) {
            this.uninstallKeyboardNavigation();
        }
    }

    private void installKeyboardNavigation(PrevNextActionsDescriptor installKeyboardNavigation) {
        this.myNextTabAction = new AnAction(){
            {
                this.setEnabledInModalContext(true);
            }

            public void actionPerformed(AnActionEvent e2) {
                int index = TabbedPaneImpl.this.getSelectedIndex() + 1;
                if (index >= TabbedPaneImpl.this.getTabCount()) {
                    index = 0;
                }
                TabbedPaneImpl.this.setSelectedIndex(index);
            }
        };
        AnAction nextAction2 = ActionManager.getInstance().getAction(installKeyboardNavigation.getNextActionId());
        LOG.assertTrue(nextAction2 != null, (Object)("Cannot find action with specified id: " + installKeyboardNavigation.getNextActionId()));
        this.myNextTabAction.registerCustomShortcutSet(nextAction2.getShortcutSet(), (JComponent)((Object)this));
        this.myPreviousTabAction = new AnAction(){
            {
                this.setEnabledInModalContext(true);
            }

            public void actionPerformed(AnActionEvent e2) {
                int index = TabbedPaneImpl.this.getSelectedIndex() - 1;
                if (index < 0) {
                    index = TabbedPaneImpl.this.getTabCount() - 1;
                }
                TabbedPaneImpl.this.setSelectedIndex(index);
            }
        };
        AnAction prevAction = ActionManager.getInstance().getAction(installKeyboardNavigation.getPrevActionId());
        LOG.assertTrue(prevAction != null, (Object)("Cannot find action with specified id: " + installKeyboardNavigation.getPrevActionId()));
        this.myPreviousTabAction.registerCustomShortcutSet(prevAction.getShortcutSet(), (JComponent)((Object)this));
    }

    private void uninstallKeyboardNavigation() {
        if (this.myNextTabAction != null) {
            this.myNextTabAction.unregisterCustomShortcutSet((JComponent)((Object)this));
            this.myNextTabAction = null;
        }
        if (this.myPreviousTabAction != null) {
            this.myPreviousTabAction.unregisterCustomShortcutSet((JComponent)((Object)this));
            this.myPreviousTabAction = null;
        }
    }

    public void setUI(TabbedPaneUI ui) {
        super.setUI(ui);
        this.myScrollableTabSupport = ui instanceof BasicTabbedPaneUI ? new ScrollableTabSupport((BasicTabbedPaneUI)ui) : null;
    }

    @Override
    public final void scrollTabToVisible(int index) {
        block10: {
            Rectangle tabBounds;
            TabbedPaneUI tabbedPaneUI;
            block8: {
                block9: {
                    if (this.myScrollableTabSupport == null || 0 == this.getTabLayoutPolicy()) {
                        return;
                    }
                    tabbedPaneUI = this.getUI();
                    tabBounds = tabbedPaneUI.getTabBounds((JTabbedPane)((Object)this), index);
                    int tabPlacement = this.getTabPlacement();
                    if (1 != tabPlacement && 3 != tabPlacement) break block8;
                    if (tabBounds.x >= 50) break block9;
                    int leadingTabIndex = this.myScrollableTabSupport.getLeadingTabIndex();
                    while (leadingTabIndex != index && leadingTabIndex > 0 && tabBounds.x < 50) {
                        this.myScrollableTabSupport.setLeadingTabIndex(leadingTabIndex - 1);
                        leadingTabIndex = this.myScrollableTabSupport.getLeadingTabIndex();
                        tabBounds = tabbedPaneUI.getTabBounds((JTabbedPane)((Object)this), index);
                    }
                    break block10;
                }
                if (tabBounds.x + tabBounds.width <= this.getWidth() - 50) break block10;
                int leadingTabIndex = this.myScrollableTabSupport.getLeadingTabIndex();
                while (leadingTabIndex != index && leadingTabIndex < this.getTabCount() - 1 && tabBounds.x + tabBounds.width > this.getWidth() - 50) {
                    this.myScrollableTabSupport.setLeadingTabIndex(leadingTabIndex + 1);
                    leadingTabIndex = this.myScrollableTabSupport.getLeadingTabIndex();
                    tabBounds = tabbedPaneUI.getTabBounds((JTabbedPane)((Object)this), index);
                }
                break block10;
            }
            if (tabBounds.y < 30) {
                int leadingTabIndex = this.myScrollableTabSupport.getLeadingTabIndex();
                while (leadingTabIndex != index && leadingTabIndex > 0 && tabBounds.y < 30) {
                    this.myScrollableTabSupport.setLeadingTabIndex(leadingTabIndex - 1);
                    leadingTabIndex = this.myScrollableTabSupport.getLeadingTabIndex();
                    tabBounds = tabbedPaneUI.getTabBounds((JTabbedPane)((Object)this), index);
                }
            } else if (tabBounds.y + tabBounds.height > this.getHeight() - 30) {
                int leadingTabIndex = this.myScrollableTabSupport.getLeadingTabIndex();
                while (leadingTabIndex != index && leadingTabIndex < this.getTabCount() - 1 && tabBounds.y + tabBounds.height > this.getHeight() - 30) {
                    this.myScrollableTabSupport.setLeadingTabIndex(leadingTabIndex + 1);
                    leadingTabIndex = this.myScrollableTabSupport.getLeadingTabIndex();
                    tabBounds = tabbedPaneUI.getTabBounds((JTabbedPane)((Object)this), index);
                }
            }
        }
    }

    @Override
    public void setSelectedIndex(int index) {
        if (index >= this.getTabCount()) {
            return;
        }
        try {
            super.setSelectedIndex(index);
        }
        catch (ArrayIndexOutOfBoundsException e2) {
            return;
        }
        this.scrollTabToVisible(index);
        this.doLayout();
    }

    protected void fireStateChanged() {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i2 = listeners.length - 2; i2 >= 0; i2 -= 2) {
            ChangeListener each;
            if (listeners[i2] != ChangeListener.class) continue;
            if (this.changeEvent == null) {
                this.changeEvent = new ChangeEvent(this);
            }
            if ((each = (ChangeListener)listeners[i2 + 1]) == null) continue;
            if (each.getClass().getName().contains("apple.laf.CUIAquaTabbedPane")) {
                SwingUtilities.invokeLater(() -> {
                    this.revalidate();
                    this.repaint();
                });
                continue;
            }
            each.stateChanged(this.changeEvent);
        }
    }

    @Override
    public final void removeTabAt(int index) {
        super.removeTabAt(index);
        this.fireStateChanged();
    }

    private void _requestDefaultFocus() {
        Component selectedComponent = this.getSelectedComponent();
        if (selectedComponent instanceof TabbedPaneWrapper.TabWrapper) {
            ((TabbedPaneWrapper.TabWrapper)selectedComponent).requestDefaultFocus();
        } else {
            super.requestDefaultFocus();
        }
    }

    protected final int getTabIndexAt(int x2, int y2) {
        TabbedPaneUI ui = this.getUI();
        for (int i2 = 0; i2 < this.getTabCount(); ++i2) {
            Rectangle bounds = ui.getTabBounds((JTabbedPane)((Object)this), i2);
            if (!bounds.contains(x2, y2)) continue;
            return i2;
        }
        return -1;
    }

    @Override
    public boolean isDisposed() {
        return false;
    }

    private final class ScrollableTabSupport {
        private final BasicTabbedPaneUI myUI;
        @NonNls
        public static final String TAB_SCROLLER_NAME = "tabScroller";
        @NonNls
        public static final String LEADING_TAB_INDEX_NAME = "leadingTabIndex";
        @NonNls
        public static final String SET_LEADING_TAB_INDEX_METHOD = "setLeadingTabIndex";

        public ScrollableTabSupport(BasicTabbedPaneUI ui) {
            this.myUI = ui;
        }

        public int getLeadingTabIndex() {
            try {
                Field tabScrollerField = BasicTabbedPaneUI.class.getDeclaredField(TAB_SCROLLER_NAME);
                tabScrollerField.setAccessible(true);
                Object tabScrollerValue = tabScrollerField.get(this.myUI);
                Field leadingTabIndexField = tabScrollerValue.getClass().getDeclaredField(LEADING_TAB_INDEX_NAME);
                leadingTabIndexField.setAccessible(true);
                return leadingTabIndexField.getInt(tabScrollerValue);
            }
            catch (Exception exc) {
                String writer = StringUtil.getThrowableText((Throwable)exc);
                throw new IllegalStateException("myUI=" + this.myUI + "; cause=" + writer);
            }
        }

        public void setLeadingTabIndex(int leadingIndex) {
            try {
                Method[] methods;
                Field tabScrollerField = BasicTabbedPaneUI.class.getDeclaredField(TAB_SCROLLER_NAME);
                tabScrollerField.setAccessible(true);
                Object tabScrollerValue = tabScrollerField.get(this.myUI);
                Method setLeadingIndexMethod = null;
                for (Method method2 : methods = tabScrollerValue.getClass().getDeclaredMethods()) {
                    if (!SET_LEADING_TAB_INDEX_METHOD.equals(method2.getName())) continue;
                    setLeadingIndexMethod = method2;
                    break;
                }
                if (setLeadingIndexMethod == null) {
                    throw new IllegalStateException("method setLeadingTabIndex not found");
                }
                setLeadingIndexMethod.setAccessible(true);
                setLeadingIndexMethod.invoke(tabScrollerValue, TabbedPaneImpl.this.getTabPlacement(), leadingIndex);
            }
            catch (Exception exc) {
                String writer = StringUtil.getThrowableText((Throwable)exc);
                throw new IllegalStateException("myUI=" + this.myUI + "; cause=" + writer);
            }
        }
    }
}

