/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.application.ex.ApplicationEx;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.ex.IdeFocusTraversalPolicy;
import com.intellij.ui.JBTabsPaneImpl;
import com.intellij.ui.PrevNextActionsDescriptor;
import com.intellij.ui.TabbedPane;
import com.intellij.ui.TabbedPaneImpl;
import com.intellij.ui.tabs.JBTabs;
import com.intellij.util.IJSwingUtilities;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.MouseListener;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TabbedPaneWrapper {
    protected TabbedPane myTabbedPane;
    protected JComponent myTabbedPaneHolder;
    private TabFactory myFactory;

    protected TabbedPaneWrapper(boolean construct) {
        if (construct) {
            this.init(1, TabbedPaneImpl.DEFAULT_PREV_NEXT_SHORTCUTS, new JTabbedPaneFactory(this));
        }
    }

    public TabbedPaneWrapper(@NotNull Disposable parentDisposable) {
        if (parentDisposable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentDisposable", "com/intellij/ui/TabbedPaneWrapper", "<init>"));
        }
        this(1, TabbedPaneImpl.DEFAULT_PREV_NEXT_SHORTCUTS, parentDisposable);
    }

    public TabbedPaneWrapper(int tabPlacement, PrevNextActionsDescriptor installKeyboardNavigation, @NotNull Disposable parentDisposable) {
        if (parentDisposable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentDisposable", "com/intellij/ui/TabbedPaneWrapper", "<init>"));
        }
        TabFactory factory2 = 3 == tabPlacement || 1 == tabPlacement ? new JBTabsFactory(this, null, parentDisposable) : new JTabbedPaneFactory(this);
        this.init(tabPlacement, installKeyboardNavigation, factory2);
    }

    void init(int tabPlacement, PrevNextActionsDescriptor installKeyboardNavigation, TabFactory tabbedPaneFactory) {
        this.myFactory = tabbedPaneFactory;
        this.myTabbedPane = this.createTabbedPane(tabPlacement);
        this.myTabbedPane.putClientProperty(TabbedPaneWrapper.class, this.myTabbedPane);
        this.myTabbedPane.setKeyboardNavigation(installKeyboardNavigation);
        this.myTabbedPaneHolder = this.createTabbedPaneHolder();
        this.myTabbedPaneHolder.add((Component)this.myTabbedPane.getComponent(), "Center");
        this.myTabbedPaneHolder.setFocusTraversalPolicyProvider(true);
        this.myTabbedPaneHolder.setFocusTraversalPolicy(new _MyFocusTraversalPolicy());
        this.assertIsDispatchThread();
    }

    public boolean isDisposed() {
        return this.myTabbedPane != null && this.myTabbedPane.isDisposed();
    }

    private void assertIsDispatchThread() {
        ApplicationEx application = ApplicationManagerEx.getApplicationEx();
        if (application != null) {
            application.assertIsDispatchThread(this.myTabbedPane.getComponent());
        }
    }

    public final void addChangeListener(ChangeListener listener2) {
        this.assertIsDispatchThread();
        this.myTabbedPane.addChangeListener(listener2);
    }

    public final void removeChangeListener(ChangeListener listener2) {
        this.assertIsDispatchThread();
        this.myTabbedPane.removeChangeListener(listener2);
    }

    protected TabbedPaneHolder createTabbedPaneHolder() {
        return this.myFactory.createTabbedPaneHolder();
    }

    public final JComponent getComponent() {
        this.assertIsDispatchThread();
        return this.myTabbedPaneHolder;
    }

    public final synchronized void addTab(String title, Icon icon, JComponent component, String tip) {
        this.insertTab(title, icon, component, tip, this.myTabbedPane.getTabCount());
    }

    public final synchronized void addTab(String title, JComponent component) {
        this.insertTab(title, null, component, null, this.myTabbedPane.getTabCount());
    }

    public synchronized void insertTab(String title, Icon icon, JComponent component, String tip, int index) {
        this.myTabbedPane.insertTab(title, icon, this.createTabWrapper(component), tip, index);
    }

    protected TabWrapper createTabWrapper(JComponent component) {
        return this.myFactory.createTabWrapper(component);
    }

    protected TabbedPane createTabbedPane(int tabPlacement) {
        return this.myFactory.createTabbedPane(tabPlacement);
    }

    public final void setTabPlacement(int tabPlacement) {
        this.assertIsDispatchThread();
        this.myTabbedPane.setTabPlacement(tabPlacement);
    }

    public final void addMouseListener(MouseListener listener2) {
        this.assertIsDispatchThread();
        this.myTabbedPane.addMouseListener(listener2);
    }

    public final synchronized int getSelectedIndex() {
        return this.myTabbedPane.getSelectedIndex();
    }

    public final synchronized JComponent getSelectedComponent() {
        TabWrapper tabWrapper = this.myTabbedPane.getTabCount() > 0 ? (TabWrapper)this.myTabbedPane.getSelectedComponent() : null;
        return tabWrapper != null ? tabWrapper.getComponent() : null;
    }

    public final void setSelectedIndex(int index) {
        this.setSelectedIndex(index, true);
    }

    public final void setSelectedIndex(int index, boolean requestFocus2) {
        this.assertIsDispatchThread();
        boolean hadFocus = IJSwingUtilities.hasFocus2(this.myTabbedPaneHolder);
        this.myTabbedPane.setSelectedIndex(index);
        if (hadFocus && requestFocus2) {
            this.myTabbedPaneHolder.requestFocus();
        }
    }

    public final void setSelectedComponent(JComponent component) {
        this.assertIsDispatchThread();
        int index = this.indexOfComponent(component);
        if (index == -1) {
            throw new IllegalArgumentException("component not found in tabbed pane wrapper");
        }
        this.setSelectedIndex(index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized void removeTabAt(int index) {
        this.assertIsDispatchThread();
        boolean hadFocus = IJSwingUtilities.hasFocus2(this.myTabbedPaneHolder);
        TabWrapper wrapper = this.getWrapperAt(index);
        try {
            this.myTabbedPane.removeTabAt(index);
            if (this.myTabbedPane.getTabCount() == 0) {
                this.myTabbedPane.revalidate();
            }
            if (hadFocus) {
                this.myTabbedPaneHolder.requestFocus();
            }
        }
        finally {
            wrapper.dispose();
        }
    }

    public final synchronized int getTabCount() {
        return this.myTabbedPane.getTabCount();
    }

    public final Color getForegroundAt(int index) {
        this.assertIsDispatchThread();
        return this.myTabbedPane.getForegroundAt(index);
    }

    public final void setForegroundAt(int index, Color color) {
        this.assertIsDispatchThread();
        this.myTabbedPane.setForegroundAt(index, color);
    }

    public final Component getTabComponentAt(int index) {
        return this.myTabbedPane.getTabComponentAt(index);
    }

    public final synchronized JComponent getComponentAt(int i2) {
        return this.getWrapperAt(i2).getComponent();
    }

    private TabWrapper getWrapperAt(int i2) {
        return (TabWrapper)this.myTabbedPane.getComponentAt(i2);
    }

    public final void setTitleAt(int index, String title) {
        this.assertIsDispatchThread();
        this.myTabbedPane.setTitleAt(index, title);
    }

    public final void setToolTipTextAt(int index, String toolTipText) {
        this.assertIsDispatchThread();
        this.myTabbedPane.setToolTipTextAt(index, toolTipText);
    }

    public final synchronized void setComponentAt(int index, JComponent component) {
        this.assertIsDispatchThread();
        this.myTabbedPane.setComponentAt(index, this.createTabWrapper(component));
    }

    public final void setIconAt(int index, Icon icon) {
        this.assertIsDispatchThread();
        this.myTabbedPane.setIconAt(index, icon);
    }

    public final void setEnabledAt(int index, boolean enabled) {
        this.assertIsDispatchThread();
        this.myTabbedPane.setEnabledAt(index, enabled);
    }

    public final synchronized int indexOfComponent(JComponent component) {
        for (int i2 = 0; i2 < this.myTabbedPane.getTabCount(); ++i2) {
            JComponent c2 = this.getWrapperAt(i2).getComponent();
            if (c2 != component) continue;
            return i2;
        }
        return -1;
    }

    public final synchronized int getTabLayoutPolicy() {
        return this.myTabbedPane.getTabLayoutPolicy();
    }

    public final synchronized void setTabLayoutPolicy(int policy) {
        this.myTabbedPane.setTabLayoutPolicy(policy);
        int index = this.myTabbedPane.getSelectedIndex();
        if (index != -1) {
            this.myTabbedPane.scrollTabToVisible(index);
        }
    }

    public final void installKeyboardNavigation() {
    }

    public final void uninstallKeyboardNavigation() {
    }

    public final String getTitleAt(int i2) {
        return this.myTabbedPane.getTitleAt(i2);
    }

    public void setSelectedTitle(@Nullable String title) {
        if (title == null) {
            return;
        }
        for (int i2 = 0; i2 < this.myTabbedPane.getTabCount(); ++i2) {
            String each = this.myTabbedPane.getTitleAt(i2);
            if (!title.equals(each)) continue;
            this.myTabbedPane.setSelectedIndex(i2);
            break;
        }
    }

    @Nullable
    public String getSelectedTitle() {
        return this.getSelectedIndex() < 0 ? null : this.getTitleAt(this.getSelectedIndex());
    }

    public void removeAll() {
        this.myTabbedPane.removeAll();
    }

    public static TabbedPaneWrapper get(JTabbedPane tabs) {
        return (TabbedPaneWrapper)tabs.getClientProperty(TabbedPaneWrapper.class);
    }

    public static class AsJTabbedPane
    extends TabbedPaneWrapper {
        public AsJTabbedPane(int tabPlacement) {
            super(false);
            this.init(tabPlacement, TabbedPaneImpl.DEFAULT_PREV_NEXT_SHORTCUTS, new JTabbedPaneFactory(this));
        }
    }

    public static class AsJBTabs
    extends TabbedPaneWrapper {
        public AsJBTabs(@Nullable Project project2, int tabPlacement, PrevNextActionsDescriptor installKeyboardNavigation, @NotNull Disposable parent) {
            if (parent == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/ui/TabbedPaneWrapper$AsJBTabs", "<init>"));
            }
            super(false);
            this.init(tabPlacement, installKeyboardNavigation, new JBTabsFactory(this, project2, parent));
        }

        public JBTabs getTabs() {
            return ((JBTabsPaneImpl)this.myTabbedPane).getTabs();
        }
    }

    private static class JBTabsFactory
    implements TabFactory {
        private final Project myProject;
        private final Disposable myParent;
        private final TabbedPaneWrapper myWrapper;

        private JBTabsFactory(TabbedPaneWrapper wrapper, Project project2, @NotNull Disposable parent) {
            if (parent == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/ui/TabbedPaneWrapper$JBTabsFactory", "<init>"));
            }
            this.myWrapper = wrapper;
            this.myProject = project2;
            this.myParent = parent;
        }

        @Override
        public TabbedPane createTabbedPane(int tabPlacement) {
            return new JBTabsPaneImpl(this.myProject, tabPlacement, this.myParent);
        }

        @Override
        public TabbedPaneHolder createTabbedPaneHolder() {
            return new TabbedPaneHolder(this.myWrapper){

                @Override
                public boolean requestDefaultFocus() {
                    this.getTabs().requestFocus();
                    return true;
                }
            };
        }

        @Override
        public TabWrapper createTabWrapper(JComponent component) {
            TabWrapper tabWrapper = new TabWrapper(component);
            tabWrapper.myCustomFocus = false;
            return tabWrapper;
        }

        public JBTabs getTabs() {
            return ((JBTabsPaneImpl)this.myWrapper.myTabbedPane).getTabs();
        }

        public void dispose() {
        }
    }

    private static class JTabbedPaneFactory
    implements TabFactory {
        private final TabbedPaneWrapper myWrapper;

        private JTabbedPaneFactory(TabbedPaneWrapper wrapper) {
            this.myWrapper = wrapper;
        }

        @Override
        public TabbedPane createTabbedPane(int tabPlacement) {
            return new TabbedPaneImpl(tabPlacement);
        }

        @Override
        public TabbedPaneHolder createTabbedPaneHolder() {
            return new TabbedPaneHolder(this.myWrapper);
        }

        @Override
        public TabWrapper createTabWrapper(JComponent component) {
            return new TabWrapper(component);
        }
    }

    private static interface TabFactory {
        public TabbedPane createTabbedPane(int var1);

        public TabbedPaneHolder createTabbedPaneHolder();

        public TabWrapper createTabWrapper(JComponent var1);
    }

    public static class TabbedPaneHolder
    extends JPanel {
        private final TabbedPaneWrapper myWrapper;

        protected TabbedPaneHolder(TabbedPaneWrapper wrapper) {
            super(new BorderLayout());
            this.myWrapper = wrapper;
        }

        @Override
        public boolean requestDefaultFocus() {
            JComponent preferredFocusedComponent = IdeFocusTraversalPolicy.getPreferredFocusedComponent(this.myWrapper.myTabbedPane.getComponent());
            if (preferredFocusedComponent != null) {
                if (!preferredFocusedComponent.requestFocusInWindow()) {
                    preferredFocusedComponent.requestFocus();
                }
                return true;
            }
            return super.requestDefaultFocus();
        }

        @Override
        public final void requestFocus() {
            this.requestDefaultFocus();
        }

        @Override
        public final boolean requestFocusInWindow() {
            return this.requestDefaultFocus();
        }

        @Override
        public void updateUI() {
            super.updateUI();
            if (this.myWrapper != null) {
                this.myWrapper.myTabbedPane.updateUI();
            }
        }

        public TabbedPaneWrapper getTabbedPaneWrapper() {
            return this.myWrapper;
        }
    }

    private final class _MyFocusTraversalPolicy
    extends IdeFocusTraversalPolicy {
        private _MyFocusTraversalPolicy() {
        }

        @Override
        public boolean isNoDefaultComponent() {
            return false;
        }

        @Override
        public final Component getDefaultComponentImpl(Container focusCycleRoot) {
            JComponent component = TabbedPaneWrapper.this.getSelectedComponent();
            if (component != null) {
                return IdeFocusTraversalPolicy.getPreferredFocusedComponent(component, this);
            }
            return null;
        }
    }

    public static final class TabWrapper
    extends JPanel
    implements DataProvider {
        private JComponent myComponent;
        boolean myCustomFocus;

        public TabWrapper(@NotNull JComponent component) {
            if (component == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/ui/TabbedPaneWrapper$TabWrapper", "<init>"));
            }
            super(new BorderLayout());
            this.myCustomFocus = true;
            this.myComponent = component;
            this.add((Component)component, "Center");
        }

        public Object getData(String dataId) {
            if (this.myComponent instanceof DataProvider) {
                return ((DataProvider)this.myComponent).getData(dataId);
            }
            return null;
        }

        public JComponent getComponent() {
            return this.myComponent;
        }

        public void dispose() {
            if (this.myComponent != null) {
                this.remove(this.myComponent);
                this.myComponent = null;
            }
        }

        @Override
        public boolean requestDefaultFocus() {
            if (!this.myCustomFocus) {
                return super.requestDefaultFocus();
            }
            if (this.myComponent == null) {
                return false;
            }
            JComponent preferredFocusedComponent = IdeFocusTraversalPolicy.getPreferredFocusedComponent(this.myComponent);
            if (preferredFocusedComponent != null) {
                if (!preferredFocusedComponent.requestFocusInWindow()) {
                    preferredFocusedComponent.requestFocus();
                }
                return true;
            }
            return this.myComponent.requestDefaultFocus();
        }

        @Override
        public void requestFocus() {
            if (!this.myCustomFocus) {
                super.requestFocus();
            } else {
                this.requestDefaultFocus();
            }
        }

        @Override
        public boolean requestFocusInWindow() {
            if (!this.myCustomFocus) {
                return super.requestFocusInWindow();
            }
            return this.requestDefaultFocus();
        }
    }
}

