/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.openapi.util.Pair;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.table.TableColumn;
import org.jetbrains.annotations.NonNls;

public class TableColumnAnimator
extends Timer
implements ActionListener {
    private final JTable myTable;
    private boolean added = false;
    private final List<Pair<TableColumn, Integer>> myColumns = new ArrayList<Pair<TableColumn, Integer>>();
    private int myStep = 30;
    private Runnable myDone;

    public TableColumnAnimator(JTable table2) {
        super(50, null);
        this.myTable = table2;
        this.addActionListener(this);
    }

    public void addColumn(TableColumn column, int preferredWidth) {
        this.myColumns.add((Pair<TableColumn, Integer>)Pair.create((Object)column, (Object)preferredWidth));
    }

    public void setStep(int step) {
        this.myStep = step;
    }

    @Override
    public void actionPerformed(ActionEvent e2) {
        if (this.myColumns.isEmpty()) {
            this.stop();
            if (this.myDone != null) {
                SwingUtilities.invokeLater(this.myDone);
            }
            return;
        }
        TableColumn c2 = (TableColumn)this.myColumns.get((int)0).first;
        if (!this.added) {
            this.myTable.addColumn(c2);
            c2.setMaxWidth(0);
            c2.setPreferredWidth(0);
            c2.setWidth(0);
            this.added = true;
        }
        int prefWidth = (Integer)this.myColumns.get((int)0).second;
        int width = c2.getWidth();
        width = Math.min(width + this.myStep, prefWidth);
        c2.setMaxWidth(width);
        c2.setPreferredWidth(width);
        c2.setWidth(width);
        if (width == prefWidth) {
            this.added = false;
            this.myColumns.remove(0);
        }
    }

    public void startAndDoWhenDone(Runnable done2) {
        this.myDone = done2;
    }

    @NonNls
    public String toString() {
        return "Table column animator";
    }
}

