/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.ui.TextFieldWithAutoCompletionListProvider;
import com.intellij.util.textCompletion.TextCompletionUtil;
import com.intellij.util.textCompletion.TextFieldWithCompletion;
import java.util.Collection;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TextFieldWithAutoCompletion<T>
extends TextFieldWithCompletion {
    public static final TextFieldWithAutoCompletionListProvider EMPTY_COMPLETION = new StringsCompletionProvider(null, null);
    @NotNull
    private final TextFieldWithAutoCompletionListProvider<T> myProvider;

    public TextFieldWithAutoCompletion(@Nullable Project project2, @NotNull TextFieldWithAutoCompletionListProvider<T> provider, boolean showCompletionHint, @Nullable String text2) {
        if (provider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "provider", "com/intellij/ui/TextFieldWithAutoCompletion", "<init>"));
        }
        super(project2, provider, text2 == null ? "" : text2, true, true, false, showCompletionHint);
        this.myProvider = provider;
    }

    @NotNull
    public static TextFieldWithAutoCompletion<String> create(@Nullable Project project2, @NotNull Collection<String> items2, boolean showCompletionHint, @Nullable String text2) {
        if (items2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "items", "com/intellij/ui/TextFieldWithAutoCompletion", "create"));
        }
        TextFieldWithAutoCompletion<String> textFieldWithAutoCompletion = TextFieldWithAutoCompletion.create(project2, items2, null, showCompletionHint, text2);
        if (textFieldWithAutoCompletion == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/TextFieldWithAutoCompletion", "create"));
        }
        return textFieldWithAutoCompletion;
    }

    @NotNull
    public static TextFieldWithAutoCompletion<String> create(@Nullable Project project2, @NotNull Collection<String> items2, @Nullable Icon icon, boolean showCompletionHint, @Nullable String text2) {
        if (items2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "items", "com/intellij/ui/TextFieldWithAutoCompletion", "create"));
        }
        TextFieldWithAutoCompletion<String> textFieldWithAutoCompletion = new TextFieldWithAutoCompletion<String>(project2, new StringsCompletionProvider(items2, icon), showCompletionHint, text2);
        if (textFieldWithAutoCompletion == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/TextFieldWithAutoCompletion", "create"));
        }
        return textFieldWithAutoCompletion;
    }

    public void setVariants(@NotNull Collection<T> variants) {
        if (variants == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variants", "com/intellij/ui/TextFieldWithAutoCompletion", "setVariants"));
        }
        this.myProvider.setItems(variants);
    }

    public <T> void installProvider(@NotNull TextFieldWithAutoCompletionListProvider<T> provider) {
        if (provider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "provider", "com/intellij/ui/TextFieldWithAutoCompletion", "installProvider"));
        }
        TextFieldWithAutoCompletion.installCompletion(this.getDocument(), this.getProject(), provider, true);
    }

    public static void installCompletion(@NotNull Document document, @NotNull Project project2, @NotNull TextFieldWithAutoCompletionListProvider provider, boolean autoPopup) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/ui/TextFieldWithAutoCompletion", "installCompletion"));
        }
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/ui/TextFieldWithAutoCompletion", "installCompletion"));
        }
        if (provider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "provider", "com/intellij/ui/TextFieldWithAutoCompletion", "installCompletion"));
        }
        PsiFile psiFile = PsiDocumentManager.getInstance((Project)project2).getPsiFile(document);
        if (psiFile != null) {
            TextCompletionUtil.installProvider(psiFile, provider, autoPopup);
        }
    }

    public static class StringsCompletionProvider
    extends TextFieldWithAutoCompletionListProvider<String>
    implements DumbAware {
        @Nullable
        private final Icon myIcon;

        public StringsCompletionProvider(@Nullable Collection<String> variants, @Nullable Icon icon) {
            super(variants);
            this.myIcon = icon;
        }

        @Override
        public int compare(String item1, String item2) {
            return StringUtil.compare((String)item1, (String)item2, (boolean)false);
        }

        @Override
        protected Icon getIcon(@NotNull String item) {
            if (item == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "item", "com/intellij/ui/TextFieldWithAutoCompletion$StringsCompletionProvider", "getIcon"));
            }
            return this.myIcon;
        }

        @Override
        @NotNull
        protected String getLookupString(@NotNull String item) {
            if (item == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "item", "com/intellij/ui/TextFieldWithAutoCompletion$StringsCompletionProvider", "getLookupString"));
            }
            String string2 = item;
            if (string2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/TextFieldWithAutoCompletion$StringsCompletionProvider", "getLookupString"));
            }
            return string2;
        }
    }
}

