/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.openapi.util.Pair;
import com.intellij.ui.AbstractExpandableItemsHandler;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;

public class TreeExpandableItemsHandler
extends AbstractExpandableItemsHandler<Integer, JTree> {
    protected TreeExpandableItemsHandler(final JTree tree2) {
        super(tree2);
        final TreeSelectionListener selectionListener2 = new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e2) {
                TreeExpandableItemsHandler.this.updateSelection(tree2);
            }
        };
        tree2.getSelectionModel().addTreeSelectionListener(selectionListener2);
        tree2.addPropertyChangeListener("selectionModel", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                TreeExpandableItemsHandler.this.updateSelection(tree2);
                if (evt.getOldValue() != null) {
                    ((TreeSelectionModel)evt.getOldValue()).removeTreeSelectionListener(selectionListener2);
                }
                if (evt.getNewValue() != null) {
                    ((TreeSelectionModel)evt.getNewValue()).addTreeSelectionListener(selectionListener2);
                }
            }
        });
        final TreeModelListener modelListener = new TreeModelListener(){

            @Override
            public void treeNodesChanged(TreeModelEvent e2) {
                TreeExpandableItemsHandler.this.updateCurrentSelection();
            }

            @Override
            public void treeNodesInserted(TreeModelEvent e2) {
                TreeExpandableItemsHandler.this.updateSelection(tree2);
            }

            @Override
            public void treeNodesRemoved(TreeModelEvent e2) {
                TreeExpandableItemsHandler.this.updateSelection(tree2);
            }

            @Override
            public void treeStructureChanged(TreeModelEvent e2) {
                TreeExpandableItemsHandler.this.updateSelection(tree2);
            }
        };
        if (tree2.getModel() != null) {
            tree2.getModel().addTreeModelListener(modelListener);
        }
        tree2.addPropertyChangeListener("model", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                TreeExpandableItemsHandler.this.updateSelection(tree2);
                if (evt.getOldValue() != null) {
                    ((TreeModel)evt.getOldValue()).removeTreeModelListener(modelListener);
                }
                if (evt.getNewValue() != null) {
                    ((TreeModel)evt.getNewValue()).addTreeModelListener(modelListener);
                }
            }
        });
    }

    private void updateSelection(JTree tree2) {
        int selection = tree2.getSelectionCount() == 1 ? tree2.getSelectionModel().getLeadSelectionRow() : -1;
        this.handleSelectionChange(selection == -1 ? null : Integer.valueOf(selection));
    }

    @Override
    protected Integer getCellKeyForPoint(Point point) {
        int rowIndex = ((JTree)this.myComponent).getRowForLocation(point.x, point.y);
        return rowIndex != -1 ? Integer.valueOf(rowIndex) : null;
    }

    @Override
    protected Pair<Component, Rectangle> getCellRendererAndBounds(Integer key) {
        int rowIndex = key;
        TreePath path = ((JTree)this.myComponent).getPathForRow(rowIndex);
        if (path == null) {
            return null;
        }
        Rectangle bounds = ((JTree)this.myComponent).getPathBounds(path);
        if (bounds == null) {
            return null;
        }
        TreeCellRenderer renderer = ((JTree)this.myComponent).getCellRenderer();
        if (renderer == null) {
            return null;
        }
        Object node = path.getLastPathComponent();
        Component rendererComponent = renderer.getTreeCellRendererComponent((JTree)this.myComponent, node, ((JTree)this.myComponent).isRowSelected(rowIndex), ((JTree)this.myComponent).isExpanded(rowIndex), ((JTree)this.myComponent).getModel().isLeaf(node), rowIndex, ((JTree)this.myComponent).hasFocus());
        return Pair.create((Object)rendererComponent, (Object)bounds);
    }

    @Override
    protected void doPaintTooltipImage(Component rComponent, Rectangle cellBounds, Graphics2D g2, Integer key) {
        boolean opaque = rComponent.isOpaque();
        if (rComponent instanceof JComponent) {
            ((JComponent)rComponent).setOpaque(true);
        }
        if (((JTree)this.myComponent).isRowSelected(key)) {
            rComponent.setBackground(UIUtil.getTreeSelectionBackground((boolean)((JTree)this.myComponent).hasFocus()));
        } else {
            Color color;
            Color bg = UIUtil.getTreeTextBackground();
            if (this.myComponent instanceof Tree && ((Tree)this.myComponent).isFileColorsEnabled() && (color = ((Tree)this.myComponent).getFileColorForPath(((JTree)this.myComponent).getPathForRow(key))) != null) {
                bg = color;
            }
            rComponent.setBackground(bg);
        }
        super.doPaintTooltipImage(rComponent, cellBounds, g2, key);
        if (rComponent instanceof JComponent) {
            ((JComponent)rComponent).setOpaque(opaque);
        }
    }
}

