/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.util.io.jna.DisposableMemory;
import com.sun.jna.Function;
import com.sun.jna.Memory;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.platform.win32.Guid;
import com.sun.jna.platform.win32.Ole32;
import com.sun.jna.platform.win32.Ole32Util;
import com.sun.jna.platform.win32.User32;
import com.sun.jna.platform.win32.W32Errors;
import com.sun.jna.platform.win32.WinDef;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.ptr.PointerByReference;
import com.sun.jna.win32.StdCallLibrary;
import com.sun.jna.win32.W32APIOptions;
import java.awt.Component;
import java.awt.peer.ComponentPeer;
import java.lang.reflect.Method;
import java.util.Map;

class Win7TaskBar {
    private static final Logger LOG = Logger.getInstance((String)"Win7TaskBar");
    private static final int TaskBarList_Methods = 21;
    private static final int TaskBarList_SetProgressValue = 9;
    private static final int TaskBarList_SetProgressState = 10;
    private static final int TaskBarList_SetOverlayIcon = 18;
    private static final WinDef.DWORD ICO_VERSION = new WinDef.DWORD(196608L);
    private static final WinDef.DWORD DWORD_ZERO;
    private static final WinDef.DWORD TBPF_NOPROGRESS;
    private static final WinDef.DWORD TBPF_NORMAL;
    private static final WinDef.DWORD TBPF_ERROR;
    private static final WinDef.ULONGLONG TOTAL_PROGRESS;
    private static Pointer myInterfacePointer;
    private static Function mySetProgressValue;
    private static Function mySetProgressState;
    private static Function mySetOverlayIcon;
    private static boolean ourInitialized;

    Win7TaskBar() {
    }

    private static void initialize() {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        Ole32 ole32 = Ole32.INSTANCE;
        ole32.CoInitializeEx(Pointer.NULL, 0);
        Guid.GUID CLSID_TaskbarList = Ole32Util.getGUIDFromString((String)"{56FDF344-FD6D-11d0-958A-006097C9A090}");
        Guid.GUID IID_ITaskbarList3 = Ole32Util.getGUIDFromString((String)"{EA1AFB91-9E28-4B86-90E9-9E9F8A5EEFAF}");
        PointerByReference p2 = new PointerByReference();
        WinNT.HRESULT hr = ole32.CoCreateInstance(CLSID_TaskbarList, Pointer.NULL, 23, IID_ITaskbarList3, p2);
        if (!W32Errors.S_OK.equals((Object)hr)) {
            LOG.error("Win7TaskBar CoCreateInstance(IID_ITaskbarList3) hResult: " + hr);
            ourInitialized = false;
            return;
        }
        myInterfacePointer = p2.getValue();
        Pointer vTablePointer = myInterfacePointer.getPointer(0L);
        Pointer[] vTable = new Pointer[21];
        vTablePointer.read(0L, vTable, 0, vTable.length);
        mySetProgressValue = Function.getFunction((Pointer)vTable[9], (int)63);
        mySetProgressState = Function.getFunction((Pointer)vTable[10], (int)63);
        mySetOverlayIcon = Function.getFunction((Pointer)vTable[18], (int)63);
    }

    static void setProgress(IdeFrame frame, double value2, boolean isOk) {
        if (!Win7TaskBar.isEnabled()) {
            return;
        }
        WinDef.HWND handle = Win7TaskBar.getHandle(frame);
        mySetProgressState.invokeInt(new Object[]{myInterfacePointer, handle, isOk ? TBPF_NORMAL : TBPF_ERROR});
        mySetProgressValue.invokeInt(new Object[]{myInterfacePointer, handle, new WinDef.ULONGLONG((long)(value2 * 100.0)), TOTAL_PROGRESS});
    }

    private static boolean isEnabled() {
        return !ApplicationManager.getApplication().isUnitTestMode() && ourInitialized;
    }

    static void hideProgress(IdeFrame frame) {
        if (!Win7TaskBar.isEnabled()) {
            return;
        }
        mySetProgressState.invokeInt(new Object[]{myInterfacePointer, Win7TaskBar.getHandle(frame), TBPF_NOPROGRESS});
    }

    static void setOverlayIcon(IdeFrame frame, Object icon, boolean dispose2) {
        if (!Win7TaskBar.isEnabled()) {
            return;
        }
        if (icon == null) {
            icon = Pointer.NULL;
        }
        mySetOverlayIcon.invokeInt(new Object[]{myInterfacePointer, Win7TaskBar.getHandle(frame), icon, Pointer.NULL});
        if (dispose2) {
            User32.INSTANCE.DestroyIcon((WinDef.HICON)icon);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Object createIcon(byte[] ico) {
        if (!Win7TaskBar.isEnabled()) {
            return new Object();
        }
        DisposableMemory memory = new DisposableMemory(ico.length);
        try {
            memory.write(0L, ico, 0, ico.length);
            int nSize = 100;
            int offset = User32Ex.INSTANCE.LookupIconIdFromDirectoryEx(memory, true, nSize, nSize, 0);
            if (offset != 0) {
                WinDef.HICON hICON = User32Ex.INSTANCE.CreateIconFromResourceEx(memory.share(offset), DWORD_ZERO, true, ICO_VERSION, nSize, nSize, 0);
                return hICON;
            }
            Object var4_5 = null;
            return var4_5;
        }
        finally {
            memory.dispose();
        }
    }

    static void attention(IdeFrame frame, boolean critical) {
        if (!Win7TaskBar.isEnabled()) {
            return;
        }
        User32Ex.INSTANCE.FlashWindow(Win7TaskBar.getHandle(frame), true);
    }

    private static WinDef.HWND getHandle(IdeFrame frame) {
        try {
            ComponentPeer peer = ((Component)frame).getPeer();
            Method getHWnd = peer.getClass().getMethod("getHWnd", new Class[0]);
            return new WinDef.HWND(new Pointer(((Long)getHWnd.invoke((Object)peer, new Object[0])).longValue()));
        }
        catch (Throwable e2) {
            LOG.error(e2);
            return null;
        }
    }

    static {
        TBPF_NOPROGRESS = DWORD_ZERO = new WinDef.DWORD(0L);
        TBPF_NORMAL = new WinDef.DWORD(2L);
        TBPF_ERROR = new WinDef.DWORD(4L);
        TOTAL_PROGRESS = new WinDef.ULONGLONG(100L);
        ourInitialized = true;
        try {
            Win7TaskBar.initialize();
        }
        catch (Throwable e2) {
            LOG.error(e2);
            ourInitialized = false;
        }
    }

    public static interface User32Ex
    extends StdCallLibrary {
        public static final User32Ex INSTANCE = (User32Ex)Native.loadLibrary((String)"user32", User32Ex.class, (Map)W32APIOptions.DEFAULT_OPTIONS);

        public int LookupIconIdFromDirectoryEx(Memory var1, boolean var2, int var3, int var4, int var5);

        public WinDef.HICON CreateIconFromResourceEx(Pointer var1, WinDef.DWORD var2, boolean var3, WinDef.DWORD var4, int var5, int var6, int var7);

        public boolean FlashWindow(WinDef.HWND var1, boolean var2);
    }
}

