/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.event.MouseInputListener;
import org.intellij.lang.annotations.JdkConstants;

abstract class WindowMouseListener
extends MouseAdapter
implements MouseInputListener {
    private final Component myContent;
    @JdkConstants.CursorType
    int myType;
    private Point myLocation;
    private Rectangle myViewBounds;
    private boolean wasDragged;

    WindowMouseListener(Component content2) {
        this.myContent = content2;
    }

    @JdkConstants.CursorType
    abstract int getCursorType(Component var1, Point var2);

    abstract void updateBounds(Rectangle var1, Component var2, int var3, int var4);

    @Override
    public void mouseMoved(MouseEvent event) {
        this.update(event, false);
    }

    @Override
    public void mousePressed(MouseEvent event) {
        this.update(event, true);
    }

    @Override
    public void mouseDragged(MouseEvent event) {
        this.process(event, false);
    }

    @Override
    public void mouseReleased(MouseEvent event) {
        this.process(event, true);
    }

    @Override
    public void mouseClicked(MouseEvent event) {
        this.process(event, true);
    }

    protected boolean isDisabled(Component view2) {
        if (view2 instanceof Frame) {
            int state = ((Frame)view2).getExtendedState();
            if (WindowMouseListener.isStateSet(1, state)) {
                return true;
            }
            if (WindowMouseListener.isStateSet(6, state)) {
                return true;
            }
        }
        return false;
    }

    private void update(MouseEvent event, boolean start2) {
        Component content2;
        Component view2;
        if (event.isConsumed()) {
            return;
        }
        if (start2) {
            this.wasDragged = false;
        }
        if (this.myLocation == null && (view2 = this.getView(content2 = this.getContent(event))) != null) {
            this.myType = this.isDisabled(view2) ? -1 : this.getCursorType(view2, event.getLocationOnScreen());
            this.setCursor(content2, Cursor.getPredefinedCursor(this.myType == -1 ? 0 : this.myType));
            if (start2 && this.myType != -1) {
                this.myLocation = event.getLocationOnScreen();
                this.myViewBounds = view2.getBounds();
                event.consume();
            }
        }
    }

    private void process(MouseEvent event, boolean stop2) {
        if (event.isConsumed()) {
            return;
        }
        if (!stop2) {
            this.wasDragged = true;
        }
        if (this.myLocation != null && this.myViewBounds != null) {
            Component content2 = this.getContent(event);
            Component view2 = this.getView(content2);
            if (view2 != null) {
                Rectangle bounds = new Rectangle(this.myViewBounds);
                int dx = event.getXOnScreen() - this.myLocation.x;
                int dy = event.getYOnScreen() - this.myLocation.y;
                if (this.myType == 0 && view2 instanceof Frame) {
                    int state = ((Frame)view2).getExtendedState();
                    if (WindowMouseListener.isStateSet(2, state)) {
                        dx = 0;
                    }
                    if (WindowMouseListener.isStateSet(4, state)) {
                        dy = 0;
                    }
                }
                this.updateBounds(bounds, view2, dx, dy);
                if (!bounds.equals(view2.getBounds())) {
                    view2.setBounds(bounds);
                    view2.invalidate();
                    view2.validate();
                    view2.repaint();
                }
            }
            if (stop2) {
                this.setCursor(content2, Cursor.getPredefinedCursor(0));
                this.myLocation = null;
                if (this.wasDragged) {
                    this.myViewBounds = null;
                }
            }
            event.consume();
        } else if (stop2 && this.myViewBounds != null) {
            this.myViewBounds = null;
            event.consume();
        }
    }

    protected Component getContent(MouseEvent event) {
        return this.myContent != null ? this.myContent : event.getComponent();
    }

    protected Component getView(Component component) {
        return UIUtil.getWindow((Component)component);
    }

    protected void setCursor(Component content2, Cursor cursor) {
        content2.setCursor(cursor);
    }

    public boolean isBusy() {
        return this.myLocation != null;
    }

    static boolean isStateSet(int mask, int state) {
        return mask == (mask & state);
    }
}

