/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.ui.WindowMouseListener;
import com.intellij.util.ui.JBInsets;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import javax.swing.Icon;
import javax.swing.SwingUtilities;

public class WindowResizeListener
extends WindowMouseListener {
    private final Insets myBorder;
    private final Icon myCorner;

    public WindowResizeListener(Component content2, Insets border, Icon corner) {
        super(content2);
        this.myBorder = border;
        this.myCorner = corner;
    }

    public WindowResizeListener(Component content2, Icon corner) {
        super(content2);
        this.myBorder = null;
        this.myCorner = corner;
    }

    protected Insets getResizeOffset(Component view2) {
        return null;
    }

    protected Insets getResizeBorder(Component view2) {
        return this.myBorder;
    }

    @Override
    protected boolean isDisabled(Component view2) {
        if (view2 instanceof Dialog && !((Dialog)view2).isResizable()) {
            return true;
        }
        if (view2 instanceof Frame && !((Frame)view2).isResizable()) {
            return true;
        }
        return super.isDisabled(view2);
    }

    @Override
    int getCursorType(Component view2, Point location) {
        Container parent;
        Container container = parent = view2 instanceof Window ? null : view2.getParent();
        if (parent != null) {
            SwingUtilities.convertPointFromScreen(location, parent);
        }
        Rectangle bounds = view2.getBounds();
        JBInsets.removeFrom((Rectangle)bounds, (Insets)this.getResizeOffset(view2));
        int top = location.y - bounds.y;
        if (top < 0) {
            return -1;
        }
        int left = location.x - bounds.x;
        if (left < 0) {
            return -1;
        }
        int right = bounds.width - left;
        if (right < 0) {
            return -1;
        }
        int bottom = bounds.height - top;
        if (bottom < 0) {
            return -1;
        }
        if (this.myCorner != null && right < this.myCorner.getIconWidth() && bottom < this.myCorner.getIconHeight()) {
            return 0;
        }
        Insets expected = this.getResizeBorder(view2);
        if (expected != null) {
            if (view2 instanceof Frame) {
                int state = ((Frame)view2).getExtendedState();
                if (WindowResizeListener.isStateSet(2, state)) {
                    left = Integer.MAX_VALUE;
                    right = Integer.MAX_VALUE;
                }
                if (WindowResizeListener.isStateSet(4, state)) {
                    top = Integer.MAX_VALUE;
                    bottom = Integer.MAX_VALUE;
                }
            }
            if (top < expected.top) {
                if (left < expected.left * 2) {
                    return 6;
                }
                if (right < expected.right * 2) {
                    return 7;
                }
                return 8;
            }
            if (bottom < expected.bottom) {
                if (left < expected.left * 2) {
                    return 4;
                }
                if (right < expected.right * 2) {
                    return 5;
                }
                return 9;
            }
            if (left < expected.left) {
                if (top < expected.top * 2) {
                    return 6;
                }
                if (bottom < expected.bottom * 2) {
                    return 4;
                }
                return 10;
            }
            if (right < expected.right) {
                if (top < expected.top * 2) {
                    return 7;
                }
                if (bottom < expected.bottom * 2) {
                    return 5;
                }
                return 11;
            }
        }
        return -1;
    }

    @Override
    void updateBounds(Rectangle bounds, Component view2, int dx, int dy) {
        Dimension minimum = view2.getMinimumSize();
        if (this.myType == 7 || this.myType == 11 || this.myType == 5 || this.myType == 0) {
            bounds.width += WindowResizeListener.fixMinSize(dx, bounds.width, minimum.width);
        } else if (this.myType == 6 || this.myType == 10 || this.myType == 4) {
            dx = WindowResizeListener.fixMinSize(-dx, bounds.width, minimum.width);
            bounds.x -= dx;
            bounds.width += dx;
        }
        if (this.myType == 4 || this.myType == 9 || this.myType == 5 || this.myType == 0) {
            bounds.height += WindowResizeListener.fixMinSize(dy, bounds.height, minimum.height);
        } else if (this.myType == 6 || this.myType == 8 || this.myType == 7) {
            dy = WindowResizeListener.fixMinSize(-dy, bounds.height, minimum.height);
            bounds.y -= dy;
            bounds.height += dy;
        }
    }

    private static int fixMinSize(int delta, int value2, int min) {
        return delta + value2 < min ? min - value2 : delta;
    }
}

