/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.content;

import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionPopupMenu;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.TabbedPane;
import com.intellij.ui.TabbedPaneImpl;
import com.intellij.ui.TabbedPaneWrapper;
import com.intellij.ui.UIBundle;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import com.intellij.ui.content.ContentManagerAdapter;
import com.intellij.ui.content.ContentManagerEvent;
import com.intellij.ui.content.ContentManagerListener;
import com.intellij.ui.content.ContentUI;
import com.intellij.ui.content.tabs.PinToolwindowTabAction;
import com.intellij.ui.content.tabs.TabbedContentAction;
import com.intellij.util.IJSwingUtilities;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JTabbedPane;
import javax.swing.MenuSelectionManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.TabbedPaneUI;
import org.jetbrains.annotations.NotNull;

public class TabbedPaneContentUI
implements ContentUI,
PropertyChangeListener {
    public static final String POPUP_PLACE = "TabbedPanePopup";
    private ContentManager myManager;
    private TabbedPaneWrapper myTabbedPaneWrapper;

    public TabbedPaneContentUI() {
        this(3);
    }

    public TabbedPaneContentUI(int tabPlacement) {
        this.myTabbedPaneWrapper = new MyTabbedPaneWrapper(tabPlacement);
    }

    public JComponent getComponent() {
        return this.myTabbedPaneWrapper.getComponent();
    }

    public void setManager(@NotNull ContentManager manager) {
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/ui/content/TabbedPaneContentUI", "setManager"));
        }
        if (this.myManager != null) {
            throw new IllegalStateException();
        }
        this.myManager = manager;
        this.myManager.addContentManagerListener((ContentManagerListener)new MyContentManagerListener());
    }

    @Override
    public void propertyChange(PropertyChangeEvent e2) {
        Content content2;
        int index;
        if ("displayName".equals(e2.getPropertyName())) {
            Content content3 = (Content)e2.getSource();
            int index2 = this.myTabbedPaneWrapper.indexOfComponent(content3.getComponent());
            if (index2 != -1) {
                this.myTabbedPaneWrapper.setTitleAt(index2, content3.getTabName());
            }
        } else if ("description".equals(e2.getPropertyName())) {
            Content content4 = (Content)e2.getSource();
            int index3 = this.myTabbedPaneWrapper.indexOfComponent(content4.getComponent());
            if (index3 != -1) {
                this.myTabbedPaneWrapper.setToolTipTextAt(index3, content4.getDescription());
            }
        } else if ("component".equals(e2.getPropertyName())) {
            Content content5 = (Content)e2.getSource();
            JComponent oldComponent = (JComponent)e2.getOldValue();
            int index4 = this.myTabbedPaneWrapper.indexOfComponent(oldComponent);
            if (index4 != -1) {
                boolean hasFocus = IJSwingUtilities.hasFocus2(oldComponent);
                this.myTabbedPaneWrapper.setComponentAt(index4, content5.getComponent());
                if (hasFocus) {
                    content5.getComponent().requestDefaultFocus();
                }
            }
        } else if ("icon".equals(e2.getPropertyName()) && (index = this.myTabbedPaneWrapper.indexOfComponent((content2 = (Content)e2.getSource()).getComponent())) != -1) {
            this.myTabbedPaneWrapper.setIconAt(index, (Icon)e2.getNewValue());
        }
    }

    private Content getSelectedContent() {
        JComponent selectedComponent = this.myTabbedPaneWrapper.getSelectedComponent();
        return this.myManager.getContent(selectedComponent);
    }

    public boolean isSingleSelection() {
        return true;
    }

    public boolean isToSelectAddedContent() {
        return false;
    }

    public boolean canBeEmptySelection() {
        return false;
    }

    public void beforeDispose() {
    }

    public boolean canChangeSelectionTo(@NotNull Content content2, boolean implicit) {
        if (content2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/ui/content/TabbedPaneContentUI", "canChangeSelectionTo"));
        }
        return true;
    }

    @NotNull
    public String getCloseActionName() {
        String string2 = UIBundle.message((String)"tabbed.pane.close.tab.action.name", (Object[])new Object[0]);
        if (string2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/content/TabbedPaneContentUI", "getCloseActionName"));
        }
        return string2;
    }

    @NotNull
    public String getCloseAllButThisActionName() {
        String string2 = UIBundle.message((String)"tabbed.pane.close.all.tabs.but.this.action.name", (Object[])new Object[0]);
        if (string2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/content/TabbedPaneContentUI", "getCloseAllButThisActionName"));
        }
        return string2;
    }

    @NotNull
    public String getPreviousContentActionName() {
        if ("Select Previous Tab" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/content/TabbedPaneContentUI", "getPreviousContentActionName"));
        }
        return "Select Previous Tab";
    }

    @NotNull
    public String getNextContentActionName() {
        if ("Select Next Tab" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/content/TabbedPaneContentUI", "getNextContentActionName"));
        }
        return "Select Next Tab";
    }

    public void dispose() {
    }

    private class MyContentManagerListener
    extends ContentManagerAdapter {
        private MyContentManagerListener() {
        }

        public void contentAdded(ContentManagerEvent event) {
            Content content2 = event.getContent();
            TabbedPaneContentUI.this.myTabbedPaneWrapper.insertTab(content2.getTabName(), content2.getIcon(), content2.getComponent(), content2.getDescription(), event.getIndex());
            content2.addPropertyChangeListener((PropertyChangeListener)TabbedPaneContentUI.this);
        }

        public void contentRemoved(ContentManagerEvent event) {
            event.getContent().removePropertyChangeListener((PropertyChangeListener)TabbedPaneContentUI.this);
            TabbedPaneContentUI.this.myTabbedPaneWrapper.removeTabAt(event.getIndex());
        }

        public void selectionChanged(ContentManagerEvent event) {
            int index = event.getIndex();
            if (index != -1 && event.getOperation() != ContentManagerEvent.ContentOperation.remove) {
                TabbedPaneContentUI.this.myTabbedPaneWrapper.setSelectedIndex(index);
            }
        }
    }

    private class MyTabbedPaneWrapper
    extends TabbedPaneWrapper.AsJTabbedPane {
        public MyTabbedPaneWrapper(int tabPlacement) {
            super(tabPlacement);
        }

        @Override
        protected TabbedPane createTabbedPane(int tabPlacement) {
            return new MyTabbedPane(tabPlacement);
        }

        @Override
        protected TabbedPaneWrapper.TabbedPaneHolder createTabbedPaneHolder() {
            return new MyTabbedPaneHolder(this);
        }

        private class MyTabbedPaneHolder
        extends TabbedPaneWrapper.TabbedPaneHolder
        implements DataProvider {
            private MyTabbedPaneHolder(TabbedPaneWrapper wrapper) {
                super(wrapper);
            }

            public Object getData(String dataId) {
                if (PlatformDataKeys.CONTENT_MANAGER.is(dataId)) {
                    return TabbedPaneContentUI.this.myManager;
                }
                if (PlatformDataKeys.NONEMPTY_CONTENT_MANAGER.is(dataId) && TabbedPaneContentUI.this.myManager.getContentCount() > 1) {
                    return TabbedPaneContentUI.this.myManager;
                }
                return null;
            }
        }

        private class MyTabbedPane
        extends TabbedPaneImpl {
            public MyTabbedPane(int tabPlacement) {
                super(tabPlacement);
                this.addMouseListener((MouseListener)((Object)new MyPopupHandler()));
                this.enableEvents(16L);
            }

            private void closeTabAt(int x2, int y2) {
                TabbedPaneUI ui = this.getUI();
                int index = ui.tabForCoordinate((JTabbedPane)((Object)this), x2, y2);
                if (index < 0 || !TabbedPaneContentUI.this.myManager.canCloseContents()) {
                    return;
                }
                Content content2 = TabbedPaneContentUI.this.myManager.getContent(index);
                if (content2 != null && content2.isCloseable()) {
                    TabbedPaneContentUI.this.myManager.removeContent(content2, true);
                }
            }

            private void hideMenu() {
                MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
                menuSelectionManager.clearSelectedPath();
            }

            protected void processMouseEvent(MouseEvent e2) {
                if (e2.isPopupTrigger()) {
                    this.showPopup(e2.getX(), e2.getY());
                    return;
                }
                if (!e2.isShiftDown() && (0x10 & e2.getModifiers()) > 0) {
                    if (502 == e2.getID()) {
                        TabbedPaneUI ui = this.getUI();
                        int index = ui.tabForCoordinate((JTabbedPane)((Object)this), e2.getX(), e2.getY());
                        if (index != -1) {
                            this.setSelectedIndex(index);
                        }
                        this.hideMenu();
                    }
                } else if (e2.isShiftDown() && (0x10 & e2.getModifiers()) > 0) {
                    if (502 == e2.getID()) {
                        this.closeTabAt(e2.getX(), e2.getY());
                        this.hideMenu();
                    }
                } else if ((8 & e2.getModifiers()) > 0) {
                    if (502 == e2.getID()) {
                        this.closeTabAt(e2.getX(), e2.getY());
                        this.hideMenu();
                    }
                } else if ((4 & e2.getModifiers()) <= 0 || !SystemInfo.isWindows) {
                    super.processMouseEvent(e2);
                }
            }

            protected ChangeListener createChangeListener() {
                return new MyModelListener();
            }

            private Content getContentAt(int x2, int y2) {
                TabbedPaneUI ui = this.getUI();
                int index = ui.tabForCoordinate((JTabbedPane)((Object)this), x2, y2);
                if (index < 0) {
                    return null;
                }
                return TabbedPaneContentUI.this.myManager.getContent(index);
            }

            private void showPopup(int x2, int y2) {
                Content content2 = this.getContentAt(x2, y2);
                if (content2 == null) {
                    return;
                }
                DefaultActionGroup group = new DefaultActionGroup();
                group.add((AnAction)new TabbedContentAction.CloseAction(content2));
                if (TabbedPaneContentUI.this.myTabbedPaneWrapper.getTabCount() > 1) {
                    group.add((AnAction)new TabbedContentAction.CloseAllAction(TabbedPaneContentUI.this.myManager));
                    group.add((AnAction)new TabbedContentAction.CloseAllButThisAction(content2));
                }
                group.addSeparator();
                group.add(PinToolwindowTabAction.getPinAction());
                group.addSeparator();
                group.add((AnAction)new TabbedContentAction.MyNextTabAction(TabbedPaneContentUI.this.myManager));
                group.add((AnAction)new TabbedContentAction.MyPreviousTabAction(TabbedPaneContentUI.this.myManager));
                List additionalActions = TabbedPaneContentUI.this.myManager.getAdditionalPopupActions(content2);
                if (additionalActions != null) {
                    group.addSeparator();
                    for (AnAction anAction : additionalActions) {
                        group.add(anAction);
                    }
                }
                ActionPopupMenu menu = ActionManager.getInstance().createActionPopupMenu(TabbedPaneContentUI.POPUP_PLACE, (ActionGroup)group);
                menu.getComponent().show(TabbedPaneContentUI.this.myTabbedPaneWrapper.getComponent(), x2, y2);
            }

            protected class MyPopupHandler
            extends PopupHandler {
                protected MyPopupHandler() {
                }

                public void invokePopup(Component comp, int x2, int y2) {
                    if (TabbedPaneContentUI.this.myManager.getContentCount() == 0) {
                        return;
                    }
                    MyTabbedPane.this.showPopup(x2, y2);
                }
            }

            private class MyModelListener
            extends JTabbedPane.ModelListener {
                private MyModelListener() {
                    super((JTabbedPane)((Object)MyTabbedPane.this));
                }

                @Override
                public void stateChanged(ChangeEvent e2) {
                    Content content2 = TabbedPaneContentUI.this.getSelectedContent();
                    if (content2 != null) {
                        TabbedPaneContentUI.this.myManager.setSelectedContent(content2);
                    }
                    super.stateChanged(e2);
                }
            }
        }
    }
}

