/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.content.impl;

import com.intellij.ide.DataManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.ActiveRunnable;
import com.intellij.openapi.util.BusyObject;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.wm.FocusCommand;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.ex.IdeFocusTraversalPolicy;
import com.intellij.ui.components.panels.NonOpaquePanel;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentFactory;
import com.intellij.ui.content.ContentManager;
import com.intellij.ui.content.ContentManagerEvent;
import com.intellij.ui.content.ContentManagerListener;
import com.intellij.ui.content.ContentUI;
import com.intellij.ui.content.impl.ContentImpl;
import com.intellij.util.EventDispatcher;
import com.intellij.util.SmartList;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ContentManagerImpl
implements ContentManager,
PropertyChangeListener,
Disposable.Parent {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.ui.content.impl.ContentManagerImpl");
    private ContentUI myUI;
    private final List<Content> myContents;
    private final EventDispatcher<ContentManagerListener> myDispatcher;
    private final List<Content> mySelection;
    private final boolean myCanCloseContents;
    private MyNonOpaquePanel myComponent;
    private final Set<Content> myContentWithChangedComponent;
    private boolean myDisposed;
    private final Project myProject;
    private final List<DataProvider> dataProviders;
    private ArrayList<Content> mySelectionHistory;

    public ContentManagerImpl(@NotNull ContentUI contentUI, boolean canCloseContents, @NotNull Project project2) {
        if (contentUI == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contentUI", "com/intellij/ui/content/impl/ContentManagerImpl", "<init>"));
        }
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/ui/content/impl/ContentManagerImpl", "<init>"));
        }
        this.myContents = new ArrayList<Content>();
        this.myDispatcher = EventDispatcher.create(ContentManagerListener.class);
        this.mySelection = new ArrayList<Content>();
        this.myContentWithChangedComponent = new HashSet<Content>();
        this.dataProviders = new SmartList();
        this.mySelectionHistory = new ArrayList();
        this.myProject = project2;
        this.myCanCloseContents = canCloseContents;
        this.myUI = contentUI;
        this.myUI.setManager((ContentManager)this);
        Disposer.register((Disposable)project2, (Disposable)this);
        Disposer.register((Disposable)this, (Disposable)contentUI);
    }

    public boolean canCloseContents() {
        return this.myCanCloseContents;
    }

    @NotNull
    public JComponent getComponent() {
        if (this.myComponent == null) {
            this.myComponent = new MyNonOpaquePanel();
            NonOpaquePanel contentComponent = new NonOpaquePanel();
            contentComponent.setContent(this.myUI.getComponent());
            contentComponent.setFocusCycleRoot(true);
            this.myComponent.add((Component)contentComponent, "Center");
        }
        MyNonOpaquePanel myNonOpaquePanel = this.myComponent;
        if (myNonOpaquePanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/content/impl/ContentManagerImpl", "getComponent"));
        }
        return myNonOpaquePanel;
    }

    @NotNull
    public ActionCallback getReady(@NotNull Object requestor) {
        if (requestor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "requestor", "com/intellij/ui/content/impl/ContentManagerImpl", "getReady"));
        }
        Content selected = this.getSelectedContent();
        if (selected == null) {
            ActionCallback actionCallback = ActionCallback.DONE;
            if (actionCallback == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/content/impl/ContentManagerImpl", "getReady"));
            }
            return actionCallback;
        }
        BusyObject busyObject = selected.getBusyObject();
        ActionCallback actionCallback = busyObject != null ? busyObject.getReady(requestor) : ActionCallback.DONE;
        if (actionCallback == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/content/impl/ContentManagerImpl", "getReady"));
        }
        return actionCallback;
    }

    public void addContent(@NotNull Content content2, int order) {
        if (content2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/ui/content/impl/ContentManagerImpl", "addContent"));
        }
        this.doAddContent(content2, order);
    }

    public void addContent(@NotNull Content content2) {
        if (content2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/ui/content/impl/ContentManagerImpl", "addContent"));
        }
        this.doAddContent(content2, -1);
    }

    public void addContent(@NotNull Content content2, Object constraints) {
        if (content2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/ui/content/impl/ContentManagerImpl", "addContent"));
        }
        this.doAddContent(content2, -1);
    }

    private void doAddContent(@NotNull Content content2, int index) {
        if (content2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/ui/content/impl/ContentManagerImpl", "doAddContent"));
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (this.myContents.contains(content2)) {
            this.myContents.remove(content2);
            this.myContents.add(index == -1 ? this.myContents.size() : index, content2);
            return;
        }
        ((ContentImpl)content2).setManager(this);
        int insertIndex = index == -1 ? this.myContents.size() : index;
        this.myContents.add(insertIndex, content2);
        content2.addPropertyChangeListener((PropertyChangeListener)this);
        this.fireContentAdded(content2, insertIndex);
        if (this.myUI.isToSelectAddedContent() || this.mySelection.isEmpty() && !this.myUI.canBeEmptySelection()) {
            if (this.myUI.isSingleSelection()) {
                this.setSelectedContent(content2);
            } else {
                this.addSelectedContent(content2);
            }
        }
        Disposer.register((Disposable)this, (Disposable)content2);
    }

    public boolean removeContent(@NotNull Content content2, boolean dispose2) {
        if (content2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/ui/content/impl/ContentManagerImpl", "removeContent"));
        }
        return this.removeContent(content2, true, dispose2).isDone();
    }

    @NotNull
    public ActionCallback removeContent(@NotNull Content content2, boolean dispose2, boolean trackFocus, boolean forcedFocus) {
        if (content2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/ui/content/impl/ContentManagerImpl", "removeContent"));
        }
        ActionCallback result2 = new ActionCallback();
        this.removeContent(content2, true, dispose2).doWhenDone(() -> {
            if (trackFocus) {
                Content current = this.getSelectedContent();
                if (current != null) {
                    this.setSelectedContent(current, true, true, !forcedFocus);
                } else {
                    result2.setDone();
                }
            } else {
                result2.setDone();
            }
        });
        ActionCallback actionCallback = result2;
        if (actionCallback == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/content/impl/ContentManagerImpl", "removeContent"));
        }
        return actionCallback;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    private ActionCallback removeContent(@NotNull Content content2, boolean trackSelection, boolean dispose2) {
        int newSize;
        int indexToSelect;
        int indexToBeRemoved;
        block28: {
            int selectedIndex;
            block27: {
                if (content2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/ui/content/impl/ContentManagerImpl", "removeContent"));
                }
                ApplicationManager.getApplication().assertIsDispatchThread();
                indexToBeRemoved = this.getIndexOfContent(content2);
                if (indexToBeRemoved == -1) {
                    ActionCallback actionCallback = ActionCallback.REJECTED;
                    if (actionCallback == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/content/impl/ContentManagerImpl", "removeContent"));
                    }
                    return actionCallback;
                }
                Content selection = this.mySelection.isEmpty() ? null : this.mySelection.get(this.mySelection.size() - 1);
                int n2 = selectedIndex = selection != null ? this.myContents.indexOf(selection) : -1;
                if (!this.fireContentRemoveQuery(content2, indexToBeRemoved, ContentManagerEvent.ContentOperation.undefined)) {
                    ActionCallback actionCallback = ActionCallback.REJECTED;
                    ActionCallback actionCallback2 = actionCallback;
                    if (actionCallback2 == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/content/impl/ContentManagerImpl", "removeContent"));
                    }
                    return actionCallback2;
                }
                if (!content2.isValid()) {
                    ActionCallback actionCallback = ActionCallback.REJECTED;
                    ActionCallback actionCallback3 = actionCallback;
                    if (actionCallback3 == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/content/impl/ContentManagerImpl", "removeContent"));
                    }
                    return actionCallback3;
                }
                boolean wasSelected = this.isSelected(content2);
                if (wasSelected) {
                    this.removeFromSelection(content2);
                }
                indexToSelect = -1;
                if (!wasSelected) break block27;
                int i2 = indexToBeRemoved - 1;
                if (i2 >= 0) {
                    indexToSelect = i2;
                    break block28;
                } else if (this.getContentCount() > 1) {
                    indexToSelect = 0;
                }
                break block28;
            }
            if (selectedIndex > indexToBeRemoved) {
                indexToSelect = selectedIndex - 1;
            }
        }
        this.mySelectionHistory.remove(content2);
        this.myContents.remove(content2);
        content2.removePropertyChangeListener((PropertyChangeListener)this);
        this.fireContentRemoved(content2, indexToBeRemoved);
        ((ContentImpl)content2).setManager(null);
        if (dispose2) {
            Disposer.dispose((Disposable)content2);
        }
        if ((newSize = this.myContents.size()) > 0 && trackSelection) {
            ActionCallback result2 = new ActionCallback();
            if (indexToSelect > -1) {
                Content toSelect;
                Content content3 = toSelect = this.mySelectionHistory.size() > 0 ? this.mySelectionHistory.get(0) : this.myContents.get(indexToSelect);
                if (!this.isSelected(toSelect)) {
                    if (this.myUI.isSingleSelection()) {
                        this.setSelectedContentCB(toSelect).notify(result2);
                    } else {
                        this.addSelectedContent(toSelect);
                        result2.setDone();
                    }
                }
            }
            ActionCallback actionCallback = result2;
            ActionCallback actionCallback4 = actionCallback;
            if (actionCallback4 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/content/impl/ContentManagerImpl", "removeContent"));
            }
            return actionCallback4;
        }
        this.mySelection.clear();
        ActionCallback actionCallback = ActionCallback.DONE;
        ActionCallback actionCallback5 = actionCallback;
        if (actionCallback5 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/content/impl/ContentManagerImpl", "removeContent"));
        }
        return actionCallback5;
        finally {
            if (ApplicationManager.getApplication().isDispatchThread() && !this.myDisposed) {
                this.myUI.getComponent().updateUI();
            }
        }
    }

    public void removeAllContents(boolean dispose2) {
        Content[] contents;
        for (Content content2 : contents = this.getContents()) {
            this.removeContent(content2, dispose2);
        }
    }

    public int getContentCount() {
        return this.myContents.size();
    }

    @NotNull
    public Content[] getContents() {
        Content[] contentArray = this.myContents.toArray(new Content[this.myContents.size()]);
        if (contentArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/content/impl/ContentManagerImpl", "getContents"));
        }
        return contentArray;
    }

    public Content findContent(String displayName) {
        for (Content content2 : this.myContents) {
            if (!content2.getDisplayName().equals(displayName)) continue;
            return content2;
        }
        return null;
    }

    public Content getContent(int index) {
        return index >= 0 && index < this.myContents.size() ? this.myContents.get(index) : null;
    }

    public Content getContent(JComponent component) {
        Content[] contents;
        for (Content content2 : contents = this.getContents()) {
            if (!Comparing.equal((Object)component, (Object)content2.getComponent())) continue;
            return content2;
        }
        return null;
    }

    public int getIndexOfContent(Content content2) {
        return this.myContents.indexOf(content2);
    }

    @NotNull
    public String getCloseActionName() {
        String string2 = this.myUI.getCloseActionName();
        if (string2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/content/impl/ContentManagerImpl", "getCloseActionName"));
        }
        return string2;
    }

    @NotNull
    public String getCloseAllButThisActionName() {
        String string2 = this.myUI.getCloseAllButThisActionName();
        if (string2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/content/impl/ContentManagerImpl", "getCloseAllButThisActionName"));
        }
        return string2;
    }

    @NotNull
    public String getPreviousContentActionName() {
        String string2 = this.myUI.getPreviousContentActionName();
        if (string2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/content/impl/ContentManagerImpl", "getPreviousContentActionName"));
        }
        return string2;
    }

    @NotNull
    public String getNextContentActionName() {
        String string2 = this.myUI.getNextContentActionName();
        if (string2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/content/impl/ContentManagerImpl", "getNextContentActionName"));
        }
        return string2;
    }

    public List<AnAction> getAdditionalPopupActions(@NotNull Content content2) {
        if (content2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/ui/content/impl/ContentManagerImpl", "getAdditionalPopupActions"));
        }
        return null;
    }

    public boolean canCloseAllContents() {
        if (!this.canCloseContents()) {
            return false;
        }
        for (Content content2 : this.myContents) {
            if (!content2.isCloseable()) continue;
            return true;
        }
        return false;
    }

    public void addSelectedContent(@NotNull Content content2) {
        if (content2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/ui/content/impl/ContentManagerImpl", "addSelectedContent"));
        }
        if (!this.checkSelectionChangeShouldBeProcessed(content2, false)) {
            return;
        }
        if (this.getIndexOfContent(content2) == -1) {
            throw new IllegalArgumentException("content not found: " + content2);
        }
        if (!this.isSelected(content2)) {
            this.mySelection.add(content2);
            this.fireSelectionChanged(content2, ContentManagerEvent.ContentOperation.add);
        }
    }

    private boolean checkSelectionChangeShouldBeProcessed(Content content2, boolean implicit) {
        if (!this.myUI.canChangeSelectionTo(content2, implicit)) {
            return false;
        }
        boolean result2 = !this.isSelected(content2) || this.myContentWithChangedComponent.contains(content2);
        this.myContentWithChangedComponent.remove(content2);
        return result2;
    }

    public void removeFromSelection(@NotNull Content content2) {
        if (content2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/ui/content/impl/ContentManagerImpl", "removeFromSelection"));
        }
        if (!this.isSelected(content2)) {
            return;
        }
        this.mySelection.remove(content2);
        this.fireSelectionChanged(content2, ContentManagerEvent.ContentOperation.remove);
    }

    public boolean isSelected(@NotNull Content content2) {
        if (content2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/ui/content/impl/ContentManagerImpl", "isSelected"));
        }
        return this.mySelection.contains(content2);
    }

    @NotNull
    public Content[] getSelectedContents() {
        Content[] contentArray = this.mySelection.toArray(new Content[this.mySelection.size()]);
        if (contentArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/content/impl/ContentManagerImpl", "getSelectedContents"));
        }
        return contentArray;
    }

    @Nullable
    public Content getSelectedContent() {
        return this.mySelection.isEmpty() ? null : this.mySelection.get(0);
    }

    public void setSelectedContent(@NotNull Content content2, boolean requestFocus2) {
        if (content2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/ui/content/impl/ContentManagerImpl", "setSelectedContent"));
        }
        this.setSelectedContentCB(content2, requestFocus2);
    }

    @NotNull
    public ActionCallback setSelectedContentCB(@NotNull Content content2, boolean requestFocus2) {
        if (content2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/ui/content/impl/ContentManagerImpl", "setSelectedContentCB"));
        }
        ActionCallback actionCallback = this.setSelectedContentCB(content2, requestFocus2, true);
        if (actionCallback == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/content/impl/ContentManagerImpl", "setSelectedContentCB"));
        }
        return actionCallback;
    }

    public void setSelectedContent(@NotNull Content content2, boolean requestFocus2, boolean forcedFocus) {
        if (content2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/ui/content/impl/ContentManagerImpl", "setSelectedContent"));
        }
        this.setSelectedContentCB(content2, requestFocus2, forcedFocus);
    }

    @NotNull
    public ActionCallback setSelectedContentCB(@NotNull Content content2, boolean requestFocus2, boolean forcedFocus) {
        if (content2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/ui/content/impl/ContentManagerImpl", "setSelectedContentCB"));
        }
        ActionCallback actionCallback = this.setSelectedContent(content2, requestFocus2, forcedFocus, false);
        if (actionCallback == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/content/impl/ContentManagerImpl", "setSelectedContentCB"));
        }
        return actionCallback;
    }

    @NotNull
    public ActionCallback setSelectedContent(final @NotNull Content content2, final boolean requestFocus2, final boolean forcedFocus, boolean implicit) {
        if (content2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/ui/content/impl/ContentManagerImpl", "setSelectedContent"));
        }
        this.mySelectionHistory.remove(content2);
        this.mySelectionHistory.add(0, content2);
        if (this.isSelected(content2) && requestFocus2) {
            ActionCallback actionCallback = this.requestFocus(content2, forcedFocus);
            if (actionCallback == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/content/impl/ContentManagerImpl", "setSelectedContent"));
            }
            return actionCallback;
        }
        if (!this.checkSelectionChangeShouldBeProcessed(content2, implicit)) {
            ActionCallback actionCallback = ActionCallback.REJECTED;
            if (actionCallback == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/content/impl/ContentManagerImpl", "setSelectedContent"));
            }
            return actionCallback;
        }
        if (!this.myContents.contains(content2)) {
            throw new IllegalArgumentException("Cannot find content:" + content2.getDisplayName());
        }
        boolean focused = this.isSelectionHoldsFocus();
        final Content[] old = this.getSelectedContents();
        ActiveRunnable selection = new ActiveRunnable(){

            @NotNull
            public ActionCallback run() {
                if (ContentManagerImpl.this.myDisposed || ContentManagerImpl.this.getIndexOfContent(content2) == -1) {
                    ActionCallback actionCallback = ActionCallback.REJECTED;
                    if (actionCallback == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/content/impl/ContentManagerImpl$1", "run"));
                    }
                    return actionCallback;
                }
                for (Content each : old) {
                    ContentManagerImpl.this.removeFromSelection(each);
                }
                ContentManagerImpl.this.addSelectedContent(content2);
                if (requestFocus2) {
                    ActionCallback actionCallback = ContentManagerImpl.this.requestFocus(content2, forcedFocus);
                    if (actionCallback == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/content/impl/ContentManagerImpl$1", "run"));
                    }
                    return actionCallback;
                }
                ActionCallback actionCallback = ActionCallback.DONE;
                if (actionCallback == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/content/impl/ContentManagerImpl$1", "run"));
                }
                return actionCallback;
            }
        };
        ActionCallback result2 = new ActionCallback();
        boolean enabledFocus = this.getFocusManager().isFocusTransferEnabled();
        if (focused || requestFocus2) {
            if (enabledFocus) {
                ActionCallback actionCallback = this.getFocusManager().requestFocus((Component)((Object)this.myComponent), true).doWhenProcessed(() -> selection.run().notify(result2));
                if (actionCallback == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/content/impl/ContentManagerImpl", "setSelectedContent"));
                }
                return actionCallback;
            }
            ActionCallback actionCallback = selection.run().notify(result2);
            if (actionCallback == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/content/impl/ContentManagerImpl", "setSelectedContent"));
            }
            return actionCallback;
        }
        ActionCallback actionCallback = selection.run().notify(result2);
        if (actionCallback == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/content/impl/ContentManagerImpl", "setSelectedContent"));
        }
        return actionCallback;
    }

    private boolean isSelectionHoldsFocus() {
        Content[] selection;
        boolean focused = false;
        for (Content each : selection = this.getSelectedContents()) {
            if (!UIUtil.isFocusAncestor((JComponent)each.getComponent())) continue;
            focused = true;
            break;
        }
        return focused;
    }

    @NotNull
    public ActionCallback setSelectedContentCB(@NotNull Content content2) {
        if (content2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/ui/content/impl/ContentManagerImpl", "setSelectedContentCB"));
        }
        ActionCallback actionCallback = this.setSelectedContentCB(content2, false);
        if (actionCallback == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/content/impl/ContentManagerImpl", "setSelectedContentCB"));
        }
        return actionCallback;
    }

    public void setSelectedContent(@NotNull Content content2) {
        if (content2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/ui/content/impl/ContentManagerImpl", "setSelectedContent"));
        }
        this.setSelectedContentCB(content2);
    }

    public ActionCallback selectPreviousContent() {
        int contentCount = this.getContentCount();
        LOG.assertTrue(contentCount > 1);
        Content selectedContent = this.getSelectedContent();
        int index = this.getIndexOfContent(selectedContent);
        index = (index - 1 + contentCount) % contentCount;
        Content content2 = this.getContent(index);
        if (content2 == null) {
            return null;
        }
        return this.setSelectedContentCB(content2, true);
    }

    public ActionCallback selectNextContent() {
        int contentCount = this.getContentCount();
        LOG.assertTrue(contentCount > 1);
        Content selectedContent = this.getSelectedContent();
        int index = this.getIndexOfContent(selectedContent);
        index = (index + 1) % contentCount;
        Content content2 = this.getContent(index);
        if (content2 == null) {
            return null;
        }
        return this.setSelectedContentCB(content2, true);
    }

    public void addContentManagerListener(@NotNull ContentManagerListener l2) {
        if (l2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "l", "com/intellij/ui/content/impl/ContentManagerImpl", "addContentManagerListener"));
        }
        this.myDispatcher.getListeners().add(0, l2);
    }

    public void removeContentManagerListener(@NotNull ContentManagerListener l2) {
        if (l2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "l", "com/intellij/ui/content/impl/ContentManagerImpl", "removeContentManagerListener"));
        }
        this.myDispatcher.removeListener((EventListener)l2);
    }

    private void fireContentAdded(@NotNull Content content2, int newIndex) {
        if (content2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/ui/content/impl/ContentManagerImpl", "fireContentAdded"));
        }
        ContentManagerEvent e2 = new ContentManagerEvent((Object)this, content2, newIndex, ContentManagerEvent.ContentOperation.add);
        ((ContentManagerListener)this.myDispatcher.getMulticaster()).contentAdded(e2);
    }

    private void fireContentRemoved(@NotNull Content content2, int oldIndex) {
        if (content2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/ui/content/impl/ContentManagerImpl", "fireContentRemoved"));
        }
        ContentManagerEvent e2 = new ContentManagerEvent((Object)this, content2, oldIndex, ContentManagerEvent.ContentOperation.remove);
        ((ContentManagerListener)this.myDispatcher.getMulticaster()).contentRemoved(e2);
    }

    private void fireSelectionChanged(@NotNull Content content2, ContentManagerEvent.ContentOperation operation) {
        if (content2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/ui/content/impl/ContentManagerImpl", "fireSelectionChanged"));
        }
        ContentManagerEvent e2 = new ContentManagerEvent((Object)this, content2, this.getIndexOfContent(content2), operation);
        ((ContentManagerListener)this.myDispatcher.getMulticaster()).selectionChanged(e2);
    }

    private boolean fireContentRemoveQuery(@NotNull Content content2, int oldIndex, ContentManagerEvent.ContentOperation operation) {
        if (content2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/ui/content/impl/ContentManagerImpl", "fireContentRemoveQuery"));
        }
        ContentManagerEvent event = new ContentManagerEvent((Object)this, content2, oldIndex, operation);
        for (ContentManagerListener listener2 : this.myDispatcher.getListeners()) {
            listener2.contentRemoveQuery(event);
            if (!event.isConsumed()) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public ActionCallback requestFocus(Content content2, boolean forced) {
        Content toSelect;
        Content content3 = toSelect = content2 == null ? this.getSelectedContent() : content2;
        if (toSelect == null) {
            ActionCallback actionCallback = ActionCallback.REJECTED;
            if (actionCallback == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/content/impl/ContentManagerImpl", "requestFocus"));
            }
            return actionCallback;
        }
        assert (this.myContents.contains(toSelect));
        ActionCallback actionCallback = this.getFocusManager().requestFocus(new FocusCommand(content2, toSelect.getPreferredFocusableComponent()){

            @NotNull
            public ActionCallback run() {
                ActionCallback actionCallback = ContentManagerImpl.doRequestFocus(toSelect);
                if (actionCallback == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/content/impl/ContentManagerImpl$2", "run"));
                }
                return actionCallback;
            }
        }, forced);
        if (actionCallback == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/content/impl/ContentManagerImpl", "requestFocus"));
        }
        return actionCallback;
    }

    private IdeFocusManager getFocusManager() {
        return IdeFocusManager.getInstance((Project)this.myProject);
    }

    private static ActionCallback doRequestFocus(Content toSelect) {
        JComponent toFocus = ContentManagerImpl.computeWillFocusComponent(toSelect);
        if (toFocus != null) {
            toFocus.requestFocus();
        }
        return ActionCallback.DONE;
    }

    private static JComponent computeWillFocusComponent(Content toSelect) {
        JComponent toFocus = toSelect.getPreferredFocusableComponent();
        if (toFocus != null) {
            toFocus = IdeFocusTraversalPolicy.getPreferredFocusedComponent(toFocus);
        }
        if (toFocus == null) {
            toFocus = toSelect.getPreferredFocusableComponent();
        }
        return toFocus;
    }

    public void addDataProvider(@NotNull DataProvider provider) {
        if (provider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "provider", "com/intellij/ui/content/impl/ContentManagerImpl", "addDataProvider"));
        }
        this.dataProviders.add(provider);
    }

    @Override
    public void propertyChange(@NotNull PropertyChangeEvent event) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/ui/content/impl/ContentManagerImpl", "propertyChange"));
        }
        if ("component".equals(event.getPropertyName())) {
            this.myContentWithChangedComponent.add((Content)event.getSource());
        }
    }

    @NotNull
    public ContentFactory getFactory() {
        ContentFactory contentFactory = (ContentFactory)ServiceManager.getService(ContentFactory.class);
        if (contentFactory == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/content/impl/ContentManagerImpl", "getFactory"));
        }
        return contentFactory;
    }

    public void beforeTreeDispose() {
        this.myUI.beforeDispose();
    }

    public void dispose() {
        this.myDisposed = true;
        this.myContents.clear();
        this.mySelection.clear();
        this.myContentWithChangedComponent.clear();
        this.myUI = null;
        this.myDispatcher.getListeners().clear();
        this.dataProviders.clear();
    }

    public boolean isDisposed() {
        return this.myDisposed;
    }

    public boolean isSingleSelection() {
        return this.myUI.isSingleSelection();
    }

    private class MyNonOpaquePanel
    extends NonOpaquePanel
    implements DataProvider {
        public MyNonOpaquePanel() {
            super((LayoutManager)new BorderLayout());
        }

        @Nullable
        public Object getData(@NonNls String dataId) {
            if (PlatformDataKeys.CONTENT_MANAGER.is(dataId) || PlatformDataKeys.NONEMPTY_CONTENT_MANAGER.is(dataId) && ContentManagerImpl.this.getContentCount() > 1) {
                return ContentManagerImpl.this;
            }
            for (DataProvider dataProvider : ContentManagerImpl.this.dataProviders) {
                Object data = dataProvider.getData(dataId);
                if (data == null) continue;
                return data;
            }
            if (ContentManagerImpl.this.myUI instanceof DataProvider) {
                return ((DataProvider)ContentManagerImpl.this.myUI).getData(dataId);
            }
            DataProvider provider = DataManager.getDataProvider((JComponent)((Object)this));
            return provider == null ? null : provider.getData(dataId);
        }
    }
}

