/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.content.tabs;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.ui.ShadowAction;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.UIBundle;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import org.jetbrains.annotations.NotNull;

public abstract class TabbedContentAction
extends AnAction
implements DumbAware {
    protected final ContentManager myManager;
    protected final ShadowAction myShadow;

    protected TabbedContentAction(@NotNull ContentManager manager, @NotNull AnAction shortcutTemplate, @NotNull String text2) {
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/ui/content/tabs/TabbedContentAction", "<init>"));
        }
        if (shortcutTemplate == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "shortcutTemplate", "com/intellij/ui/content/tabs/TabbedContentAction", "<init>"));
        }
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/ui/content/tabs/TabbedContentAction", "<init>"));
        }
        super(text2);
        this.myManager = manager;
        this.myShadow = new ShadowAction((AnAction)this, shortcutTemplate, manager.getComponent(), new Presentation(text2));
    }

    protected TabbedContentAction(@NotNull ContentManager manager, @NotNull AnAction template) {
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/ui/content/tabs/TabbedContentAction", "<init>"));
        }
        if (template == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "template", "com/intellij/ui/content/tabs/TabbedContentAction", "<init>"));
        }
        this.myManager = manager;
        this.myShadow = new ShadowAction((AnAction)this, template, manager.getComponent());
    }

    public static class MyPreviousTabAction
    extends TabbedContentAction {
        public MyPreviousTabAction(ContentManager manager) {
            super(manager, ActionManager.getInstance().getAction("PreviousTab"));
        }

        public void actionPerformed(AnActionEvent e2) {
            this.myManager.selectPreviousContent();
        }

        public void update(AnActionEvent e2) {
            e2.getPresentation().setEnabledAndVisible(this.myManager.getContentCount() > 1);
            e2.getPresentation().setText(this.myManager.getPreviousContentActionName());
        }
    }

    public static class MyNextTabAction
    extends TabbedContentAction {
        public MyNextTabAction(ContentManager manager) {
            super(manager, ActionManager.getInstance().getAction("NextTab"));
        }

        public void actionPerformed(AnActionEvent e2) {
            this.myManager.selectNextContent();
        }

        public void update(AnActionEvent e2) {
            e2.getPresentation().setEnabledAndVisible(this.myManager.getContentCount() > 1);
            e2.getPresentation().setText(this.myManager.getNextContentActionName());
        }
    }

    public static class CloseAllAction
    extends TabbedContentAction {
        public CloseAllAction(ContentManager manager) {
            super(manager, ActionManager.getInstance().getAction("CloseAllEditors"), UIBundle.message((String)"tabbed.pane.close.all.action.name", (Object[])new Object[0]));
        }

        public void actionPerformed(AnActionEvent e2) {
            Content[] contents;
            for (Content content2 : contents = this.myManager.getContents()) {
                if (!content2.isCloseable()) continue;
                this.myManager.removeContent(content2, true);
            }
        }

        public void update(AnActionEvent e2) {
            Presentation presentation = e2.getPresentation();
            presentation.setEnabledAndVisible(this.myManager.getContentCount() > 1 && this.myManager.canCloseAllContents());
        }
    }

    public static class CloseAllButThisAction
    extends ForContent {
        public CloseAllButThisAction(@NotNull Content content2) {
            if (content2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/ui/content/tabs/TabbedContentAction$CloseAllButThisAction", "<init>"));
            }
            super(content2, ActionManager.getInstance().getAction("CloseAllEditorsButActive"), UIBundle.message((String)"tabbed.pane.close.all.but.this.action.name", (Object[])new Object[0]));
        }

        public void actionPerformed(AnActionEvent e2) {
            Content[] contents;
            for (Content content2 : contents = this.myManager.getContents()) {
                if (this.myContent == content2 || !content2.isCloseable()) continue;
                this.myManager.removeContent(content2, true);
            }
            this.myManager.setSelectedContent(this.myContent);
        }

        @Override
        public void update(AnActionEvent e2) {
            Presentation presentation = e2.getPresentation();
            presentation.setText(this.myManager.getCloseAllButThisActionName());
            presentation.setEnabledAndVisible(this.myManager.canCloseContents() && this.hasOtherCloseableContents());
        }

        private boolean hasOtherCloseableContents() {
            Content[] contents;
            for (Content content2 : contents = this.myManager.getContents()) {
                if (this.myContent == content2 || !content2.isCloseable()) continue;
                return true;
            }
            return false;
        }
    }

    public static class CloseAction
    extends ForContent {
        public CloseAction(@NotNull Content content2) {
            if (content2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/ui/content/tabs/TabbedContentAction$CloseAction", "<init>"));
            }
            super(content2, ActionManager.getInstance().getAction("CloseActiveTab"));
        }

        public void actionPerformed(AnActionEvent e2) {
            this.myManager.removeContent(this.myContent, true);
        }

        @Override
        public void update(AnActionEvent e2) {
            Presentation presentation = e2.getPresentation();
            presentation.setEnabledAndVisible(this.myManager.canCloseContents() && this.myContent.isCloseable());
            presentation.setText(this.myManager.getCloseActionName());
        }
    }

    public static abstract class ForContent
    extends TabbedContentAction {
        protected final Content myContent;

        public ForContent(@NotNull Content content2, @NotNull AnAction shortcutTemplate, String text2) {
            if (content2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/ui/content/tabs/TabbedContentAction$ForContent", "<init>"));
            }
            if (shortcutTemplate == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "shortcutTemplate", "com/intellij/ui/content/tabs/TabbedContentAction$ForContent", "<init>"));
            }
            super(content2.getManager(), shortcutTemplate, text2);
            this.myContent = content2;
            Disposer.register((Disposable)content2, (Disposable)this.myShadow);
        }

        public ForContent(@NotNull Content content2, AnAction template) {
            if (content2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/ui/content/tabs/TabbedContentAction$ForContent", "<init>"));
            }
            super(content2.getManager(), template);
            this.myContent = content2;
            Disposer.register((Disposable)content2, (Disposable)this.myShadow);
        }

        public void update(AnActionEvent e2) {
            super.update(e2);
            e2.getPresentation().setEnabled(this.myManager.getIndexOfContent(this.myContent) >= 0);
        }
    }
}

