/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.debugger.extensions;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.ex.AnActionListener;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.keymap.KeymapManager;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.debugger.UiDebuggerExtension;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;

public class ActionTracer
implements UiDebuggerExtension,
AnActionListener {
    private final Logger LOG = Logger.getInstance((String)"ActionTracer");
    private JTextArea myText;
    private JPanel myComponent;

    @Override
    public JComponent getComponent() {
        if (this.myComponent == null) {
            this.myText = new JTextArea();
            JBScrollPane log = new JBScrollPane((Component)this.myText);
            AnAction clear2 = new AnAction("Clear", "Clear log", AllIcons.General.Reset){

                public void actionPerformed(AnActionEvent e2) {
                    ActionTracer.this.myText.setText(null);
                }
            };
            this.myComponent = new JPanel(new BorderLayout());
            DefaultActionGroup group = new DefaultActionGroup();
            group.add(clear2);
            this.myComponent.add((Component)ActionManager.getInstance().createActionToolbar("unknown", (ActionGroup)group, true).getComponent(), "North");
            this.myComponent.add((Component)log);
            ActionManager.getInstance().addAnActionListener((AnActionListener)this);
        }
        return this.myComponent;
    }

    @Override
    public String getName() {
        return "Actions";
    }

    public void beforeActionPerformed(AnAction action2, DataContext dataContext, AnActionEvent event) {
    }

    public void afterActionPerformed(AnAction action2, DataContext dataContext, AnActionEvent event) {
        StringBuilder out = new StringBuilder(String.format("%1$tF %1$tT,%1$tL ", System.currentTimeMillis()));
        ActionManager actionManager = ActionManager.getInstance();
        String id = actionManager.getId(action2);
        out.append("id=").append(id);
        if (id != null) {
            out.append("; shortcuts:");
            Shortcut[] shortcuts = KeymapManager.getInstance().getActiveKeymap().getShortcuts(id);
            for (int i2 = 0; i2 < shortcuts.length; ++i2) {
                Shortcut shortcut = shortcuts[i2];
                out.append(shortcut);
                if (i2 >= shortcuts.length - 1) continue;
                out.append(",");
            }
        }
        out.append("; class: ").append(action2.getClass().getName());
        out.append("\n");
        Document doc = this.myText.getDocument();
        try {
            doc.insertString(doc.getLength(), out.toString(), null);
            SwingUtilities.invokeLater(() -> {
                int y2 = (int)this.myText.getBounds().getMaxY();
                this.myText.scrollRectToVisible(new Rectangle(0, y2, this.myText.getBounds().width, 0));
            });
        }
        catch (BadLocationException e2) {
            this.LOG.error((Throwable)e2);
        }
    }

    public void beforeEditorTyping(char c2, DataContext dataContext) {
    }

    @Override
    public void disposeUiResources() {
        ActionManager.getInstance().removeAnActionListener((AnActionListener)this);
        this.myComponent = null;
        this.myText = null;
    }
}

