/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.debugger.extensions;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.ui.Splitter;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SimpleColoredText;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.components.JBList;
import com.intellij.ui.debugger.UiDebuggerExtension;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.KeyboardFocusManager;
import java.awt.Rectangle;
import java.awt.Window;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.DefaultCaret;
import org.jetbrains.annotations.NotNull;

public class FocusDebugger
implements UiDebuggerExtension,
PropertyChangeListener,
ListSelectionListener {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.ui.debugger.extensions.FocusDebugger");
    private JComponent myComponent;
    private JList myLog;
    private DefaultListModel myLogModel;
    private JEditorPane myAllocation;

    @Override
    public JComponent getComponent() {
        if (this.myComponent == null) {
            this.myComponent = this.init();
        }
        return this.myComponent;
    }

    private JComponent init() {
        JPanel result2 = new JPanel(new BorderLayout());
        this.myLogModel = new DefaultListModel();
        this.myLog = new JBList((ListModel)this.myLogModel);
        this.myLog.setCellRenderer(new FocusElementRenderer());
        this.myAllocation = new JEditorPane();
        DefaultCaret caret = new DefaultCaret();
        this.myAllocation.setCaret(caret);
        caret.setUpdatePolicy(1);
        this.myAllocation.setEditable(false);
        Splitter splitter = new Splitter(true);
        splitter.setFirstComponent((JComponent)ScrollPaneFactory.createScrollPane((Component)this.myLog));
        splitter.setSecondComponent((JComponent)ScrollPaneFactory.createScrollPane((Component)this.myAllocation));
        this.myLog.addListSelectionListener(this);
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addPropertyChangeListener(this);
        result2.add((Component)splitter, "Center");
        DefaultActionGroup group = new DefaultActionGroup();
        group.add((AnAction)new ClearAction());
        result2.add((Component)ActionManager.getInstance().createActionToolbar("unknown", (ActionGroup)group, true).getComponent(), "North");
        return result2;
    }

    @Override
    public void valueChanged(ListSelectionEvent e2) {
        if (this.myLog.getSelectedIndex() == -1) {
            this.myAllocation.setText(null);
        } else {
            FocusElement element = (FocusElement)this.myLog.getSelectedValue();
            StringWriter s2 = new StringWriter();
            PrintWriter writer = new PrintWriter(s2);
            element.getAllocation().printStackTrace(writer);
            this.myAllocation.setText(s2.toString());
        }
    }

    private boolean isInsideDebuggerDialog(Component c2) {
        Window debuggerWindow = SwingUtilities.getWindowAncestor(this.myComponent);
        if (!(debuggerWindow instanceof Dialog)) {
            return false;
        }
        return c2 == debuggerWindow || SwingUtilities.getWindowAncestor(c2) == debuggerWindow;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        Object newValue = evt.getNewValue();
        Object oldValue = evt.getOldValue();
        boolean affectsDebugger = false;
        if (newValue instanceof Component && this.isInsideDebuggerDialog((Component)newValue)) {
            affectsDebugger |= true;
        }
        if (oldValue instanceof Component && this.isInsideDebuggerDialog((Component)oldValue)) {
            affectsDebugger |= true;
        }
        SimpleColoredText text2 = new SimpleColoredText();
        text2.append(evt.getPropertyName(), this.maybeGrayOut(new SimpleTextAttributes(16, null), affectsDebugger));
        text2.append(" newValue=", this.maybeGrayOut(SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES, affectsDebugger));
        text2.append(evt.getNewValue() + "", this.maybeGrayOut(SimpleTextAttributes.REGULAR_ATTRIBUTES, affectsDebugger));
        text2.append(" oldValue=" + evt.getOldValue(), this.maybeGrayOut(SimpleTextAttributes.REGULAR_ATTRIBUTES, affectsDebugger));
        this.myLogModel.addElement(new FocusElement(text2, new Throwable()));
        SwingUtilities.invokeLater(() -> {
            if (this.myLog != null && this.myLog.isShowing()) {
                int h2 = this.myLog.getFixedCellHeight();
                this.myLog.scrollRectToVisible(new Rectangle(0, this.myLog.getPreferredSize().height - h2, this.myLog.getWidth(), h2));
                if (this.myLog.getModel().getSize() > 0) {
                    this.myLog.setSelectedIndex(this.myLog.getModel().getSize() - 1);
                }
            }
        });
    }

    private SimpleTextAttributes maybeGrayOut(SimpleTextAttributes attr, boolean greyOut) {
        return greyOut ? attr.derive(attr.getStyle(), Color.gray, attr.getBgColor(), attr.getWaveColor()) : attr;
    }

    @Override
    public String getName() {
        return "Focus";
    }

    @Override
    public void disposeUiResources() {
        this.myComponent = null;
        KeyboardFocusManager.getCurrentKeyboardFocusManager().removePropertyChangeListener(this);
    }

    static class FocusElement {
        private final SimpleColoredText myText;
        private final Throwable myAllocation;

        FocusElement(SimpleColoredText text2, Throwable allocation) {
            this.myText = text2;
            this.myAllocation = allocation;
        }

        public SimpleColoredText getText() {
            return this.myText;
        }

        public Throwable getAllocation() {
            return this.myAllocation;
        }
    }

    static class FocusElementRenderer
    extends ColoredListCellRenderer {
        FocusElementRenderer() {
        }

        protected void customizeCellRenderer(@NotNull JList list2, Object value2, int index, boolean selected, boolean hasFocus) {
            if (list2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/ui/debugger/extensions/FocusDebugger$FocusElementRenderer", "customizeCellRenderer"));
            }
            this.clear();
            FocusElement element = (FocusElement)value2;
            SimpleColoredText text2 = element.getText();
            ArrayList strings = text2.getTexts();
            ArrayList attributes = element.getText().getAttributes();
            for (int i2 = 0; i2 < strings.size(); ++i2) {
                this.append((String)strings.get(i2), (SimpleTextAttributes)attributes.get(i2));
            }
        }
    }

    class ClearAction
    extends AnAction {
        ClearAction() {
            super("Clear", "", AllIcons.Actions.Cross);
        }

        public void actionPerformed(AnActionEvent e2) {
            FocusDebugger.this.myLogModel.clear();
        }
    }
}

