/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.mac;

import com.apple.eawt.event.GestureListener;
import com.apple.eawt.event.GestureUtilities;
import com.apple.eawt.event.PressureEvent;
import com.apple.eawt.event.PressureListener;
import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.MouseShortcut;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.PressureShortcut;
import com.intellij.openapi.actionSystem.ex.ActionManagerEx;
import com.intellij.openapi.actionSystem.impl.PresentationFactory;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.application.TransactionGuardImpl;
import com.intellij.openapi.keymap.Keymap;
import com.intellij.openapi.keymap.KeymapManager;
import com.intellij.openapi.keymap.impl.IdeKeyEventDispatcher;
import com.intellij.openapi.keymap.impl.IdeMouseEventDispatcher;
import com.intellij.openapi.keymap.impl.KeymapManagerImpl;
import java.awt.Component;
import java.util.ArrayList;
import javax.swing.JComponent;

public class MacGestureSupportForEditor {
    private final ArrayList<AnAction> myActions = new ArrayList(1);
    private final PresentationFactory myPresentationFactory = new PresentationFactory();

    public MacGestureSupportForEditor(final JComponent component) {
        GestureUtilities.addGestureListenerTo((JComponent)component, (GestureListener)new PressureListener(){

            public void pressure(PressureEvent e2) {
                if (IdeMouseEventDispatcher.isForceTouchAllowed() && e2.getStage() == 2.0) {
                    ((TransactionGuardImpl)TransactionGuard.getInstance()).performUserActivity(() -> MacGestureSupportForEditor.this.handleMouseShortcut(e2, (MouseShortcut)new PressureShortcut(e2.getStage()), component));
                }
            }
        });
    }

    private void handleMouseShortcut(PressureEvent e2, MouseShortcut shortcut, JComponent component) {
        this.fillActionsList(shortcut, IdeKeyEventDispatcher.isModalContext(component));
        ActionManagerEx actionManager = ActionManagerEx.getInstanceEx();
        if (actionManager != null) {
            AnAction[] actions2;
            for (AnAction action2 : actions2 = this.myActions.toArray(new AnAction[this.myActions.size()])) {
                DataContext dataContext = DataManager.getInstance().getDataContext((Component)component);
                Presentation presentation = this.myPresentationFactory.getPresentation(action2);
                AnActionEvent actionEvent = new AnActionEvent(null, dataContext, "MainMenu", presentation, ActionManager.getInstance(), 0);
                action2.beforeActionPerformedUpdate(actionEvent);
                if (!presentation.isEnabled()) continue;
                actionManager.fireBeforeActionPerformed(action2, dataContext, actionEvent);
                Component context2 = (Component)PlatformDataKeys.CONTEXT_COMPONENT.getData(dataContext);
                if (context2 != null && !context2.isShowing()) continue;
                action2.actionPerformed(actionEvent);
            }
        }
        e2.consume();
        IdeMouseEventDispatcher.forbidForceTouch();
    }

    private void fillActionsList(MouseShortcut mouseShortcut, boolean isModalContext) {
        KeymapManager keymapManager2;
        this.myActions.clear();
        if (KeymapManagerImpl.ourKeymapManagerInitialized && (keymapManager2 = KeymapManager.getInstance()) != null) {
            Keymap keymap = keymapManager2.getActiveKeymap();
            String[] actionIds = keymap.getActionIds(mouseShortcut);
            ActionManager actionManager = ActionManager.getInstance();
            for (String actionId : actionIds) {
                AnAction action2 = actionManager.getAction(actionId);
                if (action2 == null || isModalContext && !action2.isEnabledInModalContext() || this.myActions.contains(action2)) continue;
                this.myActions.add(action2);
            }
        }
    }
}

