/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.mac;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicPopupMenuUI;

public class MacPopupMenuUI
extends BasicPopupMenuUI {
    static Stroke THREE_PIXEL_STROKE = new BasicStroke(3.0f);

    public static ComponentUI createUI(JComponent c2) {
        return new MacPopupMenuUI();
    }

    @Override
    public boolean isPopupTrigger(MouseEvent event) {
        return event.isPopupTrigger();
    }

    @Override
    public void installUI(JComponent c2) {
        super.installUI(c2);
    }

    @Override
    public void paint(Graphics g2, JComponent jcomponent) {
        if (!(g2 instanceof Graphics2D)) {
            super.paint(g2, jcomponent);
            return;
        }
        Graphics2D graphics2d = (Graphics2D)g2.create();
        Rectangle rectangle = this.popupMenu.getBounds();
        MacPopupMenuUI.paintRoundRect(graphics2d, rectangle);
        this.clipEdges(graphics2d, rectangle);
        graphics2d.dispose();
        super.paint(g2, jcomponent);
    }

    private static void paintRoundRect(Graphics2D graphics2d, Rectangle rectangle) {
        graphics2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2d.setComposite(AlphaComposite.Clear);
        graphics2d.setStroke(THREE_PIXEL_STROKE);
        graphics2d.drawRoundRect(-2, -2, rectangle.width + 3, rectangle.height + 3, 12, 12);
    }

    protected void clipEdges(Graphics2D graphics2d, Rectangle rectangle) {
        boolean flag;
        Component component = this.popupMenu.getInvoker();
        if (!(component instanceof JMenu)) {
            return;
        }
        Rectangle rectangle1 = component.getBounds();
        rectangle1.setLocation(component.getLocationOnScreen());
        rectangle.setLocation(this.popupMenu.getLocationOnScreen());
        Point point = new Point((int)rectangle1.getCenterX(), (int)rectangle1.getCenterY());
        if (rectangle.contains(point)) {
            return;
        }
        graphics2d.setComposite(AlphaComposite.SrcOver);
        graphics2d.setColor(this.popupMenu.getBackground());
        Point point1 = new Point((int)rectangle.getCenterX(), (int)rectangle.getCenterY());
        boolean bl = flag = point.y <= point1.y;
        if (rectangle1.x + rectangle1.width < rectangle.x + 10) {
            if (flag) {
                graphics2d.fillRect(-2, -2, 8, 8);
                return;
            }
            graphics2d.fillRect(-2, rectangle.height - 6, 8, 8);
            return;
        }
        if (rectangle.x + rectangle.width < rectangle1.x + 10) {
            if (flag) {
                graphics2d.fillRect(rectangle.width - 6, -2, 8, 8);
                return;
            }
            graphics2d.fillRect(rectangle.width - 6, rectangle.height - 6, 8, 8);
            return;
        }
        if (rectangle1.y + rectangle1.height < rectangle.y + 10) {
            graphics2d.fillRect(-2, -2, rectangle.width + 4, 8);
        }
    }
}

