/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.plaf.beg;

import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonModel;
import javax.swing.JButton;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.border.AbstractBorder;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;
import javax.swing.plaf.BorderUIResource;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicBorders;
import javax.swing.plaf.metal.MetalLookAndFeel;
import javax.swing.text.JTextComponent;

public class BegBorders {
    private static Border ourButtonBorder;
    private static Border ourTextFieldBorder;
    private static Border ourScrollPaneBorder;

    public static Border getButtonBorder() {
        if (ourButtonBorder == null) {
            ourButtonBorder = new BorderUIResource.CompoundBorderUIResource(new ButtonBorder(), new BasicBorders.MarginBorder());
        }
        return ourButtonBorder;
    }

    public static Border getTextFieldBorder() {
        if (ourTextFieldBorder == null) {
            ourTextFieldBorder = new BorderUIResource.CompoundBorderUIResource(new TextFieldBorder(), BorderFactory.createEmptyBorder(2, 2, 2, 2));
        }
        return ourTextFieldBorder;
    }

    public static Border getScrollPaneBorder() {
        if (ourScrollPaneBorder == null) {
            ourScrollPaneBorder = new BorderUIResource.LineBorderUIResource(MetalLookAndFeel.getControlDarkShadow());
        }
        return ourScrollPaneBorder;
    }

    static void drawLineBorder(Graphics g2, int x2, int y2, int w2, int h2) {
        g2.translate(x2, y2);
        g2.setColor(MetalLookAndFeel.getControlDarkShadow());
        g2.drawRect(0, 0, w2 - 1, h2 - 1);
        g2.translate(-x2, -y2);
    }

    static void drawFlush3DBorder(Graphics g2, int x2, int y2, int w2, int h2) {
        g2.translate(x2, y2);
        g2.setColor(MetalLookAndFeel.getControlHighlight());
        g2.drawRect(1, 1, w2 - 2, h2 - 2);
        g2.setColor(MetalLookAndFeel.getControlDarkShadow());
        g2.drawRect(0, 0, w2 - 2, h2 - 2);
        g2.translate(-x2, -y2);
    }

    static void drawDisabledBorder(Graphics g2, int x2, int y2, int w2, int h2) {
        g2.translate(x2, y2);
        g2.setColor(MetalLookAndFeel.getControlShadow());
        g2.drawRect(0, 0, w2 - 1, h2 - 1);
        g2.translate(-x2, -y2);
    }

    static void drawDefaultButtonPressedBorder(Graphics g2, int x2, int y2, int w2, int h2) {
        BegBorders.drawPressed3DBorder(g2, x2 + 1, y2 + 1, w2 - 1, h2 - 1);
        g2.translate(x2, y2);
        g2.setColor(MetalLookAndFeel.getControlDarkShadow());
        g2.drawRect(0, 0, w2 - 3, h2 - 3);
        UIUtil.drawLine((Graphics)g2, (int)(w2 - 2), (int)0, (int)(w2 - 2), (int)0);
        UIUtil.drawLine((Graphics)g2, (int)0, (int)(h2 - 2), (int)0, (int)(h2 - 2));
        g2.translate(-x2, -y2);
    }

    static void drawPressed3DBorder(Graphics g2, int x2, int y2, int w2, int h2) {
        g2.translate(x2, y2);
        BegBorders.drawFlush3DBorder(g2, 0, 0, w2, h2);
        g2.setColor(MetalLookAndFeel.getControlShadow());
        UIUtil.drawLine((Graphics)g2, (int)1, (int)1, (int)1, (int)(h2 - 1));
        UIUtil.drawLine((Graphics)g2, (int)1, (int)1, (int)(w2 - 1), (int)1);
        g2.translate(-x2, -y2);
    }

    static void drawDefaultButtonBorder(Graphics g2, int x2, int y2, int w2, int h2, boolean active2) {
        BegBorders.drawButtonBorder(g2, x2 + 1, y2 + 1, w2 - 1, h2 - 1, active2);
        g2.translate(x2, y2);
        g2.setColor(MetalLookAndFeel.getControlDarkShadow());
        g2.drawRect(0, 0, w2 - 3, h2 - 3);
        UIUtil.drawLine((Graphics)g2, (int)(w2 - 2), (int)0, (int)(w2 - 2), (int)0);
        UIUtil.drawLine((Graphics)g2, (int)0, (int)(h2 - 2), (int)0, (int)(h2 - 2));
        g2.translate(-x2, -y2);
    }

    static void drawButtonBorder(Graphics g2, int x2, int y2, int w2, int h2, boolean active2) {
        if (active2) {
            BegBorders.drawActiveButtonBorder(g2, x2, y2, w2, h2);
        } else {
            BegBorders.drawFlush3DBorder(g2, x2, y2, w2, h2);
        }
    }

    static void drawActiveButtonBorder(Graphics g2, int x2, int y2, int w2, int h2) {
        BegBorders.drawFlush3DBorder(g2, x2, y2, w2, h2);
        g2.setColor(MetalLookAndFeel.getPrimaryControl());
        UIUtil.drawLine((Graphics)g2, (int)(x2 + 1), (int)(y2 + 1), (int)(x2 + 1), (int)(h2 - 3));
        UIUtil.drawLine((Graphics)g2, (int)(x2 + 1), (int)(y2 + 1), (int)(w2 - 3), (int)(x2 + 1));
        g2.setColor(MetalLookAndFeel.getPrimaryControlDarkShadow());
        UIUtil.drawLine((Graphics)g2, (int)(x2 + 2), (int)(h2 - 2), (int)(w2 - 2), (int)(h2 - 2));
        UIUtil.drawLine((Graphics)g2, (int)(w2 - 2), (int)(y2 + 2), (int)(w2 - 2), (int)(h2 - 2));
    }

    public static class TextFieldBorder
    extends LineBorder
    implements UIResource {
        public TextFieldBorder() {
            super(null, 1);
        }

        @Override
        public boolean isBorderOpaque() {
            return false;
        }

        @Override
        public void paintBorder(Component c2, Graphics g2, int x2, int y2, int w2, int h2) {
            if (!(c2 instanceof JTextComponent)) {
                if (c2.isEnabled()) {
                    BegBorders.drawFlush3DBorder(g2, x2, y2, w2, h2);
                } else {
                    BegBorders.drawDisabledBorder(g2, x2, y2, w2, h2);
                }
                return;
            }
            if (c2.isEnabled() && ((JTextComponent)c2).isEditable()) {
                BegBorders.drawLineBorder(g2, x2, y2, w2, h2);
            } else {
                BegBorders.drawDisabledBorder(g2, x2, y2, w2, h2);
            }
        }
    }

    public static class ScrollPaneBorder
    extends AbstractBorder
    implements UIResource {
        private static final Insets insets = new Insets(1, 1, 2, 2);

        @Override
        public void paintBorder(Component c2, Graphics g2, int x2, int y2, int w2, int h2) {
            JScrollPane scroll = (JScrollPane)c2;
            JViewport colHeader = scroll.getColumnHeader();
            int colHeaderHeight = 0;
            if (colHeader != null) {
                colHeaderHeight = colHeader.getHeight();
            }
            JViewport rowHeader = scroll.getRowHeader();
            int rowHeaderWidth = 0;
            if (rowHeader != null) {
                rowHeaderWidth = rowHeader.getWidth();
            }
            BegBorders.drawLineBorder(g2, x2, y2, w2, h2);
        }

        @Override
        public Insets getBorderInsets(Component c2) {
            return (Insets)insets.clone();
        }
    }

    public static class ButtonBorder
    extends AbstractBorder
    implements UIResource {
        @Override
        public void paintBorder(Component c2, Graphics g2, int x2, int y2, int w2, int h2) {
            AbstractButton button = (AbstractButton)c2;
            ButtonModel model2 = button.getModel();
            if (model2.isEnabled()) {
                boolean isDefault;
                boolean isPressed = model2.isPressed() && model2.isArmed();
                boolean bl = isDefault = button instanceof JButton && ((JButton)button).isDefaultButton();
                if (isPressed && isDefault) {
                    BegBorders.drawDefaultButtonPressedBorder(g2, x2, y2, w2, h2);
                } else if (isPressed) {
                    BegBorders.drawPressed3DBorder(g2, x2, y2, w2, h2);
                } else if (isDefault) {
                    BegBorders.drawDefaultButtonBorder(g2, x2, y2, w2, h2, false);
                } else {
                    BegBorders.drawButtonBorder(g2, x2, y2, w2, h2, false);
                }
            } else {
                BegBorders.drawDisabledBorder(g2, x2, y2, w2 - 1, h2 - 1);
            }
        }

        @Override
        public Insets getBorderInsets(Component c2) {
            return JBUI.insets((int)3);
        }

        @Override
        public Insets getBorderInsets(Component c2, Insets newInsets) {
            JBInsets borderInsets = JBUI.insets((int)3);
            newInsets.top = borderInsets.top;
            newInsets.left = borderInsets.left;
            newInsets.bottom = borderInsets.bottom;
            newInsets.right = borderInsets.right;
            return newInsets;
        }
    }

    public static class FlatLineBorder
    extends LineBorder
    implements UIResource {
        public FlatLineBorder() {
            super(new Color(127, 157, 185), 1, true);
        }
    }
}

