/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.plaf.beg;

import com.intellij.ui.Gray;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JTree;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.plaf.ColorUIResource;
import javax.swing.tree.TreeCellRenderer;

public class BegCellRenderer
extends JLabel
implements TreeCellRenderer,
ListCellRenderer {
    protected Icon myLeafIcon;
    protected Color myTextBackground;
    protected boolean mySelected;
    protected Color mySelectionForeground;
    protected Color mySelectionBorderColor;
    protected Icon myOpenIcon;
    protected boolean myHasFocus;
    protected Color myTextForeground;
    protected boolean myDrawsFocusBorderAroundIcon;
    protected Color mySelectionBackground;
    protected Icon myClosedIcon;

    public BegCellRenderer() {
        this.setHorizontalAlignment(2);
    }

    public void setSelectionBorderColor(Color color) {
        this.mySelectionBorderColor = color;
    }

    @Override
    public Component getTreeCellRendererComponent(JTree tree2, Object obj, boolean selected, boolean expanded, boolean leaf, int i1, boolean hasFocus) {
        this.setFont(UIUtil.getLabelFont());
        this.setLeafIcon(UIManager.getIcon("Tree.leafIcon"));
        this.setClosedIcon(UIManager.getIcon("Tree.closedIcon"));
        this.setOpenIcon(UIManager.getIcon("Tree.openIcon"));
        this.setSelectionForeground(UIUtil.getTreeSelectionForeground());
        this.setTextForeground(UIUtil.getTreeTextForeground());
        this.setSelectionBackground(UIUtil.getTreeSelectionBackground());
        this.setTextBackground(UIUtil.getTreeTextBackground());
        this.setSelectionBorderColor(UIUtil.getTreeSelectionBorderColor());
        Object obj1 = UIManager.get("Tree.drawsFocusBorderAroundIcon");
        this.myDrawsFocusBorderAroundIcon = obj1 != null && (Boolean)obj1 != false;
        this.myHasFocus = hasFocus;
        this.mySelected = selected;
        String text2 = tree2.convertValueToText(obj, selected, expanded, leaf, i1, hasFocus);
        this.setText(text2);
        if (selected) {
            if (hasFocus) {
                this.setForeground(this.getSelectionForeground());
            } else {
                this.setForeground(this.getTextForeground());
            }
        } else {
            this.setForeground(this.getTextForeground());
        }
        Icon icon = this.getIcon(tree2, obj, selected, expanded, leaf, i1, hasFocus);
        this.setIcon(icon);
        return this;
    }

    public Component getListCellRendererComponent(JList list2, Object obj, int index, boolean selected, boolean hasFocus) {
        this.setFont(UIUtil.getLabelFont());
        this.setSelectionForeground(UIUtil.getListSelectionForeground());
        this.setTextForeground(UIUtil.getListForeground());
        this.setSelectionBackground(UIManager.getColor("List.selectionBackground"));
        this.setTextBackground(UIUtil.getListBackground());
        this.setSelectionBorderColor(UIUtil.getTreeSelectionBorderColor());
        Object obj1 = UIManager.get("Tree.drawsFocusBorderAroundIcon");
        this.myDrawsFocusBorderAroundIcon = obj1 != null && (Boolean)obj1 != false;
        this.myHasFocus = hasFocus;
        this.mySelected = selected;
        String text2 = String.valueOf(obj);
        this.setText(text2);
        if (hasFocus && selected) {
            this.setForeground(this.getSelectionForeground());
        } else {
            this.setForeground(this.getTextForeground());
        }
        return this;
    }

    public void setSelectionBackground(Color color) {
        this.mySelectionBackground = color;
    }

    public Icon getClosedIcon() {
        return this.myClosedIcon;
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        if (dimension != null) {
            dimension = new Dimension(dimension.width + 3, dimension.height);
        }
        return dimension;
    }

    public Icon getOriginalClosedIcon() {
        return UIManager.getIcon("Tree.closedIcon");
    }

    public Color getSelectionBorderColor() {
        return this.mySelectionBorderColor;
    }

    public Color getSelectionForeground() {
        return this.mySelectionForeground;
    }

    public Color getTextBackground() {
        return this.myTextBackground;
    }

    public void setClosedIcon(Icon icon) {
        this.myClosedIcon = icon;
    }

    public void setTextBackground(Color color) {
        this.myTextBackground = color;
    }

    public void setTextForeground(Color color) {
        this.myTextForeground = color;
    }

    protected Icon getIcon(JTree jtree, Object obj, boolean selected, boolean expanded, boolean leaf, int i1, boolean flag3) {
        Icon icon = leaf ? this.getLeafIcon() : (expanded ? this.getOpenIcon() : this.getClosedIcon());
        return icon;
    }

    public Icon getLeafIcon() {
        return this.myLeafIcon;
    }

    public void setOpenIcon(Icon icon) {
        this.myOpenIcon = icon;
    }

    protected void paintNode(Graphics g2) {
        Color color;
        if (this.mySelected) {
            color = this.myHasFocus ? this.getSelectionBackground() : Gray._223;
        } else {
            color = this.getTextBackground();
            if (color == null) {
                color = this.getBackground();
            }
        }
        if (color != null) {
            int i1 = this.getBorderLeft();
            g2.setColor(color);
            g2.fillRect(i1 - 1, 0, this.getWidth() - i1, this.getHeight());
        }
    }

    @Override
    protected void paintBorder(Graphics g2) {
        if (this.myHasFocus) {
            int i1 = this.getBorderLeft();
            if (this.myDrawsFocusBorderAroundIcon) {
                i1 = 0;
            } else if (i1 == -1) {
                i1 = this.getBorderLeft();
            }
            Color color = this.getSelectionBorderColor();
            if (color != null) {
                g2.setColor(color);
                int j1 = this.getWidth() - 1;
                int k1 = this.getHeight() - 1;
                UIUtil.drawDottedRectangle((Graphics)g2, (int)(i1 > 0 ? i1 - 1 : i1), (int)0, (int)j1, (int)k1);
            }
        }
    }

    @Override
    public void paint(Graphics g2) {
        this.paintNode(g2);
        this.paintBorder(g2);
        super.paint(g2);
    }

    public Icon getOpenIcon() {
        return this.myOpenIcon;
    }

    public void setSelectionForeground(Color color) {
        this.mySelectionForeground = color;
    }

    public Icon getOriginalOpenIcon() {
        return UIManager.getIcon("Tree.openIcon");
    }

    public void setLeafIcon(Icon icon) {
        this.myLeafIcon = icon;
    }

    @Override
    public void setBackground(Color color) {
        if (color instanceof ColorUIResource) {
            color = null;
        }
        super.setBackground(color);
    }

    public Color getSelectionBackground() {
        return this.mySelectionBackground;
    }

    public Icon getOriginalLeafIcon() {
        return UIManager.getIcon("Tree.leafIcon");
    }

    protected int getBorderLeft() {
        Icon icon = this.getIcon();
        if (icon != null && this.getText() != null) {
            return icon.getIconWidth() + Math.max(0, this.getIconTextGap() - 1);
        }
        return 0;
    }

    public Color getTextForeground() {
        return this.myTextForeground;
    }
}

