/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.plaf.beg;

import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.CellRendererPane;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.plaf.metal.MetalComboBoxButton;
import javax.swing.plaf.metal.MetalLookAndFeel;

public class BegComboBoxButton
extends MetalComboBoxButton {
    public BegComboBoxButton(JComboBox cb2, Icon i2, boolean onlyIcon, CellRendererPane pane, JList list2) {
        super(cb2, i2, onlyIcon, pane, list2);
    }

    public BegComboBoxButton(JComboBox cb2, Icon i2, CellRendererPane pane, JList list2) {
        super(cb2, i2, pane, list2);
    }

    @Override
    public void paintComponent(Graphics g2) {
        boolean leftToRight = this.comboBox.getComponentOrientation().isLeftToRight();
        if (this.comboBox.isEditable()) {
            super.paintComponent(g2);
        } else {
            if (this.getModel().isPressed()) {
                Color selectColor = UIUtil.getButtonSelectColor();
                g2.setColor(selectColor);
            } else {
                g2.setColor(this.getBackground());
            }
            Dimension size = this.getSize();
            g2.fillRect(0, 0, size.width, size.height);
        }
        Insets insets = this.getInsets();
        int width = this.getWidth() - (insets.left + insets.right);
        int height = this.getHeight() - (insets.top + insets.bottom);
        if (height <= 0 || width <= 0) {
            return;
        }
        int left = insets.left;
        int top = insets.top;
        int bottom = top + (height - 1);
        int iconWidth = 0;
        if (this.comboIcon != null) {
            int iconTop;
            int iconLeft;
            iconWidth = this.comboIcon.getIconWidth();
            int iconHeight = this.comboIcon.getIconHeight();
            if (this.iconOnly) {
                iconLeft = this.getWidth() / 2 - iconWidth / 2;
                iconTop = this.getHeight() / 2 - iconHeight / 2;
            } else {
                iconLeft = leftToRight ? left + (width - 1) - iconWidth : left;
                iconTop = top + (bottom - top) / 2 - iconHeight / 2;
            }
            this.comboIcon.paintIcon(this, g2, iconLeft, iconTop);
            if (this.comboBox.hasFocus()) {
                g2.setColor(MetalLookAndFeel.getFocusColor());
                UIUtil.drawDottedRectangle((Graphics)g2, (int)(left - 1), (int)(top - 1), (int)(left + width), (int)(top + height));
            }
        }
        if (!this.iconOnly && this.comboBox != null) {
            ListCellRenderer<Object> renderer = this.comboBox.getRenderer();
            boolean renderPressed = this.getModel().isPressed();
            Component c2 = renderer.getListCellRendererComponent(this.listBox, this.comboBox.getSelectedItem(), -1, renderPressed, false);
            c2.setFont(this.rendererPane.getFont());
            if (this.model.isArmed() && this.model.isPressed()) {
                if (this.isOpaque()) {
                    c2.setBackground(UIUtil.getButtonSelectColor());
                }
                c2.setForeground(this.comboBox.getForeground());
            } else if (!this.comboBox.isEnabled()) {
                if (this.isOpaque()) {
                    c2.setBackground(UIUtil.getComboBoxDisabledBackground());
                }
                c2.setForeground(UIUtil.getComboBoxDisabledForeground());
            }
            int cWidth = width - (insets.right + iconWidth);
            if (leftToRight) {
                this.rendererPane.paintComponent(g2, c2, this, left, top, cWidth, height);
            } else {
                this.rendererPane.paintComponent(g2, c2, this, left + iconWidth, top, cWidth, height);
            }
        }
    }
}

