/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.plaf.beg;

import java.awt.event.MouseEvent;
import javax.swing.JList;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.basic.BasicListUI;

public class BegListUI
extends BasicListUI {
    @Override
    protected MouseInputListener createMouseInputListener() {
        return new PatchedInputHandler(this.list);
    }

    @Override
    protected int convertYToRow(int y2) {
        return super.convertYToRow(y2);
    }

    public class PatchedInputHandler
    extends BasicListUI.MouseInputHandler {
        private final JList myList;

        PatchedInputHandler(JList list2) {
            super(BegListUI.this);
            this.myList = list2;
        }

        @Override
        public void mousePressed(MouseEvent e2) {
            int row;
            if (!this.myList.isEnabled()) {
                return;
            }
            if (!this.myList.hasFocus()) {
                this.myList.requestFocus();
            }
            if ((row = BegListUI.this.convertYToRow(e2.getY())) != -1) {
                this.myList.setValueIsAdjusting(true);
                int anchorIndex = this.myList.getAnchorSelectionIndex();
                if (e2.isControlDown()) {
                    if (this.myList.isSelectedIndex(row)) {
                        this.myList.removeSelectionInterval(row, row);
                    } else {
                        this.myList.addSelectionInterval(row, row);
                    }
                } else if (e2.isShiftDown() && anchorIndex != -1) {
                    this.myList.setSelectionInterval(anchorIndex, row);
                } else {
                    this.myList.setSelectionInterval(row, row);
                }
            }
        }

        @Override
        public void mouseReleased(MouseEvent e2) {
            this.myList.setValueIsAdjusting(false);
        }
    }
}

