/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.plaf.beg;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.metal.MetalScrollPaneUI;
import org.jetbrains.annotations.NonNls;

public class BegScrollPaneUI
extends MetalScrollPaneUI {
    @NonNls
    public static final String VERTICAL_SCROLL_BAR_PROPERTY = "verticalScrollBar";
    @NonNls
    public static final String HORIZONTAL_SCROLL_BAR_PROPERTY = "horizontalScrollBar";
    @NonNls
    public static final String BORDER_PROPERTY = "border";

    public static ComponentUI createUI(JComponent x2) {
        return new BegScrollPaneUI();
    }

    private void updateScrollbarsFreeStanding() {
        if (this.scrollpane == null) {
            return;
        }
        Boolean value2 = Boolean.FALSE;
        this.scrollpane.getHorizontalScrollBar().putClientProperty("JScrollBar.isFreeStanding", value2);
        this.scrollpane.getVerticalScrollBar().putClientProperty("JScrollBar.isFreeStanding", value2);
    }

    @Override
    protected PropertyChangeListener createScrollBarSwapListener() {
        return new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e2) {
                String propertyName = e2.getPropertyName();
                if (propertyName.equals(BegScrollPaneUI.VERTICAL_SCROLL_BAR_PROPERTY) || propertyName.equals(BegScrollPaneUI.HORIZONTAL_SCROLL_BAR_PROPERTY)) {
                    ((JScrollBar)e2.getOldValue()).putClientProperty("JScrollBar.isFreeStanding", null);
                    ((JScrollBar)e2.getNewValue()).putClientProperty("JScrollBar.isFreeStanding", Boolean.FALSE);
                } else if (BegScrollPaneUI.BORDER_PROPERTY.equals(propertyName)) {
                    BegScrollPaneUI.this.updateScrollbarsFreeStanding();
                }
            }
        };
    }
}

