/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.plaf.beg;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicTableUI;
import javax.swing.table.TableCellEditor;
import org.jetbrains.annotations.NonNls;

public class BegTableUI
extends BasicTableUI {
    private final KeyAdapter myAdapter = new KeyAdapter(){

        @Override
        public void keyPressed(KeyEvent e2) {
            if (e2.getKeyCode() == 27 && BegTableUI.this.table.isEditing()) {
                e2.consume();
                BegTableUI.this.table.removeEditor();
                if (e2.getSource() != BegTableUI.this.table) {
                    ((JComponent)e2.getSource()).removeKeyListener(this);
                }
            }
        }
    };
    @NonNls
    public static final String START_EDITING_ACTION_KEY = "startEditing";

    public static ComponentUI createUI(JComponent c2) {
        return new BegTableUI();
    }

    @Override
    public void installUI(JComponent c2) {
        super.installUI(c2);
        c2.getActionMap().put(START_EDITING_ACTION_KEY, new StartEditingAction());
        c2.getInputMap(1).put(KeyStroke.getKeyStroke("pressed ESCAPE"), "cancel");
    }

    @Override
    protected KeyListener createKeyListener() {
        return this.myAdapter;
    }

    private class StartEditingAction
    extends AbstractAction {
        private StartEditingAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e2) {
            JTable table2 = (JTable)e2.getSource();
            if (!table2.hasFocus()) {
                TableCellEditor cellEditor = table2.getCellEditor();
                if (cellEditor != null && !cellEditor.stopCellEditing()) {
                    return;
                }
                table2.requestFocus();
                return;
            }
            ListSelectionModel rsm = table2.getSelectionModel();
            int anchorRow = rsm.getAnchorSelectionIndex();
            ListSelectionModel csm = table2.getColumnModel().getSelectionModel();
            int anchorColumn = csm.getAnchorSelectionIndex();
            table2.editCellAt(anchorRow, anchorColumn);
            Component editorComp = table2.getEditorComponent();
            if (editorComp != null) {
                editorComp.addKeyListener(BegTableUI.this.myAdapter);
                editorComp.requestFocus();
            }
        }
    }
}

