/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.plaf.gtk;

import com.intellij.openapi.actionSystem.impl.ActionMenuItem;
import com.intellij.ui.plaf.gtk.GtkPaintingUtil;
import com.intellij.ui.plaf.gtk.IconWrapper;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.Icon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.plaf.basic.BasicMenuItemUI;
import javax.swing.plaf.synth.ColorType;
import javax.swing.plaf.synth.SynthContext;
import javax.swing.plaf.synth.SynthMenuItemUI;

public class GtkMenuItemUI
extends BasicMenuItemUI {
    private static Icon myCachedCheckIcon = null;
    private final SynthMenuItemUI myOriginalUI;
    private JCheckBoxMenuItem myHiddenItem;

    public GtkMenuItemUI(SynthMenuItemUI originalUI) {
        this.myOriginalUI = originalUI;
    }

    @Override
    public void installUI(JComponent c2) {
        super.installUI(c2);
        this.myHiddenItem = new JCheckBoxMenuItem();
        this.myOriginalUI.installUI(this.myHiddenItem);
        this.menuItem.setBorder(this.myHiddenItem.getBorder());
        Icon icon = GtkMenuItemUI.getCheckIconFromContext(this.myOriginalUI, this.myHiddenItem);
        this.checkIcon = this.isCheckBoxItem() ? icon : EmptyIcon.create((Icon)icon);
    }

    @Override
    public void uninstallUI(JComponent c2) {
        super.uninstallUI(c2);
        this.myOriginalUI.uninstallUI(this.myHiddenItem);
        this.myHiddenItem = null;
        GtkMenuItemUI.resetCachedCheckIcon();
    }

    private static Icon getCheckIconFromContext(SynthMenuItemUI ui, JCheckBoxMenuItem item) {
        if (myCachedCheckIcon == null) {
            SynthContext context2 = ui.getContext(item);
            myCachedCheckIcon = context2.getStyle().getIcon(context2, "CheckBoxMenuItem.checkIcon");
        }
        return myCachedCheckIcon;
    }

    private boolean isCheckBoxItem() {
        return this.menuItem instanceof ActionMenuItem && ((ActionMenuItem)((Object)this.menuItem)).isToggleable();
    }

    private static void resetCachedCheckIcon() {
        myCachedCheckIcon = null;
    }

    @Override
    public void update(Graphics g2, JComponent c2) {
        this.myHiddenItem.setSelected(this.menuItem.isSelected());
        if (UIUtil.isMurrineBasedTheme()) {
            this.acceleratorFont = this.menuItem.getFont();
            SynthContext context2 = this.myOriginalUI.getContext(this.menuItem);
            Color fg = context2.getStyle().getColor(context2, ColorType.TEXT_FOREGROUND);
            this.acceleratorForeground = UIUtil.mix((Color)fg, (Color)this.menuItem.getBackground(), (double)(this.menuItem.isSelected() ? 0.4 : 0.2));
            this.disabledForeground = fg;
        }
        if (this.checkIcon != null && !(this.checkIcon instanceof IconWrapper) && !(this.checkIcon instanceof EmptyIcon)) {
            this.checkIcon = new IconWrapper(this.checkIcon, this.myOriginalUI);
        }
        super.update(g2, c2);
    }

    @Override
    protected void paintText(Graphics g2, JMenuItem menuItem, Rectangle textRect, String text2) {
        if (!menuItem.isEnabled() && UIUtil.isMurrineBasedTheme()) {
            GtkPaintingUtil.paintDisabledText(this.myOriginalUI, g2, menuItem, textRect, text2);
        } else {
            super.paintText(g2, menuItem, textRect, text2);
        }
    }
}

