/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.popup;

import com.intellij.ui.popup.HeavyWeightPopupCache;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.HierarchyListener;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;

public class MovablePopup {
    private final HierarchyListener myListener;
    private final Component myOwner;
    private final Component myContent;
    private Rectangle myViewBounds;
    private Container myView;
    private boolean myAlwaysOnTop;
    private boolean myHeavyWeight;
    private boolean myWindowFocusable;
    private boolean myWindowShadow;

    public MovablePopup(@NotNull Component owner, @NotNull Component content2) {
        if (owner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/intellij/ui/popup/MovablePopup", "<init>"));
        }
        if (content2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/ui/popup/MovablePopup", "<init>"));
        }
        this.myListener = event -> this.setVisible(false);
        this.myOwner = owner;
        this.myContent = content2;
        this.myViewBounds = new Rectangle(content2.getPreferredSize());
        this.myHeavyWeight = true;
    }

    public void setAlwaysOnTop(boolean value2) {
        if (this.myAlwaysOnTop != value2) {
            this.myAlwaysOnTop = value2;
            this.disposeAndUpdate(true);
        }
    }

    private static void setAlwaysOnTop(@NotNull Window window, boolean value2) {
        if (window == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "window", "com/intellij/ui/popup/MovablePopup", "setAlwaysOnTop"));
        }
        if (value2 != window.isAlwaysOnTop()) {
            try {
                window.setAlwaysOnTop(value2);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void setHeavyWeight(boolean value2) {
        if (this.myHeavyWeight != value2) {
            this.myHeavyWeight = value2;
            this.disposeAndUpdate(true);
        }
    }

    public void setWindowFocusable(boolean value2) {
        if (this.myWindowFocusable != value2) {
            this.myWindowFocusable = value2;
            this.disposeAndUpdate(true);
        }
    }

    private static void setWindowFocusable(@NotNull Window window, boolean value2) {
        if (window == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "window", "com/intellij/ui/popup/MovablePopup", "setWindowFocusable"));
        }
        if (value2 != window.getFocusableWindowState()) {
            window.setFocusableWindowState(value2);
        }
    }

    public void setWindowShadow(boolean value2) {
        if (this.myWindowShadow != value2) {
            this.myWindowShadow = value2;
            this.disposeAndUpdate(true);
        }
    }

    private static void setWindowShadow(@NotNull Window window, boolean value2) {
        if (window == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "window", "com/intellij/ui/popup/MovablePopup", "setWindowShadow"));
        }
        JRootPane root = MovablePopup.getRootPane(window);
        if (root != null) {
            root.putClientProperty("Window.shadow", value2);
        }
    }

    public void setBounds(@NotNull Rectangle bounds) {
        if (bounds == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bounds", "com/intellij/ui/popup/MovablePopup", "setBounds"));
        }
        this.setBounds(bounds.x, bounds.y, bounds.width, bounds.height);
    }

    public void setBounds(int x2, int y2, int width, int height) {
        if (this.myViewBounds != null) {
            this.myViewBounds.setBounds(x2, y2, width, height);
        } else {
            this.setBounds(new Point(x2, y2), new Dimension(width, height));
        }
    }

    public void setLocation(@NotNull Point location) {
        if (location == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "location", "com/intellij/ui/popup/MovablePopup", "setLocation"));
        }
        this.setLocation(location.x, location.y);
    }

    public void setLocation(int x2, int y2) {
        if (this.myViewBounds != null) {
            this.myViewBounds.setLocation(x2, y2);
        } else {
            this.setBounds(new Point(x2, y2), null);
        }
    }

    public void setSize(@NotNull Dimension size) {
        if (size == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "size", "com/intellij/ui/popup/MovablePopup", "setSize"));
        }
        this.setSize(size.width, size.height);
    }

    public void setSize(int width, int height) {
        if (this.myViewBounds != null) {
            this.myViewBounds.setSize(width, height);
        } else {
            this.setBounds(null, new Dimension(width, height));
        }
    }

    public void setVisible(boolean visible) {
        if (!visible && this.myView != null) {
            this.disposeAndUpdate(false);
        } else if (visible && this.myView == null) {
            JLayeredPane parent;
            Window owner = UIUtil.getWindow((Component)this.myOwner);
            if (owner != null) {
                if (this.myHeavyWeight) {
                    Window view2 = HeavyWeightPopupCache.create(owner);
                    MovablePopup.setAlwaysOnTop(view2, this.myAlwaysOnTop);
                    MovablePopup.setWindowFocusable(view2, this.myWindowFocusable);
                    MovablePopup.setWindowShadow(view2, this.myWindowShadow);
                    this.myView = view2;
                } else if (owner instanceof RootPaneContainer && (parent = ((RootPaneContainer)((Object)owner)).getLayeredPane()) != null) {
                    JPanel view3 = new JPanel(new BorderLayout());
                    view3.setVisible(false);
                    parent.add(view3, JLayeredPane.POPUP_LAYER, 0);
                    this.myView = view3;
                }
            }
            if (this.myView != null) {
                this.myView.add(this.myContent);
                Container container = parent = this.myView instanceof Window ? null : this.myView.getParent();
                if (parent != null) {
                    Point location = this.myViewBounds.getLocation();
                    SwingUtilities.convertPointFromScreen(location, parent);
                    this.myViewBounds.setLocation(location);
                }
                this.myView.setBackground(UIUtil.getLabelBackground());
                this.myView.setBounds(this.myViewBounds);
                this.myView.setVisible(true);
                this.myViewBounds = null;
                this.myOwner.addHierarchyListener(this.myListener);
            }
        }
    }

    public boolean isVisible() {
        return this.myView != null && this.myView.isVisible();
    }

    private void disposeAndUpdate(boolean update2) {
        if (this.myView != null) {
            this.myOwner.removeHierarchyListener(this.myListener);
            boolean visible = this.myView.isVisible();
            this.myView.setVisible(false);
            Container container = this.myContent.getParent();
            if (container != null) {
                container.remove(this.myContent);
            }
            if (this.myView instanceof Window) {
                this.myViewBounds = this.myView.getBounds();
                HeavyWeightPopupCache.dispose((Window)this.myView);
            } else {
                Container parent = this.myView.getParent();
                if (parent == null) {
                    this.myViewBounds = new Rectangle(this.myContent.getPreferredSize());
                } else {
                    this.myViewBounds = new Rectangle(this.myView.getBounds());
                    parent.remove(this.myView);
                    Point point = new Point(this.myViewBounds.x, this.myViewBounds.y);
                    SwingUtilities.convertPointToScreen(point, parent);
                    this.myViewBounds.x = point.x;
                    this.myViewBounds.y = point.y;
                }
            }
            this.myView = null;
            if (update2 && visible) {
                this.setVisible(true);
            }
        }
    }

    private void setBounds(Point location, Dimension size) {
        if (this.myView != null) {
            if (size == null) {
                size = this.myView.getSize();
            }
            if (location == null) {
                location = this.myView.getLocation();
            } else {
                Container parent;
                Container container = parent = this.myView instanceof Window ? null : this.myView.getParent();
                if (parent != null) {
                    SwingUtilities.convertPointFromScreen(location, parent);
                }
            }
            this.myView.setBounds(location.x, location.y, size.width, size.height);
            if (this.myView.isVisible()) {
                this.myView.invalidate();
                this.myView.validate();
                this.myView.repaint();
            }
        }
    }

    private static JRootPane getRootPane(Window window) {
        if (window instanceof RootPaneContainer) {
            RootPaneContainer container = (RootPaneContainer)((Object)window);
            return container.getRootPane();
        }
        return null;
    }
}

