/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.popup;

import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.ui.BalloonImpl;
import com.intellij.ui.BalloonLayout;
import com.intellij.ui.components.panels.NonOpaquePanel;
import com.intellij.ui.popup.FramelessNotificationPopup;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionListener;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;

public class NotificationPopup {
    private Impl myImpl;

    public NotificationPopup(JComponent owner, JComponent content2, Color backgroud) {
        this(owner, content2, backgroud, true);
    }

    public NotificationPopup(JComponent owner, JComponent content2, Color backgroud, boolean useDefaultPreferredSize) {
        this(owner, content2, backgroud, useDefaultPreferredSize, null, false);
    }

    public NotificationPopup(JComponent owner, JComponent content2, Color backgroud, final boolean useDefaultPreferredSize, ActionListener clickHandler, boolean closeOnClick) {
        IdeFrame frame = NotificationPopup.findFrame(owner);
        if (frame == null || !((Window)frame).isShowing() || frame.getBalloonLayout() == null) {
            final FramelessNotificationPopup popup2 = new FramelessNotificationPopup(owner, content2, backgroud, useDefaultPreferredSize, clickHandler);
            this.myImpl = new Impl(){

                @Override
                public void addListener(JBPopupListener listener2) {
                    popup2.getPopup().addListener(listener2);
                }

                @Override
                public void hide() {
                    popup2.getPopup().cancel();
                }
            };
        } else {
            NonOpaquePanel wrapper = new NonOpaquePanel(content2){

                public Dimension getPreferredSize() {
                    Dimension size = super.getPreferredSize();
                    if (useDefaultPreferredSize && (size.width > 400 || size.height > 200)) {
                        size.width = 400;
                        size.height = 200;
                    }
                    return size;
                }
            };
            final Balloon balloon = JBPopupFactory.getInstance().createBalloonBuilder((JComponent)wrapper).setFadeoutTime(5000L).setHideOnClickOutside(false).setHideOnFrameResize(false).setHideOnKeyOutside(false).setCloseButtonEnabled(true).setFillColor(backgroud).setShowCallout(false).setClickHandler(clickHandler, closeOnClick).createBalloon();
            ((BalloonImpl)balloon).traceDispose(true);
            BalloonLayout layout = frame.getBalloonLayout();
            assert (layout != null);
            layout.add(balloon);
            this.myImpl = new Impl(){

                @Override
                public void addListener(JBPopupListener listener2) {
                    balloon.addListener(listener2);
                }

                @Override
                public void hide() {
                    balloon.hide();
                }
            };
        }
    }

    private static IdeFrame findFrame(JComponent owner) {
        Window frame = SwingUtilities.getWindowAncestor(owner);
        if (frame instanceof IdeFrame) {
            return (IdeFrame)frame;
        }
        return null;
    }

    public JBPopup getPopup() {
        return null;
    }

    public void addListener(JBPopupListener listener2) {
    }

    public void hide() {
    }

    static interface Impl {
        public void addListener(JBPopupListener var1);

        public void hide();
    }
}

