/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.popup;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.util.PopupUtil;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.ui.popup.OurHeavyWeightPopup;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.ui.UIUtil;
import com.sun.awt.AWTUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JDialog;
import javax.swing.JRootPane;
import javax.swing.JWindow;
import javax.swing.Popup;
import javax.swing.PopupFactory;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;

public interface PopupComponent {
    public static final Logger LOG = Logger.getInstance((String)"#com.intellij.ui.popup.PopupComponent");

    public void hide(boolean var1);

    public void show();

    public Window getWindow();

    public void setRequestFocus(boolean var1);

    public boolean isPopupWindow(Window var1);

    public static class AwtPopupWrapper
    implements PopupComponent {
        private final Popup myPopup;
        private JBPopup myJBPopup;

        public AwtPopupWrapper(Popup popup2, JBPopup jbPopup) {
            this.myPopup = popup2;
            this.myJBPopup = jbPopup;
            if (SystemInfo.isMac && UIUtil.isUnderAquaLookAndFeel()) {
                Component c2 = (Component)ReflectionUtil.getField(Popup.class, (Object)this.myPopup, Component.class, (String)"component");
                c2.setBackground(UIUtil.getPanelBackground());
            }
        }

        @Override
        public boolean isPopupWindow(Window window) {
            Window wnd = this.getWindow();
            return wnd != null && wnd == window;
        }

        @Override
        public void hide(boolean dispose2) {
            this.myPopup.hide();
            if (!dispose2) {
                return;
            }
            Window window = this.getWindow();
            JRootPane rootPane = window instanceof RootPaneContainer ? ((RootPaneContainer)((Object)window)).getRootPane() : null;
            DialogWrapper.cleanupRootPane((JRootPane)rootPane);
            DialogWrapper.cleanupWindowListeners((Window)window);
        }

        @Override
        public void show() {
            Window wnd = this.getWindow();
            AwtPopupWrapper.fixFlickering(wnd, false);
            this.myPopup.show();
            AwtPopupWrapper.fixFlickering(wnd, true);
            if (wnd instanceof JWindow) {
                ((JWindow)wnd).getRootPane().putClientProperty("JBPopup", this.myJBPopup);
            }
        }

        private static void fixFlickering(Window wnd, boolean opaque) {
            try {
                if (UIUtil.isUnderDarcula() && SystemInfo.isMac && Registry.is((String)"darcula.fix.native.flickering") && wnd != null) {
                    AWTUtilities.setWindowOpaque((Window)wnd, (boolean)opaque);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        @Override
        public Window getWindow() {
            Component c2 = (Component)ReflectionUtil.getField(Popup.class, (Object)this.myPopup, Component.class, (String)"component");
            return c2 instanceof JWindow ? (JWindow)c2 : null;
        }

        @Override
        public void setRequestFocus(boolean requestFocus2) {
        }
    }

    public static class DialogPopupWrapper
    implements PopupComponent {
        private final JDialog myDialog;
        private boolean myRequestFocus = true;

        @Override
        public void setRequestFocus(boolean requestFocus2) {
            this.myRequestFocus = requestFocus2;
        }

        @Override
        public boolean isPopupWindow(Window window) {
            return this.myDialog != null && this.myDialog == window;
        }

        public DialogPopupWrapper(Component owner, Component content2, int x2, int y2, JBPopup jbPopup) {
            if (!owner.isShowing()) {
                throw new IllegalArgumentException("Popup owner must be showing, owner " + owner.getClass());
            }
            Window wnd = UIUtil.getWindow((Component)owner);
            this.myDialog = wnd instanceof Frame ? new JDialog((Frame)wnd) : (wnd instanceof Dialog ? new JDialog((Dialog)wnd) : new JDialog());
            this.myDialog.getContentPane().setLayout(new BorderLayout());
            this.myDialog.getContentPane().add(content2, "Center");
            this.myDialog.getRootPane().putClientProperty("JBPopup", jbPopup);
            this.myDialog.getRootPane().setWindowDecorationStyle(0);
            this.myDialog.setUndecorated(true);
            this.myDialog.setBackground(UIUtil.getPanelBackground());
            this.myDialog.pack();
            this.myDialog.setLocation(x2, y2);
            this.myDialog.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosed(WindowEvent e2) {
                    super.windowClosed(e2);
                }
            });
        }

        @Override
        public Window getWindow() {
            return this.myDialog;
        }

        @Override
        public void hide(boolean dispose2) {
            this.myDialog.setVisible(false);
            if (dispose2) {
                this.myDialog.dispose();
                this.myDialog.getRootPane().putClientProperty("JBPopup", null);
            }
        }

        @Override
        public void show() {
            UIUtil.suppressFocusStealing((Window)this.getWindow());
            if (!this.myRequestFocus) {
                this.myDialog.setFocusableWindowState(false);
            }
            AwtPopupWrapper.fixFlickering(this.myDialog, false);
            this.myDialog.setVisible(true);
            AwtPopupWrapper.fixFlickering(this.myDialog, true);
            SwingUtilities.invokeLater(() -> this.myDialog.setFocusableWindowState(true));
        }
    }

    public static interface Factory {
        public PopupComponent getPopup(Component var1, Component var2, int var3, int var4, JBPopup var5);

        public boolean isNativePopup();

        public static class Dialog
        implements Factory {
            @Override
            public PopupComponent getPopup(Component owner, Component content2, int x2, int y2, JBPopup jbPopup) {
                return new DialogPopupWrapper(owner, content2, x2, y2, jbPopup);
            }

            @Override
            public boolean isNativePopup() {
                return false;
            }
        }

        public static class AwtHeavyweight
        implements Factory {
            @Override
            public PopupComponent getPopup(Component owner, Component content2, int x2, int y2, JBPopup jbPopup) {
                if (OurHeavyWeightPopup.isEnabled()) {
                    return new AwtPopupWrapper(new OurHeavyWeightPopup(owner, content2, x2, y2), jbPopup);
                }
                PopupFactory factory2 = PopupFactory.getSharedInstance();
                int oldType = PopupUtil.getPopupType((PopupFactory)factory2);
                PopupUtil.setPopupType((PopupFactory)factory2, (int)2);
                Popup popup2 = factory2.getPopup(owner, content2, x2, y2);
                if (oldType >= 0) {
                    PopupUtil.setPopupType((PopupFactory)factory2, (int)oldType);
                }
                return new AwtPopupWrapper(popup2, jbPopup);
            }

            @Override
            public boolean isNativePopup() {
                return true;
            }
        }

        public static class AwtDefault
        implements Factory {
            @Override
            public PopupComponent getPopup(Component owner, Component content2, int x2, int y2, JBPopup jbPopup) {
                PopupFactory factory2 = PopupFactory.getSharedInstance();
                Popup popup2 = factory2.getPopup(owner, content2, x2, y2);
                return new AwtPopupWrapper(popup2, jbPopup);
            }

            @Override
            public boolean isNativePopup() {
                return true;
            }
        }
    }
}

