/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.popup;

import com.intellij.ide.IdeEventQueue;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.ui.popup.IdePopupEventDispatcher;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.StackingPopupDispatcher;
import com.intellij.ui.popup.AbstractPopup;
import com.intellij.util.containers.WeakList;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.KeyEventDispatcher;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.AWTEventListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.List;
import java.util.Stack;
import java.util.stream.Stream;
import javax.swing.JComponent;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.Nullable;

public class StackingPopupDispatcherImpl
extends StackingPopupDispatcher
implements AWTEventListener,
KeyEventDispatcher {
    private final Stack<JBPopup> myStack = new Stack();
    private final List<JBPopup> myPersistentPopups = new WeakList();
    private final List<JBPopup> myAllPopups = new WeakList();

    private StackingPopupDispatcherImpl() {
    }

    public void onPopupShown(JBPopup popup2, boolean inStack) {
        if (inStack) {
            this.myStack.push(popup2);
            if (ApplicationManager.getApplication() != null) {
                IdeEventQueue.getInstance().getPopupManager().push((IdePopupEventDispatcher)StackingPopupDispatcherImpl.getInstance());
            }
        } else if (popup2.isPersistent()) {
            this.myPersistentPopups.add(popup2);
        }
        this.myAllPopups.add(popup2);
    }

    public void onPopupHidden(JBPopup popup2) {
        boolean wasInStack = this.myStack.remove(popup2);
        this.myPersistentPopups.remove(popup2);
        if (wasInStack && this.myStack.isEmpty() && ApplicationManager.getApplication() != null) {
            IdeEventQueue.getInstance().getPopupManager().remove((IdePopupEventDispatcher)this);
        }
        this.myAllPopups.remove(popup2);
    }

    public void hidePersistentPopups() {
        List<JBPopup> list2 = this.myPersistentPopups;
        for (JBPopup each : list2) {
            if (!each.isNativePopup()) continue;
            each.setUiVisible(false);
        }
    }

    public void restorePersistentPopups() {
        List<JBPopup> list2 = this.myPersistentPopups;
        for (JBPopup each : list2) {
            if (!each.isNativePopup()) continue;
            each.setUiVisible(true);
        }
    }

    @Override
    public void eventDispatched(AWTEvent event) {
        this.dispatchMouseEvent(event);
    }

    protected boolean dispatchMouseEvent(AWTEvent event) {
        if (event.getID() != 501) {
            return false;
        }
        if (this.myStack.isEmpty()) {
            return false;
        }
        AbstractPopup popup2 = (AbstractPopup)this.findPopup();
        MouseEvent mouseEvent = (MouseEvent)event;
        Point point = (Point)mouseEvent.getPoint().clone();
        SwingUtilities.convertPointToScreen(point, mouseEvent.getComponent());
        while (true) {
            if (popup2 != null && !popup2.isDisposed()) {
                JComponent content2 = popup2.getContent();
                if (!content2.isShowing()) {
                    popup2.cancel();
                    return false;
                }
                Rectangle bounds = new Rectangle(content2.getLocationOnScreen(), content2.getSize());
                if (bounds.contains(point) || !popup2.isCancelOnClickOutside()) {
                    return false;
                }
                if (!popup2.canClose()) {
                    return false;
                }
                if (MenuSelectionManager.defaultManager().getSelectedPath().length > 0) {
                    return false;
                }
                popup2.cancel(mouseEvent);
            }
            if (this.myStack.isEmpty()) {
                return false;
            }
            popup2 = (AbstractPopup)this.myStack.peek();
            if (popup2 != null && !popup2.isDisposed()) continue;
            this.myStack.pop();
        }
    }

    protected JBPopup findPopup() {
        while (!this.myStack.isEmpty()) {
            AbstractPopup each = (AbstractPopup)this.myStack.peek();
            if (each == null || each.isDisposed()) {
                this.myStack.pop();
                continue;
            }
            return each;
        }
        return null;
    }

    @Override
    public boolean dispatchKeyEvent(KeyEvent e2) {
        boolean closeRequest = AbstractPopup.isCloseRequest(e2);
        JBPopup popup2 = closeRequest ? this.findPopup() : this.getFocusedPopup();
        return popup2 != null && popup2.dispatchKeyEvent(e2);
    }

    @Nullable
    public Component getComponent() {
        return this.myStack.isEmpty() ? null : this.myStack.peek().getContent();
    }

    @Nullable
    public Stream<JBPopup> getPopupStream() {
        return this.myStack.stream();
    }

    public boolean dispatch(AWTEvent event) {
        if (event instanceof KeyEvent) {
            return this.dispatchKeyEvent((KeyEvent)event);
        }
        return event instanceof MouseEvent && this.dispatchMouseEvent(event);
    }

    public boolean requestFocus() {
        if (this.myStack.isEmpty()) {
            return false;
        }
        AbstractPopup popup2 = (AbstractPopup)this.myStack.peek();
        return popup2.requestFocus();
    }

    public boolean close() {
        if (!this.closeActivePopup()) {
            return false;
        }
        while (this.closeActivePopup()) {
        }
        return true;
    }

    public void setRestoreFocusSilentely() {
        if (this.myStack.isEmpty()) {
            return;
        }
        for (JBPopup each : this.myAllPopups) {
            if (!(each instanceof AbstractPopup)) continue;
            ((AbstractPopup)each).setOk(true);
        }
    }

    public boolean closeActivePopup() {
        if (this.myStack.isEmpty()) {
            return false;
        }
        AbstractPopup popup2 = (AbstractPopup)this.myStack.pop();
        if (popup2 != null && popup2.isVisible() && popup2.isCancelOnWindowDeactivation()) {
            popup2.cancel();
            return true;
        }
        return false;
    }

    public boolean isPopupFocused() {
        return this.getFocusedPopup() != null;
    }

    private JBPopup getFocusedPopup() {
        for (JBPopup each : this.myAllPopups) {
            if (each == null || !each.isFocused()) continue;
            return each;
        }
        return null;
    }
}

