/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.popup.list;

import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeEventQueue;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.ListPopupStepEx;
import com.intellij.openapi.ui.popup.MultiSelectionListPopupStep;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.statistics.StatisticsInfo;
import com.intellij.psi.statistics.StatisticsManager;
import com.intellij.ui.ScrollingUtil;
import com.intellij.ui.SeparatorWithText;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.JBList;
import com.intellij.ui.popup.ClosableByLeftArrow;
import com.intellij.ui.popup.HintUpdateSupply;
import com.intellij.ui.popup.WizardPopup;
import com.intellij.ui.popup.list.ListPopupModel;
import com.intellij.ui.popup.list.PopupListElementRenderer;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ListPopupImpl
extends WizardPopup
implements ListPopup {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.ui.popup.list.ListPopupImpl");
    private MyList myList;
    private MyMouseMotionListener myMouseMotionListener;
    private MyMouseListener myMouseListener;
    private ListPopupModel myListModel;
    private int myIndexForShowingChild;
    private int myMaxRowCount;
    private boolean myAutoHandleBeforeShow;

    public ListPopupImpl(@NotNull ListPopupStep aStep, int maxRowCount) {
        if (aStep == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aStep", "com/intellij/ui/popup/list/ListPopupImpl", "<init>"));
        }
        super((PopupStep<Object>)aStep);
        this.myIndexForShowingChild = -1;
        this.myMaxRowCount = 20;
        if (maxRowCount != -1) {
            this.myMaxRowCount = maxRowCount;
        }
    }

    public ListPopupImpl(@NotNull ListPopupStep aStep) {
        if (aStep == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aStep", "com/intellij/ui/popup/list/ListPopupImpl", "<init>"));
        }
        this(aStep, -1);
    }

    public ListPopupImpl(WizardPopup aParent, @NotNull ListPopupStep aStep, Object parentValue) {
        if (aStep == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aStep", "com/intellij/ui/popup/list/ListPopupImpl", "<init>"));
        }
        this(aParent, aStep, parentValue, -1);
    }

    public ListPopupImpl(WizardPopup aParent, @NotNull ListPopupStep aStep, Object parentValue, int maxRowCount) {
        if (aStep == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aStep", "com/intellij/ui/popup/list/ListPopupImpl", "<init>"));
        }
        super(aParent, (PopupStep<Object>)aStep);
        this.myIndexForShowingChild = -1;
        this.myMaxRowCount = 20;
        this.setParentValue(parentValue);
        if (maxRowCount != -1) {
            this.myMaxRowCount = maxRowCount;
        }
    }

    public void showUnderneathOfLabel(@NotNull JLabel label) {
        if (label == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "label", "com/intellij/ui/popup/list/ListPopupImpl", "showUnderneathOfLabel"));
        }
        int offset = -UIUtil.getListCellHPadding() - UIUtil.getListViewportPadding().left;
        if (label.getIcon() != null) {
            offset += label.getIcon().getIconWidth() + label.getIconTextGap();
        }
        this.show(new RelativePoint((Component)label, new Point(offset, label.getHeight() + 1)));
    }

    protected ListPopupModel getListModel() {
        return this.myListModel;
    }

    @Override
    protected boolean beforeShow() {
        this.myList.addMouseMotionListener(this.myMouseMotionListener);
        this.myList.addMouseListener(this.myMouseListener);
        this.myList.setVisibleRowCount(Math.min(this.myMaxRowCount, this.myListModel.getSize()));
        boolean shouldShow = super.beforeShow();
        if (this.myAutoHandleBeforeShow) {
            boolean toDispose = this.tryToAutoSelect(true);
            shouldShow &= !toDispose;
        }
        return shouldShow;
    }

    @Override
    public void goBack() {
        this.myList.clearSelection();
        super.goBack();
    }

    @Override
    protected void afterShow() {
        this.tryToAutoSelect(false);
    }

    private boolean tryToAutoSelect(boolean handleFinalChoices) {
        ListPopupStep<Object> listStep = this.getListStep();
        boolean selected = false;
        if (listStep instanceof MultiSelectionListPopupStep) {
            int[] indices = ((MultiSelectionListPopupStep)listStep).getDefaultOptionIndices();
            if (indices.length > 0) {
                ScrollingUtil.ensureIndexIsVisible((JList)((Object)this.myList), (int)indices[0], (int)0);
                this.myList.setSelectedIndices(indices);
                selected = true;
            }
        } else {
            int defaultIndex = listStep.getDefaultOptionIndex();
            if (defaultIndex >= 0 && defaultIndex < this.myList.getModel().getSize()) {
                ScrollingUtil.selectItem((JList)((Object)this.myList), (int)defaultIndex);
                selected = true;
            }
        }
        if (!selected) {
            this.selectFirstSelectableItem();
        }
        if (listStep.isAutoSelectionEnabled()) {
            if (!this.isVisible() && this.getSelectableCount() == 1) {
                return this._handleSelect(handleFinalChoices, null);
            }
            if (this.isVisible() && this.hasSingleSelectableItemWithSubmenu()) {
                return this._handleSelect(handleFinalChoices, null);
            }
        }
        return false;
    }

    protected boolean shouldUseStatistics() {
        return true;
    }

    private boolean autoSelectUsingStatistics() {
        String filter2 = this.getSpeedSearch().getFilter();
        if (!StringUtil.isEmpty((String)filter2)) {
            int maxUseCount = -1;
            int mostUsedValue = -1;
            int elementsCount = this.myListModel.getSize();
            for (int i2 = 0; i2 < elementsCount; ++i2) {
                Object value2 = this.myListModel.getElementAt(i2);
                String text2 = this.getListStep().getTextFor(value2);
                int count = StatisticsManager.getInstance().getUseCount(new StatisticsInfo("#list_popup:" + this.myStep.getTitle() + "#" + filter2, text2));
                if (count <= maxUseCount) continue;
                maxUseCount = count;
                mostUsedValue = i2;
            }
            if (mostUsedValue > 0) {
                ScrollingUtil.selectItem((JList)((Object)this.myList), (int)mostUsedValue);
                return true;
            }
        }
        return false;
    }

    private void selectFirstSelectableItem() {
        for (int i2 = 0; i2 < this.myListModel.getSize(); ++i2) {
            if (!this.getListStep().isSelectable(this.myListModel.getElementAt(i2))) continue;
            this.myList.setSelectedIndex(i2);
            break;
        }
    }

    private boolean hasSingleSelectableItemWithSubmenu() {
        boolean oneSubmenuFound = false;
        int countSelectables = 0;
        for (int i2 = 0; i2 < this.myListModel.getSize(); ++i2) {
            Object elementAt = this.myListModel.getElementAt(i2);
            if (!this.getListStep().isSelectable(elementAt)) continue;
            ++countSelectables;
            if (!this.getStep().hasSubstep(elementAt)) continue;
            if (oneSubmenuFound) {
                return false;
            }
            oneSubmenuFound = true;
        }
        return oneSubmenuFound && countSelectables == 1;
    }

    private int getSelectableCount() {
        int count = 0;
        for (int i2 = 0; i2 < this.myListModel.getSize(); ++i2) {
            Object each = this.myListModel.getElementAt(i2);
            if (!this.getListStep().isSelectable(each)) continue;
            ++count;
        }
        return count;
    }

    public JList getList() {
        return this.myList;
    }

    @Override
    protected JComponent createContent() {
        this.myMouseMotionListener = new MyMouseMotionListener();
        this.myMouseListener = new MyMouseListener();
        ListPopupStep<Object> step = this.getListStep();
        this.myListModel = new ListPopupModel(this, this.getSpeedSearch(), step);
        this.myList = new MyList();
        if (this.myStep.getTitle() != null) {
            this.myList.getAccessibleContext().setAccessibleName(this.myStep.getTitle());
        }
        if (step instanceof ListPopupStepEx) {
            ((ListPopupStepEx)step).setEmptyText(this.myList.getEmptyText());
        }
        this.myList.setSelectionMode(this.isMultiSelectionEnabled() ? 2 : 0);
        this.myList.setSelectedIndex(0);
        Insets padding = UIUtil.getListViewportPadding();
        this.myList.setBorder(new EmptyBorder(padding));
        ScrollingUtil.installActions((JList)((Object)this.myList));
        this.myList.setCellRenderer(this.getListElementRenderer());
        this.myList.getActionMap().get("selectNextColumn").setEnabled(false);
        this.myList.getActionMap().get("selectPreviousColumn").setEnabled(false);
        this.registerAction("handleSelection1", 10, 0, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                ListPopupImpl.this.handleSelect(true);
            }
        });
        this.registerAction("handleSelection2", 39, 0, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                ListPopupImpl.this.handleSelect(false);
            }
        });
        this.registerAction("goBack2", 37, 0, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                if (ListPopupImpl.this.isClosableByLeftArrow()) {
                    ListPopupImpl.this.goBack();
                }
            }
        });
        this.myList.setCursor(Cursor.getPredefinedCursor(12));
        return this.myList;
    }

    private boolean isMultiSelectionEnabled() {
        return this.getListStep() instanceof MultiSelectionListPopupStep;
    }

    private boolean isClosableByLeftArrow() {
        return this.getParent() != null || this.myStep instanceof ClosableByLeftArrow;
    }

    @Override
    protected ActionMap getActionMap() {
        return this.myList.getActionMap();
    }

    @Override
    protected InputMap getInputMap() {
        return this.myList.getInputMap();
    }

    protected ListCellRenderer getListElementRenderer() {
        return new PopupListElementRenderer(this);
    }

    public ListPopupStep<Object> getListStep() {
        return (ListPopupStep)this.myStep;
    }

    @Override
    public void dispose() {
        this.myList.removeMouseMotionListener(this.myMouseMotionListener);
        this.myList.removeMouseListener(this.myMouseListener);
        super.dispose();
    }

    protected int getSelectedIndex() {
        return this.myList.getSelectedIndex();
    }

    protected Rectangle getCellBounds(int i2) {
        return this.myList.getCellBounds(i2, i2);
    }

    @Override
    public void disposeChildren() {
        this.setIndexForShowingChild(-1);
        super.disposeChildren();
    }

    @Override
    protected void onAutoSelectionTimer() {
        if (this.myList.getModel().getSize() > 0 && !this.myList.isSelectionEmpty()) {
            this.handleSelect(false);
        } else {
            this.disposeChildren();
            this.setIndexForShowingChild(-1);
        }
    }

    public void handleSelect(boolean handleFinalChoices) {
        this._handleSelect(handleFinalChoices, null);
    }

    public void handleSelect(boolean handleFinalChoices, InputEvent e2) {
        this._handleSelect(handleFinalChoices, e2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean _handleSelect(boolean handleFinalChoices, @Nullable InputEvent e2) {
        PopupStep nextStep;
        if (this.myList.getSelectedIndex() == -1) {
            return false;
        }
        if (this.getSpeedSearch().isHoldingFilter() && this.myList.getModel().getSize() == 0) {
            return false;
        }
        if (this.myList.getSelectedIndex() == this.getIndexForShowingChild()) {
            if (this.myChild != null && !this.myChild.isVisible()) {
                this.setIndexForShowingChild(-1);
            }
            return false;
        }
        Object[] selectedValues = this.myList.getSelectedValues();
        ListPopupStep<Object> listStep = this.getListStep();
        if (!listStep.isSelectable(selectedValues[0])) {
            return false;
        }
        if ((listStep instanceof MultiSelectionListPopupStep && !((MultiSelectionListPopupStep)listStep).hasSubstep(Arrays.asList(selectedValues)) || !listStep.hasSubstep(selectedValues[0])) && !handleFinalChoices) {
            return false;
        }
        this.disposeChildren();
        if (this.myListModel.getSize() == 0) {
            this.setFinalRunnable(this.myStep.getFinalRunnable());
            this.setOk(true);
            this.disposeAllParents(e2);
            this.setIndexForShowingChild(-1);
            return true;
        }
        this.valuesSelected(selectedValues);
        AtomicBoolean insideOnChosen = new AtomicBoolean(true);
        ApplicationManager.getApplication().invokeLater(() -> {
            if (insideOnChosen.get()) {
                LOG.error("Showing dialogs from popup onChosen can result in focus issues. Please put the handler into BaseStep.doFinalStep or PopupStep.getFinalRunnable.");
            }
        }, ModalityState.any());
        try {
            nextStep = listStep instanceof MultiSelectionListPopupStep ? ((MultiSelectionListPopupStep)listStep).onChosen(Arrays.asList(selectedValues), handleFinalChoices) : (e2 != null && listStep instanceof ListPopupStepEx ? ((ListPopupStepEx)listStep).onChosen(selectedValues[0], handleFinalChoices, e2.getModifiers()) : listStep.onChosen(selectedValues[0], handleFinalChoices));
        }
        finally {
            insideOnChosen.set(false);
        }
        return this.handleNextStep(nextStep, selectedValues.length == 1 ? selectedValues[0] : null, e2);
    }

    private void valuesSelected(Object[] values) {
        String filter2;
        if (this.shouldUseStatistics() && !StringUtil.isEmpty((String)(filter2 = this.getSpeedSearch().getFilter()))) {
            for (Object value2 : values) {
                String text2 = this.getListStep().getTextFor(value2);
                StatisticsManager.getInstance().incUseCount(new StatisticsInfo("#list_popup:" + this.getListStep().getTitle() + "#" + filter2, text2));
            }
        }
    }

    private boolean handleNextStep(PopupStep nextStep, Object parentValue, InputEvent e2) {
        if (nextStep != PopupStep.FINAL_CHOICE) {
            Point point = this.myList.indexToLocation(this.myList.getSelectedIndex());
            SwingUtilities.convertPointToScreen(point, (Component)((Object)this.myList));
            this.myChild = this.createPopup(this, nextStep, parentValue);
            if (this.myChild instanceof ListPopupImpl) {
                for (ListSelectionListener listener2 : this.myList.getListSelectionListeners()) {
                    ((ListPopupImpl)this.myChild).addListSelectionListener(listener2);
                }
            }
            JComponent container = this.getContent();
            assert (container != null) : "container == null";
            int y2 = point.y;
            if (parentValue != null && this.getListModel().isSeparatorAboveOf(parentValue)) {
                SeparatorWithText swt = new SeparatorWithText();
                swt.setCaption(this.getListModel().getCaptionAboveOf(parentValue));
                y2 += swt.getPreferredSize().height - 1;
            }
            this.myChild.show(container, point.x + container.getWidth() - 2, y2, true);
            this.setIndexForShowingChild(this.myList.getSelectedIndex());
            return false;
        }
        this.setOk(true);
        this.setFinalRunnable(this.myStep.getFinalRunnable());
        this.disposeAllParents(e2);
        this.setIndexForShowingChild(-1);
        return true;
    }

    public void addListSelectionListener(ListSelectionListener listSelectionListener) {
        this.myList.addListSelectionListener(listSelectionListener);
    }

    protected boolean isActionClick(MouseEvent e2) {
        return UIUtil.isActionClick((MouseEvent)e2, (int)502, (boolean)true);
    }

    public Object[] getSelectedValues() {
        return this.myList.getSelectedValues();
    }

    protected boolean handleFinalChoices(MouseEvent e2, Object selectedValue, ListPopupStep<Object> listStep) {
        return selectedValue == null || !listStep.hasSubstep(selectedValue) || !listStep.isSelectable(selectedValue) || !this.isOnNextStepButton(e2);
    }

    private boolean isOnNextStepButton(MouseEvent e2) {
        int index = this.myList.getSelectedIndex();
        Rectangle bounds = this.myList.getCellBounds(index, index);
        Point point = e2.getPoint();
        return bounds != null && point.getX() > (double)bounds.width + bounds.getX() - (double)AllIcons.Icons.Ide.NextStep.getIconWidth();
    }

    @Override
    protected void process(KeyEvent aEvent) {
        this.myList.processKeyEvent(aEvent);
    }

    private int getIndexForShowingChild() {
        return this.myIndexForShowingChild;
    }

    private void setIndexForShowingChild(int aIndexForShowingChild) {
        this.myIndexForShowingChild = aIndexForShowingChild;
    }

    @Override
    protected void onSpeedSearchPatternChanged() {
        this.myListModel.refilter();
        if (!(this.myListModel.getSize() <= 0 || this.shouldUseStatistics() && this.autoSelectUsingStatistics())) {
            this.selectBestMatch();
        }
    }

    private void selectBestMatch() {
        int fullMatchIndex = this.myListModel.getClosestMatchIndex();
        if (fullMatchIndex != -1) {
            this.myList.setSelectedIndex(fullMatchIndex);
        }
        if (this.myListModel.getSize() <= this.myList.getSelectedIndex() || !this.myListModel.isVisible(this.myList.getSelectedValue())) {
            this.myList.setSelectedIndex(0);
        }
    }

    @Override
    protected void onSelectByMnemonic(Object value2) {
        if (this.myListModel.isVisible(value2)) {
            this.myList.setSelectedValue(value2, true);
            this.myList.repaint();
            this.handleSelect(true);
        }
    }

    @Override
    protected JComponent getPreferredFocusableComponent() {
        return this.myList;
    }

    @Override
    protected void onChildSelectedFor(Object value2) {
        if (this.myList.getSelectedValue() != value2) {
            this.myList.setSelectedValue(value2, false);
        }
    }

    public void setHandleAutoSelectionBeforeShow(boolean autoHandle) {
        this.myAutoHandleBeforeShow = autoHandle;
    }

    @Override
    public boolean isModalContext() {
        return true;
    }

    @Override
    public void showInBestPositionFor(@NotNull Editor editor) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/ui/popup/list/ListPopupImpl", "showInBestPositionFor"));
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            this.handleSelect(true);
            if (!Disposer.isDisposed((Disposable)this)) {
                Disposer.dispose((Disposable)this);
            }
        } else {
            super.showInBestPositionFor(editor);
        }
    }

    private class MyList
    extends JBList
    implements DataProvider {
        public MyList() {
            super((ListModel)ListPopupImpl.this.myListModel);
            HintUpdateSupply.installSimpleHintUpdateSupply((JComponent)((Object)this));
        }

        public Dimension getPreferredScrollableViewportSize() {
            int size;
            Dimension result2 = super.getPreferredScrollableViewportSize();
            int rowCount = this.getVisibleRowCount();
            if (rowCount < (size = this.getModel().getSize())) {
                return result2;
            }
            result2.height = this.getPreferredSize().height;
            return result2;
        }

        public void processKeyEvent(KeyEvent e2) {
            e2.setSource((Object)this);
            super.processKeyEvent(e2);
        }

        protected void processMouseEvent(MouseEvent e2) {
            if (!ListPopupImpl.this.isMultiSelectionEnabled() && (e2.getModifiers() & Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()) != 0) {
                e2.consume();
            }
            if (UIUtil.isActionClick((MouseEvent)e2, (int)501) && ListPopupImpl.this.isOnNextStepButton(e2)) {
                e2.consume();
            }
            super.processMouseEvent(e2);
        }

        public Object getData(String dataId) {
            if (PlatformDataKeys.SELECTED_ITEM.is(dataId)) {
                return ListPopupImpl.this.myList.getSelectedValue();
            }
            if (PlatformDataKeys.SELECTED_ITEMS.is(dataId)) {
                return ListPopupImpl.this.myList.getSelectedValues();
            }
            if (PlatformDataKeys.SPEED_SEARCH_COMPONENT.is(dataId) && ListPopupImpl.this.mySpeedSearchPatternField != null && ListPopupImpl.this.mySpeedSearchPatternField.isVisible()) {
                return ListPopupImpl.this.mySpeedSearchPatternField;
            }
            return null;
        }
    }

    private class MyMouseListener
    extends MouseAdapter {
        private MyMouseListener() {
        }

        @Override
        public void mouseReleased(MouseEvent e2) {
            if (!ListPopupImpl.this.isActionClick(e2) || ListPopupImpl.this.isMultiSelectionEnabled() && UIUtil.isSelectionButtonDown((MouseEvent)e2)) {
                return;
            }
            IdeEventQueue.getInstance().blockNextEvents(e2);
            Object selectedValue = ListPopupImpl.this.myList.getSelectedValue();
            ListPopupStep<Object> listStep = ListPopupImpl.this.getListStep();
            ListPopupImpl.this.handleSelect(ListPopupImpl.this.handleFinalChoices(e2, selectedValue, listStep), e2);
            ListPopupImpl.this.stopTimer();
        }
    }

    private class MyMouseMotionListener
    extends MouseMotionAdapter {
        private int myLastSelectedIndex = -2;
        private Point myLastMouseLocation;

        private MyMouseMotionListener() {
        }

        private boolean isMouseMoved(Point location) {
            if (this.myLastMouseLocation == null) {
                this.myLastMouseLocation = location;
                return false;
            }
            return !this.myLastMouseLocation.equals(location);
        }

        @Override
        public void mouseMoved(MouseEvent e2) {
            if (!this.isMouseMoved(e2.getLocationOnScreen())) {
                return;
            }
            Point point = e2.getPoint();
            int index = ListPopupImpl.this.myList.locationToIndex(point);
            if (index != this.myLastSelectedIndex) {
                if (!ListPopupImpl.this.isMultiSelectionEnabled() || !UIUtil.isSelectionButtonDown((MouseEvent)e2) && ListPopupImpl.this.myList.getSelectedIndices().length <= 1) {
                    ListPopupImpl.this.myList.setSelectedIndex(index);
                }
                ListPopupImpl.this.restartTimer();
                this.myLastSelectedIndex = index;
            }
            ListPopupImpl.this.notifyParentOnChildSelection();
        }
    }
}

