/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.popup.list;

import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.ListSeparator;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.speedSearch.ElementFilter;
import com.intellij.ui.speedSearch.SpeedSearch;
import com.intellij.util.ObjectUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractListModel;
import org.jetbrains.annotations.Nullable;

public class ListPopupModel
extends AbstractListModel {
    private final List<Object> myOriginalList;
    private final List<Object> myFilteredList = new ArrayList<Object>();
    private final ElementFilter myFilter;
    private final ListPopupStep myStep;
    private int myFullMatchIndex = -1;
    private int myStartsWithIndex = -1;
    private final SpeedSearch mySpeedSearch;
    private final Map<Object, ListSeparator> mySeparators = new HashMap<Object, ListSeparator>();

    public ListPopupModel(ElementFilter filter2, SpeedSearch speedSearch, ListPopupStep step) {
        this.myFilter = filter2;
        this.myStep = step;
        this.mySpeedSearch = speedSearch;
        this.myOriginalList = new ArrayList<Object>(step.getValues());
        this.rebuildLists();
    }

    public void deleteItem(Object item) {
        int i2 = this.myOriginalList.indexOf(item);
        if (i2 >= 0) {
            this.myOriginalList.remove(i2);
            this.rebuildLists();
            this.fireContentsChanged(this, 0, this.myFilteredList.size());
        }
    }

    @Nullable
    public Object get(int i2) {
        if (i2 >= 0 && i2 < this.myFilteredList.size()) {
            return this.myFilteredList.get(i2);
        }
        return null;
    }

    private void rebuildLists() {
        this.myFilteredList.clear();
        this.mySeparators.clear();
        this.myFullMatchIndex = -1;
        this.myStartsWithIndex = -1;
        ListSeparator lastSeparator = null;
        for (Object each : this.myOriginalList) {
            lastSeparator = (ListSeparator)ObjectUtils.chooseNotNull((Object)this.myStep.getSeparatorAbove(each), lastSeparator);
            if (!this.myFilter.shouldBeShowing(each)) continue;
            this.addToFiltered(each);
            if (lastSeparator == null) continue;
            this.mySeparators.put(each, lastSeparator);
            lastSeparator = null;
        }
    }

    private void addToFiltered(Object each) {
        this.myFilteredList.add(each);
        String filterString = StringUtil.toUpperCase((String)this.mySpeedSearch.getFilter());
        String candidateString = StringUtil.toUpperCase((String)this.myStep.getTextFor(each));
        int index = this.myFilteredList.size() - 1;
        if (this.myFullMatchIndex == -1 && filterString.equals(candidateString)) {
            this.myFullMatchIndex = index;
        }
        if (this.myStartsWithIndex == -1 && candidateString.startsWith(filterString)) {
            this.myStartsWithIndex = index;
        }
    }

    @Override
    public int getSize() {
        return this.myFilteredList.size();
    }

    @Override
    public Object getElementAt(int index) {
        if (index >= this.myFilteredList.size()) {
            return null;
        }
        return this.myFilteredList.get(index);
    }

    public boolean isSeparatorAboveOf(Object aValue) {
        return this.getSeparatorAbove(aValue) != null;
    }

    public String getCaptionAboveOf(Object value2) {
        ListSeparator separator = this.getSeparatorAbove(value2);
        if (separator != null) {
            return separator.getText();
        }
        return "";
    }

    private ListSeparator getSeparatorAbove(Object value2) {
        return this.mySeparators.get(value2);
    }

    public void refilter() {
        this.rebuildLists();
        if (this.myFilteredList.isEmpty() && !this.myOriginalList.isEmpty()) {
            this.mySpeedSearch.noHits();
        }
        this.fireContentsChanged(this, 0, this.myFilteredList.size());
    }

    public boolean isVisible(Object object) {
        return this.myFilteredList.contains(object);
    }

    public int getClosestMatchIndex() {
        return this.myFullMatchIndex != -1 ? this.myFullMatchIndex : this.myStartsWithIndex;
    }

    public void updateOriginalList() {
        this.myOriginalList.clear();
        this.myOriginalList.addAll(this.myStep.getValues());
        this.refilter();
    }
}

