/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.stripe;

import com.intellij.ui.stripe.ErrorStripe;
import com.intellij.util.ui.RegionPainter;
import java.awt.AlphaComposite;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.util.Iterator;
import java.util.TreeSet;

public class ErrorStripePainter
extends RegionPainter.Image {
    private final boolean mySingleValue;
    private final Alignment myAlignment;
    private Value[] myArray;
    private int myArraySize;
    private int myImageY;
    private int myImageHeight;
    private int myMax = Integer.MAX_VALUE;
    private int myMin = 1;
    private int myGap;

    public ErrorStripePainter(boolean single) {
        this(single, Alignment.CENTER);
    }

    public ErrorStripePainter(boolean single, Alignment style) {
        this.mySingleValue = single;
        this.myAlignment = style;
    }

    public int getMaximalThickness() {
        return this.myMax;
    }

    public void setMaximalThickness(int thickness) {
        if (this.myMax != thickness) {
            this.myMax = thickness;
            this.invalidate();
        }
    }

    public int getMinimalThickness() {
        return this.myMin;
    }

    public void setMinimalThickness(int thickness) {
        if (thickness < 1) {
            thickness = 1;
        }
        if (this.myMin != thickness) {
            this.myMin = thickness;
            this.invalidate();
        }
    }

    public int getErrorStripeGap() {
        return this.myGap;
    }

    public void setErrorStripeGap(int gap) {
        if (gap < 0) {
            gap = 0;
        }
        if (this.myGap != gap) {
            this.myGap = gap;
            this.invalidate();
        }
    }

    public int findIndex(int x2, int y2) {
        int index;
        if (0 < this.myImageHeight && this.myImageY <= y2 && (index = this.myArraySize * (y2 - this.myImageY) / this.myImageHeight) < this.myArraySize) {
            return index;
        }
        return -1;
    }

    public int getErrorStripeCount() {
        return this.myArraySize;
    }

    public void setErrorStripeCount(int count) {
        if (count < 0) {
            count = 0;
        }
        if (this.myArray == null) {
            this.myArray = new Value[count];
        } else if (this.myArray.length < count) {
            Value[] old = this.myArray;
            this.myArray = new Value[count];
            System.arraycopy(old, 0, this.myArray, 0, old.length);
        }
        if (this.myArraySize != count) {
            this.myArraySize = count;
            this.invalidate();
        }
    }

    public boolean isModified() {
        for (int index = 0; index < this.myArraySize; ++index) {
            Value value2 = this.myArray[index];
            if (value2 == null || !value2.myModified) continue;
            return true;
        }
        return false;
    }

    public void clear() {
        for (int index = 0; index < this.myArraySize; ++index) {
            Value value2 = this.myArray[index];
            if (value2 == null) continue;
            value2.set(null);
        }
    }

    public void clear(int index) {
        Value value2 = this.getValue(index, false);
        if (value2 != null) {
            value2.set(null);
        }
    }

    public ErrorStripe getErrorStripe(int index) {
        Value value2 = this.getValue(index, false);
        return value2 == null ? null : value2.get();
    }

    public void setErrorStripe(int index, ErrorStripe stripe) {
        Value value2 = this.getValue(index, stripe != null);
        if (value2 != null) {
            value2.set(stripe);
        }
    }

    public void addErrorStripe(int index, ErrorStripe stripe) {
        Value value2 = this.getValue(index, stripe != null);
        if (value2 != null) {
            value2.add(stripe);
        }
    }

    private Value getValue(int index, boolean create2) {
        if (0 > index || index >= this.myArraySize) {
            return null;
        }
        if (create2 && null == this.myArray[index]) {
            this.myArray[index] = this.mySingleValue ? new SingleValue() : new ComplexValue();
        }
        return this.myArray[index];
    }

    private int getOffset(int height, int thickness) {
        if (height > thickness) {
            if (this.myAlignment == Alignment.CENTER) {
                return (height - thickness) / 2;
            }
            if (this.myAlignment == Alignment.BOTTOM) {
                return height - thickness;
            }
        }
        return 0;
    }

    private void updateImage(BufferedImage image, boolean force) {
        int width = image.getWidth();
        int height = image.getHeight();
        Graphics2D g2 = image.createGraphics();
        this.myImageHeight = 0;
        int max = height / this.myArraySize;
        int min = this.myMin + this.myGap;
        if (max < min) {
            max = height / min;
            int currentIndex = 0;
            SingleValue currentValue = new SingleValue();
            for (int index = 0; index < this.myArraySize; ++index) {
                Value value2 = this.myArray[index];
                int i2 = index * max / this.myArraySize;
                if (i2 > currentIndex) {
                    currentValue.paint(g2, 0, this.myImageHeight, width, min, force);
                    this.myImageHeight += min;
                    currentIndex = i2;
                    currentValue.myStripe = value2 == null ? null : value2.get();
                    currentValue.myModified = value2 != null && value2.myModified;
                } else if (value2 != null) {
                    ErrorStripe stripe = value2.get();
                    if (stripe != null && stripe.compareTo(currentValue.myStripe) < 0) {
                        currentValue.myStripe = stripe;
                    }
                    if (value2.myModified) {
                        currentValue.myModified = true;
                    }
                }
                if (value2 == null) continue;
                value2.myModified = false;
            }
            currentValue.paint(g2, 0, this.myImageHeight, width, min, force);
            this.myImageHeight += min;
        } else {
            if (max > this.myMax) {
                max = Math.max(this.myMax, min);
            }
            for (int index = 0; index < this.myArraySize; ++index) {
                Value value3 = this.myArray[index];
                if (value3 != null) {
                    value3.paint(g2, 0, this.myImageHeight, width, max, force);
                    value3.myModified = false;
                }
                this.myImageHeight += max;
            }
        }
        g2.dispose();
    }

    protected void updateImage(BufferedImage image) {
        if (this.isModified()) {
            this.updateImage(image, false);
        }
    }

    protected BufferedImage createImage(int width, int height) {
        BufferedImage image;
        BufferedImage bufferedImage = image = this.myArraySize == 0 ? null : super.createImage(width, height);
        if (image != null) {
            this.updateImage(image, true);
        }
        return image;
    }

    public void paint(Graphics2D g2, int x2, int y2, int width, int height, Object object) {
        this.myImageY = y2;
        super.paint(g2, x2, y2, width, height, object);
    }

    private final class ComplexValue
    extends Value {
        private TreeSet<ErrorStripe> mySet;

        private ComplexValue() {
        }

        @Override
        boolean set(ErrorStripe stripe) {
            if (this.add(stripe)) {
                return true;
            }
            if (this.mySet == null || this.mySet.isEmpty()) {
                return false;
            }
            this.mySet.clear();
            this.myModified = true;
            return true;
        }

        @Override
        boolean add(ErrorStripe stripe) {
            if (stripe == null) {
                return false;
            }
            if (this.mySet == null) {
                this.mySet = new TreeSet();
            }
            this.mySet.add(stripe);
            this.myModified = true;
            return true;
        }

        @Override
        ErrorStripe get() {
            if (this.mySet == null) {
                return null;
            }
            Iterator<ErrorStripe> iterator2 = this.mySet.iterator();
            return iterator2.hasNext() ? iterator2.next() : null;
        }

        @Override
        void paint(Graphics2D g2, int x2, int y2, int width, int height) {
            Iterator<ErrorStripe> iterator2;
            if (this.mySet != null && (iterator2 = this.mySet.iterator()).hasNext()) {
                int thickness;
                int n2 = thickness = ErrorStripePainter.this.myAlignment != null ? ErrorStripePainter.this.myMin + ErrorStripePainter.this.myGap : height;
                if (thickness < height) {
                    int count = Math.min(height / thickness, this.mySet.size());
                    y2 += ErrorStripePainter.this.getOffset(height, thickness * count);
                    do {
                        g2.setColor(iterator2.next().getColor());
                        g2.fillRect(x2, y2, width, thickness - ErrorStripePainter.this.myGap);
                        y2 += thickness;
                    } while (--count > 0 && iterator2.hasNext());
                } else {
                    g2.setColor(iterator2.next().getColor());
                    g2.fillRect(x2, y2, width, thickness - ErrorStripePainter.this.myGap);
                }
            }
        }
    }

    private final class SingleValue
    extends Value {
        private ErrorStripe myStripe;

        private SingleValue() {
        }

        @Override
        boolean set(ErrorStripe stripe) {
            if (stripe == null ? this.myStripe == null : stripe.equals(this.myStripe)) {
                return false;
            }
            this.myStripe = stripe;
            this.myModified = true;
            return true;
        }

        @Override
        boolean add(ErrorStripe stripe) {
            if (stripe == null || stripe.compareTo(this.myStripe) >= 0) {
                return false;
            }
            this.myStripe = stripe;
            this.myModified = true;
            return true;
        }

        @Override
        ErrorStripe get() {
            return this.myStripe;
        }

        @Override
        void paint(Graphics2D g2, int x2, int y2, int width, int height) {
            if (this.myStripe != null) {
                int thickness = ErrorStripePainter.this.myAlignment != null ? ErrorStripePainter.this.myMin + ErrorStripePainter.this.myGap : height;
                g2.setColor(this.myStripe.getColor());
                g2.fillRect(x2, y2 += ErrorStripePainter.this.getOffset(height, thickness), width, thickness - ErrorStripePainter.this.myGap);
            }
        }
    }

    private static abstract class Value {
        boolean myModified;

        private Value() {
        }

        abstract boolean set(ErrorStripe var1);

        abstract boolean add(ErrorStripe var1);

        abstract ErrorStripe get();

        abstract void paint(Graphics2D var1, int var2, int var3, int var4, int var5);

        void paint(Graphics2D g2, int x2, int y2, int width, int height, boolean force) {
            if (force || this.myModified) {
                if (!force) {
                    Composite old = g2.getComposite();
                    g2.setComposite(AlphaComposite.Clear);
                    g2.fillRect(x2, y2, width, height);
                    g2.setComposite(old);
                }
                this.paint(g2, x2, y2, width, height);
            }
        }
    }

    public static enum Alignment {
        TOP,
        CENTER,
        BOTTOM;

    }
}

