/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.stripe;

import com.intellij.ui.stripe.ErrorStripe;
import com.intellij.ui.stripe.ErrorStripePainter;
import java.awt.Graphics2D;

public class ExtraErrorStripePainter
extends ErrorStripePainter {
    private final ErrorStripePainter myPainter = new ErrorStripePainter(true, null);
    private boolean myGroupSwap;
    private Integer myGroupGap;

    public ExtraErrorStripePainter(boolean single) {
        super(single);
    }

    public boolean isGroupSwap() {
        return this.myGroupSwap;
    }

    public void setGroupSwap(boolean swap) {
        this.myGroupSwap = swap;
    }

    public int getGroupGap() {
        return this.myGroupGap != null ? this.myGroupGap.intValue() : this.getMinimalThickness();
    }

    public void setGroupGap(int gap) {
        this.myGroupGap = gap;
    }

    @Override
    public void setMaximalThickness(int thickness) {
        super.setMaximalThickness(thickness);
        this.myPainter.setMaximalThickness(this.getMaximalThickness());
    }

    @Override
    public void setMinimalThickness(int thickness) {
        super.setMinimalThickness(thickness);
        this.myPainter.setMinimalThickness(this.getMinimalThickness() + this.getErrorStripeGap());
    }

    @Override
    public void setErrorStripeGap(int gap) {
        super.setErrorStripeGap(gap);
        this.myPainter.setMinimalThickness(this.getMinimalThickness() + this.getErrorStripeGap());
    }

    @Override
    public void setErrorStripeCount(int count) {
        super.setErrorStripeCount(count);
        this.myPainter.setErrorStripeCount(count);
    }

    public void setExtraStripe(int index, ErrorStripe stripe) {
        this.myPainter.setErrorStripe(index, stripe);
    }

    @Override
    public void paint(Graphics2D g2, int x2, int y2, int width, int height, Object object) {
        int min = this.getMinimalThickness();
        int gap = this.myGroupGap == null ? min : this.myGroupGap;
        int pos = x2;
        if (this.myGroupSwap) {
            pos += width - min;
        } else {
            x2 += gap + min;
        }
        this.myPainter.paint(g2, pos, y2, min, height, object);
        super.paint(g2, x2, y2, width - gap - min, height, object);
    }
}

