/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.tabs;

import com.intellij.ide.ui.OptionsTopHitProvider;
import com.intellij.ide.ui.PublicMethodBasedOptionDescription;
import com.intellij.ide.ui.UISettings;
import com.intellij.ide.ui.search.BooleanOptionDescription;
import com.intellij.openapi.project.Project;
import com.intellij.ui.FileColorManager;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class FileColorsOptionsTopHitProvider
extends OptionsTopHitProvider {
    @Override
    public String getId() {
        return "appearance";
    }

    @Override
    @NotNull
    public Collection<BooleanOptionDescription> getOptions(@Nullable Project project2) {
        FileColorManager manager;
        if (project2 != null && (manager = FileColorManager.getInstance((Project)project2)) != null) {
            Option enabled = new Option(manager, "File Colors enabled", "isEnabled", "setEnabled");
            Collection<Option> collection = !enabled.isOptionEnabled() ? Collections.singletonList(enabled) : Collections.unmodifiableCollection(Arrays.asList(new BooleanOptionDescription[]{enabled, new Option(manager, "Use File Colors in Editor Tabs", "isEnabledForTabs", "setEnabledForTabs"), new Option(manager, "Use File Colors in Project View", "isEnabledForProjectView", "setEnabledForProjectView")}));
            if (collection == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/tabs/FileColorsOptionsTopHitProvider", "getOptions"));
            }
            return collection;
        }
        List<BooleanOptionDescription> list2 = Collections.emptyList();
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/tabs/FileColorsOptionsTopHitProvider", "getOptions"));
        }
        return list2;
    }

    private static class Option
    extends PublicMethodBasedOptionDescription {
        private final FileColorManager myManager;

        public Option(FileColorManager manager, String option, String getter, String setter) {
            super(option, "reference.settings.ide.settings.file-colors", getter, setter);
            this.myManager = manager;
        }

        public Object getInstance() {
            return this.myManager;
        }

        protected void fireUpdated() {
            UISettings.getInstance().fireUISettingsChanged();
        }
    }
}

