/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.tree;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.ui.tree.MapBasedTree;
import com.intellij.util.concurrency.Command;
import com.intellij.util.concurrency.Invoker;
import com.intellij.util.concurrency.InvokerSupplier;
import com.intellij.util.ui.tree.AbstractTreeModel;
import com.intellij.util.ui.tree.TreeModelAdapter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;

public class AsyncTreeModel
extends AbstractTreeModel
implements Disposable {
    private static final Logger LOG = Logger.getInstance(AsyncTreeModel.class);
    private final CmdGetRoot rootLoader;
    private final AtomicBoolean rootLoaded;
    private final Command.Processor processor;
    private final MapBasedTree<Object, Object> tree;
    private final TreeModel model;
    private final TreeModelListener listener;

    public AsyncTreeModel(@NotNull TreeModel model2) {
        Invoker.EDT foreground;
        if (model2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/ui/tree/AsyncTreeModel", "<init>"));
        }
        this.rootLoader = new CmdGetRoot("Load root", null);
        this.rootLoaded = new AtomicBoolean();
        this.tree = new MapBasedTree<Object, Object>(true, object -> object);
        this.listener = new TreeModelAdapter(){

            protected void process(TreeModelEvent event, TreeModelAdapter.EventType type) {
                TreePath path = event.getTreePath();
                if (path == null) {
                    AsyncTreeModel.this.processor.process(AsyncTreeModel.this.rootLoader);
                    return;
                }
                Object object = path.getLastPathComponent();
                if (path.getParentPath() == null && type == TreeModelAdapter.EventType.StructureChanged) {
                    AsyncTreeModel.this.processor.process(new CmdGetRoot("Update root", object));
                    return;
                }
                ((AsyncTreeModel)AsyncTreeModel.this).processor.foreground.invokeLaterIfNeeded(() -> {
                    MapBasedTree.Entry<Object> entry = AsyncTreeModel.this.tree.findEntry(object);
                    if (entry == null || entry.isLoadingRequired()) {
                        LOG.debug("ignore updating of nonexistent node: ", new Object[]{object});
                    } else if (type == TreeModelAdapter.EventType.NodesChanged) {
                        AsyncTreeModel.this.treeNodesChanged(event.getTreePath(), event.getChildIndices(), event.getChildren());
                    } else if (type == TreeModelAdapter.EventType.NodesInserted) {
                        AsyncTreeModel.this.processor.process(new CmdGetChildren("Insert children", entry, false));
                    } else if (type == TreeModelAdapter.EventType.NodesRemoved) {
                        AsyncTreeModel.this.processor.process(new CmdGetChildren("Remove children", entry, false));
                    } else {
                        AsyncTreeModel.this.processor.process(new CmdGetChildren("Update children", entry, true));
                    }
                });
            }
        };
        if (model2 instanceof Disposable) {
            Disposer.register((Disposable)this, (Disposable)((Disposable)model2));
        }
        Invoker background = foreground = new Invoker.EDT(this);
        if (model2 instanceof InvokerSupplier) {
            InvokerSupplier supplier = (InvokerSupplier)((Object)model2);
            background = supplier.getInvoker();
        }
        this.processor = new Command.Processor(foreground, background);
        this.model = model2;
        this.model.addTreeModelListener(this.listener);
    }

    public void dispose() {
        this.model.removeTreeModelListener(this.listener);
    }

    public Object getRoot() {
        MapBasedTree.Entry<Object> entry;
        if (!this.isValidThread()) {
            return null;
        }
        if (!this.rootLoaded.getAndSet(true)) {
            this.processor.process(this.rootLoader);
        }
        return (entry = this.tree.getRootEntry()) == null ? null : entry.getNode();
    }

    public Object getChild(Object object, int index) {
        MapBasedTree.Entry<Object> entry = this.getEntry(object, true);
        return entry == null ? null : entry.getChild(index);
    }

    public int getChildCount(Object object) {
        MapBasedTree.Entry<Object> entry = this.getEntry(object, true);
        return entry == null ? 0 : entry.getChildCount();
    }

    public boolean isLeaf(Object object) {
        MapBasedTree.Entry<Object> entry = this.getEntry(object, false);
        return entry == null || entry.isLeaf();
    }

    public void valueForPathChanged(TreePath path, Object value2) {
        this.processor.background.invokeLaterIfNeeded(() -> this.model.valueForPathChanged(path, value2));
    }

    public int getIndexOfChild(Object object, Object child) {
        MapBasedTree.Entry<Object> entry = this.getEntry(object, true);
        return entry == null ? -1 : entry.getIndexOf(child);
    }

    protected Object createLoadingNode() {
        return null;
    }

    private boolean isValidThread() {
        if (this.processor.foreground.isValidThread()) {
            return true;
        }
        LOG.warn("AsyncTreeModel is used from unexpected thread");
        return false;
    }

    private MapBasedTree.Entry<Object> getEntry(Object object, boolean loadChildren) {
        MapBasedTree.Entry<Object> entry;
        MapBasedTree.Entry<Object> entry2 = entry = object == null || !this.isValidThread() ? null : this.tree.findEntry(object);
        if (entry != null && loadChildren && entry.isLoadingRequired()) {
            this.loadChildren(entry, true);
        }
        return entry;
    }

    private void loadChildren(MapBasedTree.Entry<Object> entry, boolean insertLoadingNode) {
        String name;
        String string2 = name = insertLoadingNode ? "Load children" : "Reload children";
        if (insertLoadingNode) {
            entry.setLoadingChildren(this.createLoadingNode());
        }
        this.processor.process(new CmdGetChildren(name, entry, true));
    }

    private final class CmdGetChildren
    implements Command<List<Pair<Object, Boolean>>> {
        private final String name;
        private final MapBasedTree.Entry<Object> entry;
        private final boolean deep;

        public CmdGetChildren(String name, MapBasedTree.Entry<Object> entry, boolean deep) {
            this.name = name;
            this.entry = entry;
            this.deep = deep;
        }

        public String toString() {
            return this.name + ": " + this.entry.getNode();
        }

        @Override
        public List<Pair<Object, Boolean>> get() {
            Object object = this.entry.getNode();
            if (AsyncTreeModel.this.model.isLeaf(object)) {
                return null;
            }
            int count = AsyncTreeModel.this.model.getChildCount(object);
            if (count <= 0) {
                return Collections.emptyList();
            }
            ArrayList<Pair> children2 = new ArrayList<Pair>(count);
            for (int i2 = 0; i2 < count; ++i2) {
                Object child = AsyncTreeModel.this.model.getChild(object, i2);
                children2.add(Pair.create((Object)child, (Object)AsyncTreeModel.this.model.isLeaf(child)));
            }
            return Collections.unmodifiableList(children2);
        }

        @Override
        public void accept(List<Pair<Object, Boolean>> children2) {
            boolean contained;
            Object object = this.entry.getNode();
            if (this.entry != AsyncTreeModel.this.tree.findEntry(object)) {
                LOG.debug("ignore updating of changed node: ", new Object[]{object});
                return;
            }
            boolean isLoadingRequired = this.entry.isLoadingRequired();
            MapBasedTree.UpdateResult<Object> update2 = AsyncTreeModel.this.tree.update(this.entry, children2);
            if (isLoadingRequired) {
                return;
            }
            boolean removed = !update2.getRemoved().isEmpty();
            boolean inserted = !update2.getInserted().isEmpty();
            boolean bl = contained = !update2.getContained().isEmpty();
            if (!(removed || inserted || contained)) {
                return;
            }
            if (!this.deep || !contained) {
                if (!removed && inserted) {
                    if (AsyncTreeModel.this.listeners.isEmpty()) {
                        return;
                    }
                    AsyncTreeModel.this.listeners.treeNodesInserted(update2.getEvent((Object)AsyncTreeModel.this, this.entry, update2.getInserted()));
                    return;
                }
                if (!inserted && removed) {
                    if (AsyncTreeModel.this.listeners.isEmpty()) {
                        return;
                    }
                    AsyncTreeModel.this.listeners.treeNodesRemoved(update2.getEvent((Object)AsyncTreeModel.this, this.entry, update2.getRemoved()));
                    return;
                }
            }
            AsyncTreeModel.this.treeStructureChanged(this.entry, null, null);
            for (MapBasedTree.Entry<Object> entry : update2.getContained()) {
                if (entry.isLoadingRequired()) continue;
                AsyncTreeModel.this.loadChildren(entry, false);
            }
        }
    }

    private final class CmdGetRoot
    implements Command<Pair<Object, Boolean>> {
        private final String name;
        private final Object root;

        public CmdGetRoot(String name, Object root) {
            this.name = name;
            this.root = root;
        }

        public String toString() {
            return this.root == null ? this.name : this.name + ": " + this.root;
        }

        @Override
        public Pair<Object, Boolean> get() {
            Object object = this.root != null ? this.root : AsyncTreeModel.this.model.getRoot();
            return Pair.create((Object)object, (Object)AsyncTreeModel.this.model.isLeaf(object));
        }

        @Override
        public void accept(Pair<Object, Boolean> root) {
            boolean updated = AsyncTreeModel.this.tree.updateRoot(root);
            MapBasedTree.Entry entry = AsyncTreeModel.this.tree.getRootEntry();
            if (updated) {
                AsyncTreeModel.this.treeStructureChanged(entry, null, null);
            }
            if (entry != null) {
                AsyncTreeModel.this.loadChildren(entry, entry.isLoadingRequired());
            }
        }
    }
}

