/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.win;

import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.ui.win.Task;
import com.intellij.util.lang.UrlClassLoader;
import java.lang.ref.WeakReference;
import java.util.concurrent.atomic.AtomicBoolean;

public class RecentTasks {
    private static AtomicBoolean initialized = new AtomicBoolean(false);
    private static final WeakReference<Thread> openerThread = new WeakReference<Thread>(Thread.currentThread());
    private static final String openerThreadName = Thread.currentThread().getName();

    private static synchronized void init() {
        if (initialized.get()) {
            return;
        }
        RecentTasks.initialize(ApplicationInfoEx.getInstanceEx().getVersionName() + "." + PathManager.getConfigPath().hashCode());
        initialized.set(true);
    }

    private static native void initialize(String var0);

    private static native void addTasksNativeForCategory(String var0, Task[] var1);

    static native String getShortenPath(String var0);

    private static native void clearNative();

    public static synchronized void clear() {
        RecentTasks.init();
        RecentTasks.checkThread();
        RecentTasks.clearNative();
    }

    public static synchronized void addTasks(Task[] tasks) {
        if (tasks.length == 0) {
            return;
        }
        RecentTasks.init();
        RecentTasks.checkThread();
        RecentTasks.addTasksNativeForCategory("Recent", tasks);
    }

    private static void checkThread() {
        Thread t2 = (Thread)openerThread.get();
        if (t2 == null || !t2.equals(Thread.currentThread())) {
            throw new RuntimeException("Current thread is " + Thread.currentThread().getName() + "This class has to be used from " + openerThreadName + " thread");
        }
    }

    static {
        UrlClassLoader.loadPlatformLibrary((String)"jumpListBridge");
    }
}

