/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.UserDataHolderEx;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.ParameterizedCachedValue;
import com.intellij.psi.util.ParameterizedCachedValueProvider;
import com.intellij.util.CachedValueBase;
import com.intellij.util.CachedValueLeakChecker;
import com.intellij.util.CachedValuesFactory;
import com.intellij.util.DefaultCachedValuesFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CachedValuesManagerImpl
extends CachedValuesManager {
    private final Project myProject;
    private final CachedValuesFactory myFactory;

    public CachedValuesManagerImpl(Project project2, CachedValuesFactory factory2) {
        this.myProject = project2;
        this.myFactory = factory2 == null ? new DefaultCachedValuesFactory(project2) : factory2;
    }

    @NotNull
    public <T> CachedValue<T> createCachedValue(@NotNull CachedValueProvider<T> provider, boolean trackValue) {
        if (provider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "provider", "com/intellij/util/CachedValuesManagerImpl", "createCachedValue"));
        }
        CachedValue<T> cachedValue = this.myFactory.createCachedValue(provider, trackValue);
        if (cachedValue == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/CachedValuesManagerImpl", "createCachedValue"));
        }
        return cachedValue;
    }

    @NotNull
    public <T, P> ParameterizedCachedValue<T, P> createParameterizedCachedValue(@NotNull ParameterizedCachedValueProvider<T, P> provider, boolean trackValue) {
        if (provider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "provider", "com/intellij/util/CachedValuesManagerImpl", "createParameterizedCachedValue"));
        }
        ParameterizedCachedValue<T, P> parameterizedCachedValue = this.myFactory.createParameterizedCachedValue(provider, trackValue);
        if (parameterizedCachedValue == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/CachedValuesManagerImpl", "createParameterizedCachedValue"));
        }
        return parameterizedCachedValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public <T, D extends UserDataHolder> T getCachedValue(@NotNull D dataHolder, @NotNull Key<CachedValue<T>> key, @NotNull CachedValueProvider<T> provider, boolean trackValue) {
        CachedValue value2;
        if (dataHolder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataHolder", "com/intellij/util/CachedValuesManagerImpl", "getCachedValue"));
        }
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/util/CachedValuesManagerImpl", "getCachedValue"));
        }
        if (provider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "provider", "com/intellij/util/CachedValuesManagerImpl", "getCachedValue"));
        }
        CachedValueLeakChecker.checkProvider(provider, key, dataHolder);
        if (dataHolder instanceof UserDataHolderEx) {
            UserDataHolderEx dh = (UserDataHolderEx)dataHolder;
            value2 = (CachedValue)dh.getUserData(key);
            while (this.isOutdated(value2)) {
                if (dh.replace(key, (Object)value2, null)) {
                    value2 = null;
                    break;
                }
                value2 = (CachedValue)dh.getUserData(key);
            }
            if (value2 == null) {
                value2 = this.createCachedValue(provider, trackValue);
                assert (((CachedValueBase)value2).isFromMyProject(this.myProject));
                value2 = (CachedValue)dh.putUserDataIfAbsent(key, (Object)value2);
            }
        } else {
            D d2 = dataHolder;
            synchronized (d2) {
                value2 = (CachedValue)dataHolder.getUserData(key);
                if (this.isOutdated(value2)) {
                    value2 = null;
                }
                if (value2 == null) {
                    value2 = this.createCachedValue(provider, trackValue);
                    dataHolder.putUserData(key, (Object)value2);
                }
            }
        }
        return (T)value2.getValue();
    }

    private boolean isOutdated(CachedValue<?> value2) {
        return value2 instanceof CachedValueBase && (!((CachedValueBase)value2).isFromMyProject(this.myProject) || CachedValuesManagerImpl.hasOutdatedValue((CachedValueBase)value2));
    }

    private static boolean hasOutdatedValue(CachedValueBase base) {
        return !base.hasUpToDateValue() && base.getRawData() != null;
    }

    public Project getProject() {
        return this.myProject;
    }
}

