/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.idea.ActionsBundle;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.project.DumbAware;
import com.intellij.util.ProfilingUtil;

public class CaptureAllocationsAction
extends ToggleAction
implements DumbAware {
    private boolean myCapturing = false;

    public boolean isSelected(AnActionEvent e2) {
        return this.myCapturing;
    }

    public void setSelected(AnActionEvent e2, boolean state) {
        try {
            if (!this.myCapturing) {
                this.myCapturing = true;
                ProfilingUtil.startRecordAllocations();
            } else {
                this.myCapturing = false;
                String dumpPath = ProfilingUtil.stopRecordAllocations();
                ProfilingUtil.copySnapshotAndNotify(dumpPath, e2.getProject());
            }
        }
        catch (Exception ex) {
            ProfilingUtil.notifyCapturingError(ex, e2.getProject());
        }
    }

    public void update(AnActionEvent e2) {
        Presentation presentation = e2.getPresentation();
        presentation.setVisible(ProfilingUtil.hasValidController());
        presentation.setEnabled(ProfilingUtil.canCaptureAllocations());
        presentation.setText(ActionsBundle.message((String)(this.myCapturing ? "stop.capture.allocations.data.action.name" : "action.CaptureAllocations.text"), (Object[])new Object[0]));
        super.update(e2);
    }
}

